/*
 * Decompiled with CFR 0.152.
 */
package com.github.L_Ender.cataclysm.entity.projectile;

import com.github.L_Ender.cataclysm.config.CMConfig;
import com.github.L_Ender.cataclysm.init.ModEntities;
import com.github.L_Ender.cataclysm.util.CMDamageTypes;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundAddEntityPacket;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseFireBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.ForgeEventFactory;

public class Laser_Beam_Entity
extends Projectile {
    public double xPower;
    public double yPower;
    public double zPower;
    private static final EntityDataAccessor<Float> DAMAGE = SynchedEntityData.m_135353_(Laser_Beam_Entity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);

    public Laser_Beam_Entity(EntityType<? extends Laser_Beam_Entity> type, Level level) {
        super(type, level);
    }

    public Laser_Beam_Entity(EntityType<? extends Laser_Beam_Entity> type, double getX, double gety, double getz, double p_36821_, double p_36822_, double p_36823_, Level level) {
        this(type, level);
        this.m_7678_(getX, gety, getz, this.m_146908_(), this.m_146909_());
        this.m_20090_();
        double d0 = Math.sqrt(p_36821_ * p_36821_ + p_36822_ * p_36822_ + p_36823_ * p_36823_);
        if (d0 != 0.0) {
            this.xPower = p_36821_ / d0 * 0.1;
            this.yPower = p_36822_ / d0 * 0.1;
            this.zPower = p_36823_ / d0 * 0.1;
        }
    }

    public Laser_Beam_Entity(LivingEntity p_36827_, double p_36828_, double p_36829_, double p_36830_, Level p_36831_, float damage) {
        this((EntityType<? extends Laser_Beam_Entity>)((EntityType)ModEntities.LASER_BEAM.get()), p_36827_.m_20185_(), p_36827_.m_20186_(), p_36827_.m_20189_(), p_36828_, p_36829_, p_36830_, p_36831_);
        this.m_5602_((Entity)p_36827_);
        this.setDamage(damage);
    }

    public Laser_Beam_Entity(EntityType<? extends Laser_Beam_Entity> type, LivingEntity p_36827_, double getX, double gety, double getz, double p_36821_, double p_36822_, double p_36823_, float damage, Level level) {
        this(type, level);
        this.m_7678_(getX, gety, getz, this.m_146908_(), this.m_146909_());
        this.m_5602_((Entity)p_36827_);
        this.setDamage(damage);
        this.m_20090_();
        double d0 = Math.sqrt(p_36821_ * p_36821_ + p_36822_ * p_36822_ + p_36823_ * p_36823_);
        if (d0 != 0.0) {
            this.xPower = p_36821_ / d0 * 0.1;
            this.yPower = p_36822_ / d0 * 0.1;
            this.zPower = p_36823_ / d0 * 0.1;
        }
    }

    protected void m_8097_() {
        this.f_19804_.m_135372_(DAMAGE, (Object)Float.valueOf(0.0f));
    }

    public float getDamage() {
        return ((Float)this.f_19804_.m_135370_(DAMAGE)).floatValue();
    }

    public void setDamage(float damage) {
        this.f_19804_.m_135381_(DAMAGE, (Object)Float.valueOf(damage));
    }

    public boolean m_6783_(double p_36837_) {
        double d0 = this.m_20191_().m_82309_() * 4.0;
        if (Double.isNaN(d0)) {
            d0 = 4.0;
        }
        return p_36837_ < (d0 *= 64.0) * d0;
    }

    protected ClipContext.Block getClipType() {
        return ClipContext.Block.COLLIDER;
    }

    public void m_8119_() {
        Entity entity = this.m_19749_();
        if (this.m_9236_().f_46443_ || (entity == null || !entity.m_213877_()) && this.m_9236_().m_46805_(this.m_20183_())) {
            super.m_8119_();
            HitResult hitresult = ProjectileUtil.m_278158_((Entity)this, this::m_5603_);
            if (hitresult.m_6662_() != HitResult.Type.MISS && !ForgeEventFactory.onProjectileImpact((Projectile)this, (HitResult)hitresult)) {
                this.m_6532_(hitresult);
            }
            this.m_20101_();
            Vec3 vec3 = this.m_20184_();
            double d0 = this.m_20185_() + vec3.f_82479_;
            double d1 = this.m_20186_() + vec3.f_82480_;
            double d2 = this.m_20189_() + vec3.f_82481_;
            ProjectileUtil.m_37284_((Entity)this, (float)1.0f);
            float f = this.getInertia();
            this.m_20256_(vec3.m_82520_(this.xPower, this.yPower, this.zPower).m_82490_((double)f));
            this.m_6034_(d0, d1, d2);
        } else {
            this.m_146870_();
        }
    }

    public boolean m_6060_() {
        return false;
    }

    protected void m_5790_(EntityHitResult p_37626_) {
        super.m_5790_(p_37626_);
        if (!this.m_9236_().f_46443_) {
            Entity entity = p_37626_.m_82443_();
            LivingEntity entity1 = (LivingEntity)this.m_19749_();
            int i = entity.m_20094_();
            entity.m_20254_(5);
            if (!entity.m_6469_(CMDamageTypes.causeLaserDamage((Entity)this, entity1), this.getDamage())) {
                entity.m_7311_(i);
            } else if (entity1 != null) {
                this.m_19970_(entity1, entity);
            }
        }
    }

    protected void m_8060_(BlockHitResult p_37384_) {
        super.m_8060_(p_37384_);
        if (!this.m_9236_().f_46443_) {
            Entity entity = this.m_19749_();
            if (CMConfig.HarbingerLightFire) {
                BlockPos blockpos = p_37384_.m_82425_().m_121945_(p_37384_.m_82434_());
                if (this.m_9236_().m_46859_(blockpos)) {
                    this.m_9236_().m_46597_(blockpos, BaseFireBlock.m_49245_((BlockGetter)this.m_9236_(), (BlockPos)blockpos));
                }
            } else if (!(entity instanceof Mob) || ForgeEventFactory.getMobGriefingEvent((Level)this.m_9236_(), (Entity)entity)) {
                BlockPos blockpos = p_37384_.m_82425_().m_121945_(p_37384_.m_82434_());
                if (this.m_9236_().m_46859_(blockpos)) {
                    this.m_9236_().m_46597_(blockpos, BaseFireBlock.m_49245_((BlockGetter)this.m_9236_(), (BlockPos)blockpos));
                }
            }
        }
    }

    protected void m_6532_(HitResult ray) {
        HitResult.Type hitresult$type = ray.m_6662_();
        if (hitresult$type == HitResult.Type.ENTITY) {
            this.m_5790_((EntityHitResult)ray);
            this.m_9236_().m_214171_(GameEvent.f_157777_, ray.m_82450_(), GameEvent.Context.m_223719_((Entity)this, (BlockState)null));
        } else if (hitresult$type == HitResult.Type.BLOCK) {
            BlockHitResult blockhitresult = (BlockHitResult)ray;
            this.m_8060_(blockhitresult);
            BlockPos blockpos = blockhitresult.m_82425_();
            this.m_9236_().m_220407_(GameEvent.f_157777_, blockpos, GameEvent.Context.m_223719_((Entity)this, (BlockState)this.m_9236_().m_8055_(blockpos)));
            if (!this.m_9236_().f_46443_) {
                this.m_146870_();
            }
        }
    }

    protected boolean m_5603_(Entity p_36842_) {
        return super.m_5603_(p_36842_) && !p_36842_.f_19794_;
    }

    protected float getInertia() {
        return 1.0f;
    }

    public void m_7380_(CompoundTag p_36848_) {
        super.m_7380_(p_36848_);
        p_36848_.m_128365_("power", (Tag)this.m_20063_(new double[]{this.xPower, this.yPower, this.zPower}));
    }

    public void m_7378_(CompoundTag p_36844_) {
        ListTag listtag;
        super.m_7378_(p_36844_);
        if (p_36844_.m_128425_("power", 9) && (listtag = p_36844_.m_128437_("power", 6)).size() == 3) {
            this.xPower = listtag.m_128772_(0);
            this.yPower = listtag.m_128772_(1);
            this.zPower = listtag.m_128772_(2);
        }
    }

    public boolean m_6087_() {
        return false;
    }

    public float m_6143_() {
        return 1.0f;
    }

    public boolean m_6469_(DamageSource p_37616_, float p_37617_) {
        return false;
    }

    public float m_213856_() {
        return 1.0f;
    }

    public Packet<ClientGamePacketListener> m_5654_() {
        Entity entity = this.m_19749_();
        int i = entity == null ? 0 : entity.m_19879_();
        return new ClientboundAddEntityPacket(this.m_19879_(), this.m_20148_(), this.m_20185_(), this.m_20186_(), this.m_20189_(), this.m_146909_(), this.m_146908_(), this.m_6095_(), i, new Vec3(this.xPower, this.yPower, this.zPower), 0.0);
    }

    public void m_141965_(ClientboundAddEntityPacket packet) {
        super.m_141965_(packet);
        this.f_19860_ = this.m_146909_();
        this.f_19859_ = this.m_146908_();
        double d0 = packet.m_131503_();
        double d1 = packet.m_131504_();
        double d2 = packet.m_131505_();
        double d3 = Math.sqrt(d0 * d0 + d1 * d1 + d2 * d2);
        if (d3 != 0.0) {
            this.xPower = d0 / d3 * 0.1;
            this.yPower = d1 / d3 * 0.1;
            this.zPower = d2 / d3 * 0.1;
        }
    }
}

