/*
 * Decompiled with CFR 0.152.
 */
package com.github.L_Ender.cataclysm.client.render.entity;

import com.github.L_Ender.cataclysm.client.model.entity.Tidal_Hook_Model;
import com.github.L_Ender.cataclysm.entity.projectile.Tidal_Hook_Entity;
import com.github.L_Ender.cataclysm.init.ModItems;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.Vec3;
import org.joml.Matrix3f;
import org.joml.Matrix4f;

public class Tidal_Hook_Renderer
extends EntityRenderer<Tidal_Hook_Entity> {
    private final Tidal_Hook_Model model = new Tidal_Hook_Model();
    private static final ResourceLocation TEXTURE = new ResourceLocation("cataclysm", "textures/entity/tidal_hook.png");
    private static final ResourceLocation CHAIN_TEXTURE = new ResourceLocation("cataclysm", "textures/entity/tidal_hook_chain.png");
    private static final RenderType CHAIN_LAYER = RenderType.m_110476_((ResourceLocation)CHAIN_TEXTURE);

    public Tidal_Hook_Renderer(EntityRendererProvider.Context renderManagerIn) {
        super(renderManagerIn);
    }

    public void render(Tidal_Hook_Entity entity, float yaw, float tickDelta, PoseStack matrices, MultiBufferSource provider, int light) {
        matrices.m_85836_();
        float yRot = Mth.m_14179_((float)tickDelta, (float)entity.f_19859_, (float)entity.m_146908_());
        float xRot = Mth.m_14179_((float)tickDelta, (float)entity.f_19860_, (float)entity.m_146909_());
        matrices.m_252781_(Axis.f_252436_.m_252977_(yRot - 90.0f));
        matrices.m_252781_(Axis.f_252403_.m_252977_(xRot + 90.0f));
        VertexConsumer vertexConsumer = provider.m_6299_(this.model.m_103119_(this.getTextureLocation(entity)));
        this.model.m_7695_(matrices, vertexConsumer, light, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 1.0f);
        matrices.m_85849_();
        Entity fromEntity = entity.m_19749_();
        if (fromEntity != null) {
            Vec3 entityPos = entity.m_20318_(tickDelta);
            PoseStack poseForModel = new PoseStack();
            poseForModel.m_252781_(Axis.f_252436_.m_252977_(yRot - 90.0f));
            poseForModel.m_252781_(Axis.f_252403_.m_252977_(xRot + 90.0f));
            Vec3 modelOffset = this.model.getChainPosition(new Vec3(0.0, 0.0, 0.0), poseForModel);
            Vec3 fromPos = this.getPositionOfPriorMob(fromEntity, tickDelta);
            Vec3 chainTo = fromPos.m_82546_(entityPos);
            Vec3 chainBase = modelOffset;
            matrices.m_85836_();
            matrices.m_85837_(chainBase.f_82479_, chainBase.f_82480_, chainBase.f_82481_);
            VertexConsumer chainBuffer = provider.m_6299_(RenderType.m_110458_((ResourceLocation)CHAIN_TEXTURE));
            Tidal_Hook_Renderer.renderChainCube(chainTo.m_82546_(chainBase), matrices, chainBuffer, light, OverlayTexture.f_118083_);
            matrices.m_85849_();
        }
    }

    private Vec3 getPositionOfPriorMob(Entity mob, float partialTicks) {
        double d4 = Mth.m_14139_((double)partialTicks, (double)mob.f_19854_, (double)mob.m_20185_());
        double d5 = Mth.m_14139_((double)partialTicks, (double)mob.f_19855_, (double)mob.m_20186_());
        double d6 = Mth.m_14139_((double)partialTicks, (double)mob.f_19856_, (double)mob.m_20189_());
        float f3 = 0.0f;
        if (mob instanceof Player) {
            Player player = (Player)mob;
            float f = player.m_21324_(partialTicks);
            float f1 = Mth.m_14031_((float)(Mth.m_14116_((float)f) * (float)Math.PI));
            float f2 = Mth.m_14179_((float)partialTicks, (float)player.f_20884_, (float)player.f_20883_) * ((float)Math.PI / 180);
            int i = player.m_5737_() == HumanoidArm.RIGHT ? 1 : -1;
            ItemStack itemstack = player.m_21205_();
            if (!itemstack.m_150930_((Item)ModItems.TIDAL_CLAWS.get())) {
                i = -i;
            }
            double d0 = Mth.m_14031_((float)f2);
            double d1 = Mth.m_14089_((float)f2);
            double d2 = (double)i * 0.35;
            if ((this.f_114476_.f_114360_ == null || this.f_114476_.f_114360_.m_92176_().m_90612_()) && player == Minecraft.m_91087_().f_91074_) {
                double d7 = 960.0 / (double)((Integer)this.f_114476_.f_114360_.m_231837_().m_231551_()).intValue();
                Vec3 vec3 = this.f_114476_.f_114358_.m_167684_().m_167695_((float)i * 0.6f, -1.0f);
                vec3 = vec3.m_82490_(d7);
                vec3 = vec3.m_82524_(f1 * 0.25f);
                vec3 = vec3.m_82496_(-f1 * 0.35f);
                d4 = Mth.m_14139_((double)partialTicks, (double)player.f_19854_, (double)player.m_20185_()) + vec3.f_82479_;
                d5 = Mth.m_14139_((double)partialTicks, (double)player.f_19855_, (double)player.m_20186_()) + vec3.f_82480_;
                d6 = Mth.m_14139_((double)partialTicks, (double)player.f_19856_, (double)player.m_20189_()) + vec3.f_82481_;
                f3 = player.m_20192_() * 0.5f;
            } else {
                d4 = Mth.m_14139_((double)partialTicks, (double)player.f_19854_, (double)player.m_20185_()) - d1 * d2 - d0 * 0.2;
                d5 = player.f_19855_ + (double)player.m_20192_() + (player.m_20186_() - player.f_19855_) * (double)partialTicks - 0.45;
                d6 = Mth.m_14139_((double)partialTicks, (double)player.f_19856_, (double)player.m_20189_()) - d0 * d2 + d1 * 0.2;
                f3 = player.m_6047_() ? -0.1875f : 0.0f;
            }
        }
        return new Vec3(d4, d5 + (double)f3, d6);
    }

    public static void renderChainCube(Vec3 to, PoseStack poseStack, VertexConsumer buffer, int packedLightIn, int setOverlay) {
        double d = to.m_165924_();
        float rotY = (float)(Mth.m_14136_((double)to.f_82479_, (double)to.f_82481_) * 57.2957763671875);
        float rotX = (float)(-(Mth.m_14136_((double)to.f_82480_, (double)d) * 57.2957763671875)) - 90.0f;
        float chainWidth = 0.09375f;
        float chainOffset = chainWidth * -0.5f;
        float chainLength = (float)to.m_82553_() / 2.3f;
        poseStack.m_85836_();
        poseStack.m_85841_(2.3f, 2.3f, 2.3f);
        poseStack.m_252781_(Axis.f_252436_.m_252977_(rotY));
        poseStack.m_252781_(Axis.f_252529_.m_252977_(rotX));
        poseStack.m_252880_(0.0f, -chainLength, 0.0f);
        PoseStack.Pose posestack$pose = poseStack.m_85850_();
        Matrix4f matrix4f = posestack$pose.m_252922_();
        Matrix3f matrix3f = posestack$pose.m_252943_();
        buffer.m_252986_(matrix4f, chainOffset, 0.0f, 0.0f).m_6122_(255, 255, 255, 255).m_7421_(0.0f, chainLength).m_86008_(setOverlay).m_85969_(packedLightIn).m_252939_(matrix3f, 0.0f, 1.0f, 0.0f).m_5752_();
        buffer.m_252986_(matrix4f, chainWidth + chainOffset, 0.0f, 0.0f).m_6122_(255, 255, 255, 255).m_7421_(chainWidth, chainLength).m_86008_(setOverlay).m_85969_(packedLightIn).m_252939_(matrix3f, 0.0f, 1.0f, 0.0f).m_5752_();
        buffer.m_252986_(matrix4f, chainWidth + chainOffset, chainLength, 0.0f).m_6122_(255, 255, 255, 255).m_7421_(chainWidth, 0.0f).m_86008_(setOverlay).m_85969_(packedLightIn).m_252939_(matrix3f, 0.0f, 1.0f, 0.0f).m_5752_();
        buffer.m_252986_(matrix4f, chainOffset, chainLength, 0.0f).m_6122_(255, 255, 255, 255).m_7421_(0.0f, 0.0f).m_86008_(setOverlay).m_85969_(packedLightIn).m_252939_(matrix3f, 0.0f, 1.0f, 0.0f).m_5752_();
        float pixelSkip = 0.125f;
        buffer.m_252986_(matrix4f, 0.0f, pixelSkip, chainOffset).m_6122_(255, 255, 255, 255).m_7421_(chainWidth, chainLength + pixelSkip).m_86008_(setOverlay).m_85969_(packedLightIn).m_252939_(matrix3f, 0.0f, 1.0f, 0.0f).m_5752_();
        buffer.m_252986_(matrix4f, 0.0f, pixelSkip, chainWidth + chainOffset).m_6122_(255, 255, 255, 255).m_7421_(chainWidth * 2.0f, chainLength + pixelSkip).m_86008_(setOverlay).m_85969_(packedLightIn).m_252939_(matrix3f, 0.0f, 1.0f, 0.0f).m_5752_();
        buffer.m_252986_(matrix4f, 0.0f, chainLength + pixelSkip, chainWidth + chainOffset).m_6122_(255, 255, 255, 255).m_7421_(chainWidth * 2.0f, pixelSkip).m_86008_(setOverlay).m_85969_(packedLightIn).m_252939_(matrix3f, 0.0f, 1.0f, 0.0f).m_5752_();
        buffer.m_252986_(matrix4f, 0.0f, chainLength + pixelSkip, chainOffset).m_6122_(255, 255, 255, 255).m_7421_(chainWidth, pixelSkip).m_86008_(setOverlay).m_85969_(packedLightIn).m_252939_(matrix3f, 0.0f, 1.0f, 0.0f).m_5752_();
        poseStack.m_85849_();
    }

    public ResourceLocation getTextureLocation(Tidal_Hook_Entity entity) {
        return TEXTURE;
    }
}

