/*
 * Decompiled with CFR 0.152.
 */
package com.github.L_Ender.cataclysm.client.render.entity;

import com.github.L_Ender.cataclysm.client.model.CMModelLayers;
import com.github.L_Ender.cataclysm.client.model.entity.Flare_Bomb_Model;
import com.github.L_Ender.cataclysm.client.render.CMRenderTypes;
import com.github.L_Ender.cataclysm.entity.projectile.Flare_Bomb_Entity;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.joml.Matrix3f;
import org.joml.Matrix4f;
import org.joml.Quaternionf;

@OnlyIn(value=Dist.CLIENT)
public class Flare_Bomb_Renderer
extends EntityRenderer<Flare_Bomb_Entity> {
    private static final ResourceLocation OUTER_TEXTURES = new ResourceLocation("cataclysm", "textures/entity/monstrosity/flare_bomb_outer.png");
    private static final ResourceLocation INNER_TEXTURES = new ResourceLocation("cataclysm", "textures/entity/monstrosity/flare_bomb_inner.png");
    private static final ResourceLocation TRAIL_TEXTURE = new ResourceLocation("cataclysm", "textures/particle/amogus.png");
    private final Flare_Bomb_Model model;
    private final RandomSource random = RandomSource.m_216327_();

    public Flare_Bomb_Renderer(EntityRendererProvider.Context renderManagerIn) {
        super(renderManagerIn);
        this.model = new Flare_Bomb_Model(renderManagerIn.m_174023_(CMModelLayers.FLARE_BOMB_MODEL));
    }

    public void render(Flare_Bomb_Entity entityIn, float entityYaw, float partialTicks, PoseStack matrixStackIn, MultiBufferSource bufferIn, int packedLightIn) {
        matrixStackIn.m_85836_();
        matrixStackIn.m_252781_(new Quaternionf().setAngleAxis(entityYaw * ((float)Math.PI / 180), 0.0f, -1.0f, 0.0f));
        VertexConsumer VertexConsumer2 = bufferIn.m_6299_(CMRenderTypes.CMEyes(this.getTextureLocation(entityIn)));
        this.model.setupAnim(entityIn, 0.0f, 0.0f, (float)entityIn.f_19797_ + partialTicks, 0.0f, 0.0f);
        this.model.m_7695_(matrixStackIn, VertexConsumer2, packedLightIn, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 1.0f);
        VertexConsumer VertexConsumer22 = bufferIn.m_6299_(CMRenderTypes.CMEyes(OUTER_TEXTURES));
        this.model.m_7695_(matrixStackIn, VertexConsumer22, packedLightIn, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 0.4f);
        matrixStackIn.m_85849_();
        if (entityIn.hasTrail()) {
            double x = Mth.m_14139_((double)partialTicks, (double)entityIn.f_19790_, (double)entityIn.m_20185_());
            double y = Mth.m_14139_((double)partialTicks, (double)entityIn.f_19791_, (double)entityIn.m_20186_());
            double z = Mth.m_14139_((double)partialTicks, (double)entityIn.f_19792_, (double)entityIn.m_20189_());
            float ran = 0.04f;
            float r = 0.7647059f + this.random.m_188501_() * ran * 1.5f;
            float g = 0.37254903f + this.random.m_188501_() * ran;
            float b = 0.011764706f + this.random.m_188501_() * ran;
            matrixStackIn.m_85836_();
            matrixStackIn.m_85837_(-x, -y, -z);
            this.renderTrail(entityIn, partialTicks, matrixStackIn, bufferIn, r, g, b, 1.0f, packedLightIn);
            matrixStackIn.m_85849_();
        }
    }

    private void renderTrail(Flare_Bomb_Entity entityIn, float partialTicks, PoseStack poseStack, MultiBufferSource bufferIn, float trailR, float trailG, float trailB, float trailA, int packedLightIn) {
        int sampleSize = 10;
        float trailHeight = 0.5f;
        float trailYRot = 0.0f;
        float trailZRot = 0.0f;
        Vec3 topAngleVec = new Vec3((double)trailHeight, (double)trailHeight, 0.0).m_82524_(trailYRot).m_82535_(trailZRot);
        Vec3 bottomAngleVec = new Vec3((double)(-trailHeight), (double)(-trailHeight), 0.0).m_82524_(trailYRot).m_82535_(trailZRot);
        Vec3 drawFrom = entityIn.getTrailPosition(0, partialTicks);
        PoseStack.Pose posestack$pose = poseStack.m_85850_();
        Matrix4f matrix4f = posestack$pose.m_252922_();
        Matrix3f matrix3f = posestack$pose.m_252943_();
        VertexConsumer vertexconsumer = bufferIn.m_6299_(CMRenderTypes.getLightTrailEffect(TRAIL_TEXTURE));
        for (int samples = 0; samples < sampleSize; ++samples) {
            Vec3 sample = entityIn.getTrailPosition(samples + 2, partialTicks);
            float u1 = (float)samples / (float)sampleSize;
            float u2 = u1 + 1.0f / (float)sampleSize;
            this.addVertex(vertexconsumer, matrix4f, matrix3f, drawFrom, bottomAngleVec, trailR, trailG, trailB, u1, 1.0f, packedLightIn);
            this.addVertex(vertexconsumer, matrix4f, matrix3f, sample, bottomAngleVec, trailR, trailG, trailB, u2, 1.0f, packedLightIn);
            this.addVertex(vertexconsumer, matrix4f, matrix3f, sample, topAngleVec, trailR, trailG, trailB, u2, 0.0f, packedLightIn);
            this.addVertex(vertexconsumer, matrix4f, matrix3f, drawFrom, topAngleVec, trailR, trailG, trailB, u1, 0.0f, packedLightIn);
            drawFrom = sample;
        }
    }

    private void addVertex(VertexConsumer consumer, Matrix4f matrix, Matrix3f matrix3, Vec3 pos, Vec3 offset, float r, float g, float b, float u, float v, int light) {
        consumer.m_252986_(matrix, (float)(pos.f_82479_ + offset.f_82479_), (float)(pos.f_82480_ + offset.f_82480_), (float)(pos.f_82481_ + offset.f_82481_)).m_85950_(r, g, b, 1.0f).m_7421_(u, v).m_86008_(OverlayTexture.f_118083_).m_85969_(light).m_252939_(matrix3, 0.0f, 1.0f, 0.0f).m_5752_();
    }

    protected int getBlockLightLevel(Flare_Bomb_Entity entityIn, BlockPos pos) {
        return 15;
    }

    public ResourceLocation getTextureLocation(Flare_Bomb_Entity entity) {
        return INNER_TEXTURES;
    }
}

