/*
 * Decompiled with CFR 0.152.
 */
package com.jesz.createdieselgenerators.content.tools;

import com.jesz.createdieselgenerators.CDGConfig;
import com.jesz.createdieselgenerators.CDGItems;
import com.jesz.createdieselgenerators.CreateDieselGenerators;
import com.jesz.createdieselgenerators.world.OilChunksSavedData;
import com.simibubi.create.AllSoundEvents;
import com.simibubi.create.foundation.item.TooltipHelper;
import com.tterrag.registrate.providers.DataGenContext;
import com.tterrag.registrate.providers.RegistrateItemModelProvider;
import net.minecraft.ChatFormatting;
import net.minecraft.client.renderer.item.ItemProperties;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundSetActionBarTextPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.model.generators.ItemModelBuilder;
import net.minecraftforge.client.model.generators.ModelFile;
import net.minecraftforge.fml.DistExecutor;

public class OilScannerItem
extends Item {
    public OilScannerItem(Item.Properties properties) {
        super(properties.m_41487_(1));
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand hand) {
        ItemStack stack = player.m_21120_(hand);
        if (player.m_20186_() < (double)((Integer)CDGConfig.MAX_OIL_SCANNER_LEVEL.get()).intValue()) {
            stack.m_41784_().m_128405_("Time", 20);
            stack.m_41784_().m_128405_("Type", 0);
            if (level.f_46443_) {
                player.m_5661_(CreateDieselGenerators.lang("actionbar.oil_scanner.searching", new Object[0]), true);
            }
        } else {
            level.m_7785_(player.m_20185_(), player.m_20186_(), player.m_20189_(), AllSoundEvents.DENY.getMainEvent(), SoundSource.PLAYERS, 1.2f, 1.0f, true);
            if (level.f_46443_) {
                player.m_5661_(CreateDieselGenerators.lang("actionbar.oil_scanner.too_high_up", new Object[0]), true);
            }
        }
        return InteractionResultHolder.m_19090_((Object)stack);
    }

    public void m_6883_(ItemStack stack, Level level, Entity entity, int slot, boolean selected) {
        if (stack.m_41783_() != null && stack.m_41783_().m_128451_("Type") == 0) {
            if (level instanceof ServerLevel) {
                ServerLevel sl = (ServerLevel)level;
                if (stack.m_41783_().m_128451_("Time") == 0) {
                    stack.m_41783_().m_128405_("Time", 20);
                    ChunkPos chunk = new ChunkPos(new BlockPos(entity.m_146903_(), 0, entity.m_146907_()));
                    int amount = OilChunksSavedData.getChunkOilAmount(sl, chunk);
                    if (amount <= 0) {
                        stack.m_41783_().m_128405_("Type", 1);
                    } else if (amount >= ((Integer)CDGConfig.OIL_CHUNK_THRESHOLD.get() + (Integer)CDGConfig.OIL_CHUNK_INFINITE_THRESHOLD.get()) / 2) {
                        stack.m_41783_().m_128405_("Type", 3);
                    } else {
                        stack.m_41783_().m_128405_("Type", 2);
                    }
                    if (entity instanceof ServerPlayer) {
                        ServerPlayer sp = (ServerPlayer)entity;
                        if (amount <= 0) {
                            sp.f_8906_.m_9829_((Packet)new ClientboundSetActionBarTextPacket((Component)Component.m_237110_((String)"createdieselgenerators.actionbar.oil_scanner.oil_none", (Object[])new Object[]{TooltipHelper.makeProgressBar((int)3, (int)0)}).m_130940_(ChatFormatting.GRAY)));
                        } else if (amount == Integer.MAX_VALUE) {
                            sp.f_8906_.m_9829_((Packet)new ClientboundSetActionBarTextPacket((Component)Component.m_237110_((String)"createdieselgenerators.actionbar.oil_scanner.oil_bottomless", (Object[])new Object[]{TooltipHelper.makeProgressBar((int)3, (int)3)}).m_130940_(ChatFormatting.GOLD)));
                        } else if (amount >= ((Integer)CDGConfig.OIL_CHUNK_THRESHOLD.get() + (Integer)CDGConfig.OIL_CHUNK_INFINITE_THRESHOLD.get()) / 2) {
                            sp.f_8906_.m_9829_((Packet)new ClientboundSetActionBarTextPacket((Component)Component.m_237110_((String)"createdieselgenerators.actionbar.oil_scanner.oil_high", (Object[])new Object[]{TooltipHelper.makeProgressBar((int)3, (int)2)}).m_130940_(ChatFormatting.YELLOW)));
                        } else {
                            sp.f_8906_.m_9829_((Packet)new ClientboundSetActionBarTextPacket((Component)Component.m_237110_((String)"createdieselgenerators.actionbar.oil_scanner.oil_low", (Object[])new Object[]{TooltipHelper.makeProgressBar((int)3, (int)1)}).m_130940_(ChatFormatting.GREEN)));
                        }
                    }
                }
                stack.m_41783_().m_128405_("Time", stack.m_41783_().m_128451_("Time") - 1);
            } else {
                level.m_7785_(entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), AllSoundEvents.SCROLL_VALUE.getMainEvent(), SoundSource.PLAYERS, 0.2f, 1.0f, true);
            }
        }
        super.m_6883_(stack, level, entity, slot, selected);
    }

    public void registerModelOverrides() {
        DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> ItemProperties.register((Item)((Item)CDGItems.OIL_SCANNER.get()), (ResourceLocation)CreateDieselGenerators.rl("oil_scanner_state"), (stack, level, entity, seed) -> {
            CompoundTag tag = stack.m_41783_();
            return tag == null ? 0.0f : (float)tag.m_128451_("Type");
        }));
    }

    public static ItemModelBuilder addOverrideModels(DataGenContext<Item, OilScannerItem> c, RegistrateItemModelProvider p) {
        ItemModelBuilder builder = p.generated(() -> c.getEntry(), new ResourceLocation[]{p.modLoc("item/oil_scanner_rotating")});
        builder.override().predicate(CreateDieselGenerators.rl("oil_scanner_state"), 0.0f).model((ModelFile)((ItemModelBuilder)((ItemModelBuilder)p.getBuilder(c.getName())).parent((ModelFile)new ModelFile.UncheckedModelFile("item/generated"))).texture("layer0", CreateDieselGenerators.rl("item/oil_scanner_rotating"))).end();
        builder.override().predicate(CreateDieselGenerators.rl("oil_scanner_state"), 1.0f).model((ModelFile)((ItemModelBuilder)((ItemModelBuilder)p.getBuilder(c.getName() + "_none")).parent((ModelFile)new ModelFile.UncheckedModelFile("item/generated"))).texture("layer0", CreateDieselGenerators.rl("item/oil_scanner_none"))).end();
        builder.override().predicate(CreateDieselGenerators.rl("oil_scanner_state"), 2.0f).model((ModelFile)((ItemModelBuilder)((ItemModelBuilder)p.getBuilder(c.getName() + "_medium")).parent((ModelFile)new ModelFile.UncheckedModelFile("item/generated"))).texture("layer0", CreateDieselGenerators.rl("item/oil_scanner_medium"))).end();
        builder.override().predicate(CreateDieselGenerators.rl("oil_scanner_state"), 3.0f).model((ModelFile)((ItemModelBuilder)((ItemModelBuilder)p.getBuilder(c.getName() + "_high")).parent((ModelFile)new ModelFile.UncheckedModelFile("item/generated"))).texture("layer0", CreateDieselGenerators.rl("item/oil_scanner_high"))).end();
        return builder;
    }
}

