/*
 * Decompiled with CFR 0.152.
 */
package com.jesz.createdieselgenerators.content.entity_filter;

import com.jesz.createdieselgenerators.content.entity_filter.EntityAttribute;
import com.simibubi.create.content.logistics.filter.AbstractFilterMenu;
import com.simibubi.create.content.logistics.filter.AttributeFilterMenu;
import java.util.ArrayList;
import java.util.List;
import net.createmod.catnip.data.Pair;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.items.SlotItemHandler;

public class EntityFilterMenu
extends AbstractFilterMenu {
    public AttributeFilterMenu.WhitelistMode whitelist;
    List<Pair<EntityAttribute, Boolean>> selectedAttributes;

    public EntityFilterMenu(MenuType<?> type, int id, Inventory inv, FriendlyByteBuf extraData) {
        super(type, id, inv, extraData);
    }

    protected EntityFilterMenu(MenuType<?> type, int id, Inventory inv, ItemStack contentHolder) {
        super(type, id, inv, contentHolder);
    }

    public void appendSelectedAttribute(EntityAttribute entry, Boolean inverted) {
        this.selectedAttributes.add((Pair<EntityAttribute, Boolean>)Pair.of((Object)entry, (Object)inverted));
    }

    protected void init(Inventory inv, ItemStack contentHolder) {
        super.init(inv, (Object)contentHolder);
        ItemStack stack = new ItemStack((ItemLike)Items.f_42656_);
        stack.m_41714_((Component)Component.m_237113_((String)"Selected Tags").m_130944_(new ChatFormatting[]{ChatFormatting.RESET, ChatFormatting.BLUE}));
        this.ghostInventory.setStackInSlot(1, stack);
    }

    protected ItemStackHandler createGhostInventory() {
        return new ItemStackHandler(2);
    }

    protected int getPlayerInventoryXOffset() {
        return 51;
    }

    protected int getPlayerInventoryYOffset() {
        return 107;
    }

    protected void addFilterSlots() {
        this.m_38897_((Slot)new SlotItemHandler((IItemHandler)this.ghostInventory, 0, 16, 27));
        this.m_38897_((Slot)new SlotItemHandler((IItemHandler)this.ghostInventory, 1, 16, 62){

            public boolean m_8010_(Player playerIn) {
                return false;
            }
        });
    }

    public void clearContents() {
        this.selectedAttributes.clear();
    }

    public void m_150399_(int slotId, int dragType, ClickType clickTypeIn, Player player) {
        if (slotId == 37) {
            return;
        }
        super.m_150399_(slotId, dragType, clickTypeIn, player);
    }

    public boolean m_5622_(Slot slotIn) {
        if (slotIn.f_40219_ == 37) {
            return false;
        }
        return super.m_5622_(slotIn);
    }

    public boolean m_5882_(ItemStack stack, Slot slotIn) {
        if (slotIn.f_40219_ == 37) {
            return false;
        }
        return super.m_5882_(stack, slotIn);
    }

    public ItemStack m_7648_(Player playerIn, int index) {
        if (index == 37) {
            return ItemStack.f_41583_;
        }
        if (index == 36) {
            this.ghostInventory.setStackInSlot(37, ItemStack.f_41583_);
            return ItemStack.f_41583_;
        }
        if (index < 36) {
            ItemStack stackToInsert = this.playerInventory.m_8020_(index);
            ItemStack copy = stackToInsert.m_41777_();
            copy.m_41764_(1);
            this.ghostInventory.setStackInSlot(0, copy);
        }
        return ItemStack.f_41583_;
    }

    protected void initAndReadInventory(ItemStack filterItem) {
        super.initAndReadInventory((Object)filterItem);
        this.selectedAttributes = new ArrayList<Pair<EntityAttribute, Boolean>>();
        this.whitelist = AttributeFilterMenu.WhitelistMode.values()[filterItem.m_41784_().m_128451_("Whitelist")];
        ListTag attributes = filterItem.m_41784_().m_128437_("MatchedAttributes", 10);
        attributes.forEach(nbt -> {
            CompoundTag compound = (CompoundTag)nbt;
            EntityAttribute fEntry = EntityAttribute.fromNBT(compound);
            if (fEntry == null) {
                return;
            }
            this.selectedAttributes.add((Pair<EntityAttribute, Boolean>)Pair.of((Object)fEntry, (Object)compound.m_128471_("Inverted")));
        });
    }

    protected void saveData(ItemStack filterItem) {
        filterItem.m_41784_().m_128405_("Whitelist", this.whitelist.ordinal());
        ListTag attributes = new ListTag();
        this.selectedAttributes.forEach(at -> {
            if (at == null) {
                return;
            }
            if (at.getFirst() == null) {
                return;
            }
            CompoundTag tag = ((EntityAttribute)at.getFirst()).write();
            tag.m_128379_("Inverted", ((Boolean)at.getSecond()).booleanValue());
            attributes.add((Object)tag);
        });
        filterItem.m_41783_().m_128365_("MatchedAttributes", (Tag)attributes);
        if (attributes.isEmpty() && this.whitelist == AttributeFilterMenu.WhitelistMode.WHITELIST_DISJ) {
            filterItem.m_41751_(null);
        }
    }
}

