/*
 * Decompiled with CFR 0.152.
 */
package ram.talia.moreiotas.forge.xplat;

import at.petrak.hexcasting.common.msgs.IMessage;
import net.minecraft.core.BlockPos;
import net.minecraft.network.protocol.Packet;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.level.BlockEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.fml.loading.FMLLoader;
import net.minecraftforge.network.NetworkDirection;
import net.minecraftforge.network.PacketDistributor;
import org.jetbrains.annotations.Nullable;
import ram.talia.moreiotas.forge.eventhandlers.ChatEventHandler;
import ram.talia.moreiotas.forge.network.ForgePacketHandler;
import ram.talia.moreiotas.xplat.IXplatAbstractions;

public class ForgeXplatImpl
implements IXplatAbstractions {
    @Override
    public boolean isPhysicalClient() {
        return FMLLoader.getDist() == Dist.CLIENT;
    }

    @Override
    public void sendPacketToPlayer(ServerPlayer target, IMessage packet) {
        ForgePacketHandler.getNetwork().send(PacketDistributor.PLAYER.with(() -> target), (Object)packet);
    }

    @Override
    public void sendPacketNear(Vec3 pos, double radius, ServerLevel dimension, IMessage packet) {
        ForgePacketHandler.getNetwork().send(PacketDistributor.NEAR.with(() -> new PacketDistributor.TargetPoint(pos.f_82479_, pos.f_82480_, pos.f_82481_, radius * radius, dimension.m_46472_())), (Object)packet);
    }

    @Override
    public Packet<?> toVanillaClientboundPacket(IMessage message) {
        return ForgePacketHandler.getNetwork().toVanillaPacket((Object)message, NetworkDirection.PLAY_TO_CLIENT);
    }

    @Override
    public boolean isBreakingAllowed(Level level, BlockPos pos, BlockState state, Player player) {
        return !MinecraftForge.EVENT_BUS.post((Event)new BlockEvent.BreakEvent(level, pos, state, player));
    }

    @Override
    @Nullable
    public String lastMessage(@Nullable Player player) {
        return ChatEventHandler.getLastMessage(player);
    }

    @Override
    public void setChatPrefix(Player player, @Nullable String prefix) {
        ChatEventHandler.setPrefix(player, prefix);
    }

    @Override
    @Nullable
    public String getChatPrefix(Player player) {
        return ChatEventHandler.getPrefix(player);
    }
}

