/*
 * Decompiled with CFR 0.152.
 */
package ram.talia.moreiotas.forge.eventhandlers;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.event.ServerChatEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import org.jetbrains.annotations.Nullable;

public class ChatEventHandler {
    private static final String TAG_CHAT_PREFIX = "moreiotas:prefix";
    private static final Map<UUID, @Nullable String> lastMessages = new HashMap<UUID, String>();
    @Nullable
    private static String lastMessage = null;

    public static void setPrefix(Player player, @Nullable String prefix) {
        if (prefix == null) {
            player.getPersistentData().m_128473_(TAG_CHAT_PREFIX);
        } else {
            player.getPersistentData().m_128359_(TAG_CHAT_PREFIX, prefix);
        }
    }

    @Nullable
    public static String getPrefix(Player player) {
        if (!player.getPersistentData().m_128441_(TAG_CHAT_PREFIX)) {
            return null;
        }
        return player.getPersistentData().m_128461_(TAG_CHAT_PREFIX);
    }

    @Nullable
    public static String getLastMessage(@Nullable Player player) {
        if (player == null) {
            return lastMessage;
        }
        return lastMessages.get(player.m_20148_());
    }

    @SubscribeEvent
    public static void chatMessageSent(ServerChatEvent event) {
        ServerPlayer player = event.getPlayer();
        UUID uuid = player.m_20148_();
        String text = event.getRawText();
        if (event.isCanceled()) {
            return;
        }
        if (!player.getPersistentData().m_128441_(TAG_CHAT_PREFIX)) {
            lastMessages.put(uuid, text);
            lastMessage = text;
            return;
        }
        String prefix = player.getPersistentData().m_128461_(TAG_CHAT_PREFIX);
        if (text.startsWith(prefix)) {
            event.setCanceled(true);
            lastMessages.put(uuid, text.substring(prefix.length()));
            return;
        }
        lastMessage = text;
    }
}

