/*
 * Decompiled with CFR 0.152.
 */
package ram.talia.moreiotas.forge;

import at.petrak.hexcasting.common.lib.HexRegistries;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import org.apache.commons.lang3.tuple.Pair;
import ram.talia.moreiotas.api.MoreIotasAPI;
import ram.talia.moreiotas.api.mod.MoreIotasConfig;
import ram.talia.moreiotas.common.lib.hex.MoreIotasActions;
import ram.talia.moreiotas.common.lib.hex.MoreIotasArithmetics;
import ram.talia.moreiotas.common.lib.hex.MoreIotasIotaTypes;
import ram.talia.moreiotas.forge.ForgeMoreIotasClientInitializer;
import ram.talia.moreiotas.forge.ForgeMoreIotasConfig;
import ram.talia.moreiotas.forge.cap.CapSyncers;
import ram.talia.moreiotas.forge.cap.ForgeCapabilityHandler;
import ram.talia.moreiotas.forge.datagen.MoreIotasForgeDataGenerators;
import ram.talia.moreiotas.forge.eventhandlers.ChatEventHandler;
import ram.talia.moreiotas.forge.network.ForgePacketHandler;
import thedarkcolour.kotlinforforge.KotlinModLoadingContext;

@Mod(value="moreiotas")
public class ForgeMoreIotasInitializer {
    public ForgeMoreIotasInitializer() {
        MoreIotasAPI.LOGGER.info("Hello Forge World!");
        ForgeMoreIotasInitializer.initConfig();
        ForgeMoreIotasInitializer.initRegistry();
        ForgeMoreIotasInitializer.initListeners();
    }

    private static void initConfig() {
        Pair config = new ForgeConfigSpec.Builder().configure(ForgeMoreIotasConfig::new);
        Pair clientConfig = new ForgeConfigSpec.Builder().configure(ForgeMoreIotasConfig.Client::new);
        Pair serverConfig = new ForgeConfigSpec.Builder().configure(ForgeMoreIotasConfig.Server::new);
        MoreIotasConfig.setCommon((MoreIotasConfig.CommonConfigAccess)config.getLeft());
        MoreIotasConfig.setClient((MoreIotasConfig.ClientConfigAccess)clientConfig.getLeft());
        MoreIotasConfig.setServer((MoreIotasConfig.ServerConfigAccess)serverConfig.getLeft());
        ModLoadingContext mlc = ModLoadingContext.get();
        mlc.registerConfig(ModConfig.Type.COMMON, (IConfigSpec)config.getRight());
        mlc.registerConfig(ModConfig.Type.CLIENT, (IConfigSpec)clientConfig.getRight());
        mlc.registerConfig(ModConfig.Type.SERVER, (IConfigSpec)serverConfig.getRight());
    }

    private static void initRegistry() {
        ForgeMoreIotasInitializer.bind(HexRegistries.IOTA_TYPE, MoreIotasIotaTypes::registerTypes);
        ForgeMoreIotasInitializer.bind(HexRegistries.ACTION, MoreIotasActions::register);
        ForgeMoreIotasInitializer.bind(HexRegistries.ARITHMETIC, MoreIotasArithmetics::register);
    }

    private static void initListeners() {
        IEventBus modBus = ForgeMoreIotasInitializer.getModEventBus();
        IEventBus evBus = MinecraftForge.EVENT_BUS;
        modBus.register(ForgeMoreIotasClientInitializer.class);
        modBus.addListener(evt -> evt.enqueueWork(() -> ForgePacketHandler.init()));
        modBus.register(MoreIotasForgeDataGenerators.class);
        evBus.addGenericListener(ItemStack.class, ForgeCapabilityHandler::attachItemCaps);
        modBus.register(ForgeCapabilityHandler.class);
        evBus.register(ChatEventHandler.class);
        evBus.register(CapSyncers.class);
    }

    private static <T> void bind(ResourceKey<Registry<T>> registry, Consumer<BiConsumer<T, ResourceLocation>> source) {
        ForgeMoreIotasInitializer.getModEventBus().addListener(event -> {
            if (registry.equals((Object)event.getRegistryKey())) {
                source.accept((t, rl) -> event.register(registry, rl, () -> t));
            }
        });
    }

    private static <T> void bind(Registry<T> registry, Consumer<BiConsumer<T, ResourceLocation>> source) {
        source.accept((t, id) -> Registry.m_122965_((Registry)registry, (ResourceLocation)id, (Object)t));
    }

    private static IEventBus getModEventBus() {
        return KotlinModLoadingContext.Companion.get().getKEventBus();
    }
}

