/*
 * Decompiled with CFR 0.152.
 */
package ram.talia.moreiotas.forge;

import net.minecraftforge.common.ForgeConfigSpec;
import ram.talia.moreiotas.api.mod.MoreIotasConfig;

public class ForgeMoreIotasConfig
implements MoreIotasConfig.CommonConfigAccess {
    public ForgeMoreIotasConfig(ForgeConfigSpec.Builder builder) {
    }

    public static class Server
    implements MoreIotasConfig.ServerConfigAccess {
        private static ForgeConfigSpec.IntValue maxMatrixSize;
        private static ForgeConfigSpec.IntValue maxStringLength;
        private static ForgeConfigSpec.DoubleValue setBlockStringCost;
        private static ForgeConfigSpec.DoubleValue nameCost;

        public Server(ForgeConfigSpec.Builder builder) {
            builder.push("Spells");
            maxMatrixSize = builder.comment("How large can matrices be").defineInRange("maxMatrixSize", 144, 3, 512);
            maxStringLength = builder.comment("How long can strings be").defineInRange("maxStringLength", 1728, 1, 32768);
            setBlockStringCost = builder.comment("How much dust should string/block/set cost?").defineInRange("setBlockStringCost", 0.01, 1.0E-4, 10000.0);
            nameCost = builder.comment("How much dust should string/name cost?").defineInRange("nameCost", 0.01, 1.0E-4, 10000.0);
        }

        @Override
        public int getMaxMatrixSize() {
            return (Integer)maxMatrixSize.get();
        }

        @Override
        public int getMaxStringLength() {
            return (Integer)maxStringLength.get();
        }

        @Override
        public long getSetBlockStringCost() {
            return (long)((Double)setBlockStringCost.get() * 10000.0);
        }

        @Override
        public long getNameCost() {
            return (long)((Double)nameCost.get() * 10000.0);
        }
    }

    public static class Client
    implements MoreIotasConfig.ClientConfigAccess {
        public Client(ForgeConfigSpec.Builder builder) {
        }
    }
}

