/*
 * Decompiled with CFR 0.152.
 */
package ram.talia.moreiotas.common.casting.arithmetic;

import at.petrak.hexcasting.api.casting.arithmetic.Arithmetic;
import at.petrak.hexcasting.api.casting.arithmetic.engine.InvalidOperatorException;
import at.petrak.hexcasting.api.casting.arithmetic.operator.Operator;
import at.petrak.hexcasting.api.casting.arithmetic.operator.OperatorBinary;
import at.petrak.hexcasting.api.casting.arithmetic.operator.OperatorUnary;
import at.petrak.hexcasting.api.casting.arithmetic.predicates.IotaMultiPredicate;
import at.petrak.hexcasting.api.casting.arithmetic.predicates.IotaPredicate;
import at.petrak.hexcasting.api.casting.iota.DoubleIota;
import at.petrak.hexcasting.api.casting.iota.Iota;
import at.petrak.hexcasting.api.casting.math.HexPattern;
import java.util.List;
import java.util.function.BinaryOperator;
import java.util.function.Function;
import java.util.function.UnaryOperator;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import ram.talia.moreiotas.api.casting.iota.StringIota;
import ram.talia.moreiotas.common.casting.arithmetic.operator.string.OperatorStringIndex;
import ram.talia.moreiotas.common.casting.arithmetic.operator.string.OperatorStringIndexOf;
import ram.talia.moreiotas.common.casting.arithmetic.operator.string.OperatorStringMul;
import ram.talia.moreiotas.common.casting.arithmetic.operator.string.OperatorStringRemove;
import ram.talia.moreiotas.common.casting.arithmetic.operator.string.OperatorStringReplace;
import ram.talia.moreiotas.common.casting.arithmetic.operator.string.OperatorStringSlice;
import ram.talia.moreiotas.common.lib.hex.MoreIotasIotaTypes;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001c\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0007\u001a\u00020\bH\u0016J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0005H\u0016J\u0016\u0010\f\u001a\u00020\r2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\b0\u000fH\u0002J\u001c\u0010\u0010\u001a\u00020\r2\u0012\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u00120\u0011H\u0002J\u0016\u0010\u0013\u001a\u00020\u00142\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\b0\u0015H\u0002J\u000e\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00050\u0017H\u0016R\u001c\u0010\u0003\u001a\u0010\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00050\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lram/talia/moreiotas/common/casting/arithmetic/StringArithmetic;", "Lat/petrak/hexcasting/api/casting/arithmetic/Arithmetic;", "()V", "OPS", "", "Lat/petrak/hexcasting/api/casting/math/HexPattern;", "kotlin.jvm.PlatformType", "arithName", "", "getOperator", "Lat/petrak/hexcasting/api/casting/arithmetic/operator/Operator;", "pattern", "make1", "Lat/petrak/hexcasting/api/casting/arithmetic/operator/OperatorUnary;", "op", "Ljava/util/function/UnaryOperator;", "make1Double", "Ljava/util/function/Function;", "", "make2", "Lat/petrak/hexcasting/api/casting/arithmetic/operator/OperatorBinary;", "Ljava/util/function/BinaryOperator;", "opTypes", "", "moreiotas-forge-1.20.1"})
public final class StringArithmetic
implements Arithmetic {
    @NotNull
    public static final StringArithmetic INSTANCE = new StringArithmetic();
    @NotNull
    private static final List<HexPattern> OPS;

    private StringArithmetic() {
    }

    @NotNull
    public String arithName() {
        return "string_ops";
    }

    @NotNull
    public Iterable<HexPattern> opTypes() {
        return OPS;
    }

    @NotNull
    public Operator getOperator(@NotNull HexPattern pattern) {
        Operator operator;
        Intrinsics.checkNotNullParameter((Object)pattern, (String)"pattern");
        HexPattern hexPattern = pattern;
        if (Intrinsics.areEqual((Object)hexPattern, (Object)Arithmetic.ADD)) {
            operator = (Operator)this.make2(StringArithmetic::getOperator$lambda$0);
        } else if (Intrinsics.areEqual((Object)hexPattern, (Object)Arithmetic.MUL)) {
            operator = (Operator)OperatorStringMul.INSTANCE;
        } else if (Intrinsics.areEqual((Object)hexPattern, (Object)Arithmetic.ABS)) {
            operator = (Operator)this.make1Double(StringArithmetic::getOperator$lambda$1);
        } else if (Intrinsics.areEqual((Object)hexPattern, (Object)Arithmetic.INDEX)) {
            operator = (Operator)OperatorStringIndex.INSTANCE;
        } else if (Intrinsics.areEqual((Object)hexPattern, (Object)Arithmetic.SLICE)) {
            operator = (Operator)OperatorStringSlice.INSTANCE;
        } else if (Intrinsics.areEqual((Object)hexPattern, (Object)Arithmetic.REV)) {
            operator = (Operator)this.make1(StringArithmetic::getOperator$lambda$2);
        } else if (Intrinsics.areEqual((Object)hexPattern, (Object)Arithmetic.INDEX_OF)) {
            operator = (Operator)OperatorStringIndexOf.INSTANCE;
        } else if (Intrinsics.areEqual((Object)hexPattern, (Object)Arithmetic.REMOVE)) {
            operator = (Operator)OperatorStringRemove.INSTANCE;
        } else if (Intrinsics.areEqual((Object)hexPattern, (Object)Arithmetic.REPLACE)) {
            operator = (Operator)OperatorStringReplace.INSTANCE;
        } else if (Intrinsics.areEqual((Object)hexPattern, (Object)Arithmetic.UNIQUE)) {
            operator = (Operator)this.make1(StringArithmetic::getOperator$lambda$4);
        } else {
            throw new InvalidOperatorException(pattern + " is not a valid operator in Arithmetic " + this + ".");
        }
        return operator;
    }

    private final OperatorUnary make1Double(Function<String, Double> op) {
        return new OperatorUnary(IotaMultiPredicate.all((IotaPredicate)IotaPredicate.ofType(MoreIotasIotaTypes.STRING)), arg_0 -> StringArithmetic.make1Double$lambda$5(op, arg_0));
    }

    private final OperatorUnary make1(UnaryOperator<String> op) {
        return new OperatorUnary(IotaMultiPredicate.all((IotaPredicate)IotaPredicate.ofType(MoreIotasIotaTypes.STRING)), arg_0 -> StringArithmetic.make1$lambda$6(op, arg_0));
    }

    private final OperatorBinary make2(BinaryOperator<String> op) {
        return new OperatorBinary(IotaMultiPredicate.all((IotaPredicate)IotaPredicate.ofType(MoreIotasIotaTypes.STRING)), (arg_0, arg_1) -> StringArithmetic.make2$lambda$7(op, arg_0, arg_1));
    }

    private static final String getOperator$lambda$0(String a, String b) {
        Intrinsics.checkNotNullParameter((Object)a, (String)"a");
        Intrinsics.checkNotNullParameter((Object)b, (String)"b");
        return a + b;
    }

    private static final Double getOperator$lambda$1(String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.length();
    }

    private static final String getOperator$lambda$2(String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return ((Object)StringsKt.reversed((CharSequence)it)).toString();
    }

    /*
     * WARNING - void declaration
     */
    private static final String getOperator$lambda$4(String str) {
        void $this$fold$iv;
        Intrinsics.checkNotNullParameter((Object)str, (String)"str");
        CharSequence charSequence = str;
        StringBuilder initial$iv = new StringBuilder();
        boolean $i$f$fold = false;
        StringBuilder accumulator$iv = initial$iv;
        for (int i = 0; i < $this$fold$iv.length(); ++i) {
            void c;
            char element$iv;
            char c2 = element$iv = $this$fold$iv.charAt(i);
            StringBuilder b = accumulator$iv;
            boolean bl = false;
            if (!StringsKt.contains$default((CharSequence)b, (char)c, (boolean)false, (int)2, null)) {
                b.append((char)c);
            }
            accumulator$iv = b;
        }
        return accumulator$iv.toString();
    }

    private static final Iota make1Double$lambda$5(Function $op, Iota i) {
        Intrinsics.checkNotNullParameter((Object)$op, (String)"$op");
        Intrinsics.checkNotNullParameter((Object)i, (String)"i");
        Object r = $op.apply(((StringIota)Operator.Companion.downcast(i, MoreIotasIotaTypes.STRING)).getString());
        Intrinsics.checkNotNullExpressionValue(r, (String)"op.apply(Operator.downcast(i, STRING).string)");
        return (Iota)new DoubleIota(((Number)r).doubleValue());
    }

    private static final Iota make1$lambda$6(UnaryOperator $op, Iota i) {
        Intrinsics.checkNotNullParameter((Object)$op, (String)"$op");
        Intrinsics.checkNotNullParameter((Object)i, (String)"i");
        return StringIota.make((String)$op.apply(((StringIota)Operator.Companion.downcast(i, MoreIotasIotaTypes.STRING)).getString()));
    }

    private static final Iota make2$lambda$7(BinaryOperator $op, Iota i, Iota j) {
        Intrinsics.checkNotNullParameter((Object)$op, (String)"$op");
        Intrinsics.checkNotNullParameter((Object)i, (String)"i");
        Intrinsics.checkNotNullParameter((Object)j, (String)"j");
        return StringIota.make((String)$op.apply(((StringIota)Operator.Companion.downcast(i, MoreIotasIotaTypes.STRING)).getString(), ((StringIota)Operator.Companion.downcast(j, MoreIotasIotaTypes.STRING)).getString()));
    }

    static {
        Object[] objectArray = new HexPattern[]{Arithmetic.ADD, Arithmetic.MUL, Arithmetic.ABS, Arithmetic.INDEX, Arithmetic.SLICE, Arithmetic.REV, Arithmetic.INDEX_OF, Arithmetic.REMOVE, Arithmetic.REPLACE, Arithmetic.UNIQUE};
        OPS = CollectionsKt.listOf((Object[])objectArray);
    }
}

