/*
 * Decompiled with CFR 0.152.
 */
package ram.talia.moreiotas.common.casting.arithmetic;

import at.petrak.hexcasting.api.casting.arithmetic.Arithmetic;
import at.petrak.hexcasting.api.casting.arithmetic.engine.InvalidOperatorException;
import at.petrak.hexcasting.api.casting.arithmetic.operator.Operator;
import at.petrak.hexcasting.api.casting.arithmetic.operator.OperatorUnary;
import at.petrak.hexcasting.api.casting.arithmetic.predicates.IotaMultiPredicate;
import at.petrak.hexcasting.api.casting.arithmetic.predicates.IotaPredicate;
import at.petrak.hexcasting.api.casting.iota.DoubleIota;
import at.petrak.hexcasting.api.casting.iota.Iota;
import at.petrak.hexcasting.api.casting.math.HexDir;
import at.petrak.hexcasting.api.casting.math.HexPattern;
import java.util.List;
import java.util.function.Function;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;
import ram.talia.moreiotas.api.casting.iota.ItemStackIota;
import ram.talia.moreiotas.common.casting.arithmetic.operator.type.OperatorExtractItem;
import ram.talia.moreiotas.common.lib.hex.MoreIotasIotaTypes;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\u001c\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\b\u001a\u00020\tH\u0016J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0004H\u0016J\u001c\u0010\r\u001a\u00020\u000e2\u0012\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u00120\u0010H\u0002J\u000e\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00040\u0014H\u0016R\u0010\u0010\u0003\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0005\u001a\u0010\u0012\f\u0012\n \u0007*\u0004\u0018\u00010\u00040\u00040\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lram/talia/moreiotas/common/casting/arithmetic/ItemArithmetic;", "Lat/petrak/hexcasting/api/casting/arithmetic/Arithmetic;", "()V", "EXTRACT_ITEM", "Lat/petrak/hexcasting/api/casting/math/HexPattern;", "OPS", "", "kotlin.jvm.PlatformType", "arithName", "", "getOperator", "Lat/petrak/hexcasting/api/casting/arithmetic/operator/Operator;", "pattern", "make1Double", "Lat/petrak/hexcasting/api/casting/arithmetic/operator/OperatorUnary;", "op", "Ljava/util/function/Function;", "Lnet/minecraft/world/item/ItemStack;", "", "opTypes", "", "moreiotas-forge-1.20.1"})
public final class ItemArithmetic
implements Arithmetic {
    @NotNull
    public static final ItemArithmetic INSTANCE = new ItemArithmetic();
    @JvmField
    @NotNull
    public static final HexPattern EXTRACT_ITEM = HexPattern.Companion.fromAngles("qaqqaea", HexDir.EAST);
    @NotNull
    private static final List<HexPattern> OPS;

    private ItemArithmetic() {
    }

    @NotNull
    public String arithName() {
        return "item_ops";
    }

    @NotNull
    public Iterable<HexPattern> opTypes() {
        return OPS;
    }

    @NotNull
    public Operator getOperator(@NotNull HexPattern pattern) {
        Operator operator;
        Intrinsics.checkNotNullParameter((Object)pattern, (String)"pattern");
        HexPattern hexPattern = pattern;
        if (Intrinsics.areEqual((Object)hexPattern, (Object)Arithmetic.ABS)) {
            operator = (Operator)this.make1Double(ItemArithmetic::getOperator$lambda$0);
        } else if (Intrinsics.areEqual((Object)hexPattern, (Object)EXTRACT_ITEM)) {
            operator = (Operator)OperatorExtractItem.INSTANCE;
        } else {
            throw new InvalidOperatorException(pattern + " is not a valid operator in Arithmetic " + this + ".");
        }
        return operator;
    }

    private final OperatorUnary make1Double(Function<ItemStack, Double> op) {
        return new OperatorUnary(IotaMultiPredicate.all((IotaPredicate)IotaPredicate.ofType(MoreIotasIotaTypes.ITEM_STACK)), arg_0 -> ItemArithmetic.make1Double$lambda$1(op, arg_0));
    }

    private static final Double getOperator$lambda$0(ItemStack it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.m_41619_() ? Double.valueOf(0.0) : Double.valueOf(it.m_41613_());
    }

    private static final Iota make1Double$lambda$1(Function $op, Iota i) {
        Intrinsics.checkNotNullParameter((Object)$op, (String)"$op");
        Intrinsics.checkNotNullParameter((Object)i, (String)"i");
        Object r = $op.apply(((ItemStackIota)Operator.Companion.downcast(i, MoreIotasIotaTypes.ITEM_STACK)).getItemStack());
        Intrinsics.checkNotNullExpressionValue(r, (String)"op.apply(Operator.downca\u2026i, ITEM_STACK).itemStack)");
        return (Iota)new DoubleIota(((Number)r).doubleValue());
    }

    static {
        Object[] objectArray = new HexPattern[]{Arithmetic.ABS, EXTRACT_ITEM};
        OPS = CollectionsKt.listOf((Object[])objectArray);
    }
}

