/*
 * Decompiled with CFR 0.152.
 */
package ram.talia.moreiotas.api.casting.iota;

import at.petrak.hexcasting.api.casting.iota.Iota;
import at.petrak.hexcasting.api.casting.iota.IotaType;
import at.petrak.hexcasting.api.casting.mishaps.MishapInvalidIota;
import at.petrak.hexcasting.api.utils.HexUtils;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.nbt.TagType;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import org.jetbrains.annotations.NotNull;
import ram.talia.moreiotas.api.mod.MoreIotasConfig;
import ram.talia.moreiotas.common.lib.hex.MoreIotasIotaTypes;

public class StringIota
extends Iota {
    public static IotaType<StringIota> TYPE = new IotaType<StringIota>(){

        public StringIota deserialize(Tag tag, ServerLevel world) throws IllegalArgumentException {
            StringTag stag = (StringTag)HexUtils.downcast((Tag)tag, (TagType)StringTag.f_129288_);
            try {
                return StringIota.make(stag.m_7916_());
            }
            catch (MishapInvalidIota e) {
                throw new IllegalArgumentException(e);
            }
        }

        public Component display(Tag tag) {
            if (!(tag instanceof StringTag)) {
                return Component.m_237115_((String)"hexcasting.spelldata.unknown");
            }
            StringTag stag = (StringTag)tag;
            return Component.m_237110_((String)"moreiotas.tooltip.string", (Object[])new Object[]{stag.m_7916_()}).m_130940_(ChatFormatting.LIGHT_PURPLE);
        }

        public int color() {
            return -43521;
        }
    };

    private StringIota(@NotNull String string) {
        super(MoreIotasIotaTypes.STRING, (Object)string);
    }

    public static StringIota make(@NotNull String string) throws MishapInvalidIota {
        if (string.length() > MoreIotasConfig.getServer().getMaxStringLength()) {
            throw MishapInvalidIota.of((Iota)new StringIota(string), (int)0, (String)"string.max_size", (Object[])new Object[]{MoreIotasConfig.getServer().getMaxStringLength(), string.length()});
        }
        return new StringIota(string);
    }

    public static StringIota makeUnchecked(@NotNull String string) {
        return new StringIota(string);
    }

    public String getString() {
        return (String)this.payload;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected boolean toleratesOther(Iota that) {
        if (!StringIota.typesMatch((Iota)this, (Iota)that)) return false;
        if (!(that instanceof StringIota)) return false;
        StringIota sthat = (StringIota)that;
        if (!this.getString().equals(sthat.getString())) return false;
        return true;
    }

    public boolean isTruthy() {
        return !this.getString().isEmpty();
    }

    @NotNull
    public Tag serialize() {
        return StringTag.m_129297_((String)this.getString());
    }
}

