/*
 * Decompiled with CFR 0.152.
 */
package ram.talia.moreiotas.api.casting.iota;

import at.petrak.hexcasting.api.casting.iota.Iota;
import at.petrak.hexcasting.api.casting.iota.IotaType;
import at.petrak.hexcasting.api.casting.mishaps.MishapInvalidIota;
import at.petrak.hexcasting.api.utils.HexUtils;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.DoubleTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.nbt.TagType;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerLevel;
import org.jblas.DoubleMatrix;
import org.jetbrains.annotations.NotNull;
import ram.talia.moreiotas.api.mod.MoreIotasConfig;
import ram.talia.moreiotas.common.lib.hex.MoreIotasIotaTypes;

public class MatrixIota
extends Iota {
    public static IotaType<MatrixIota> TYPE = new IotaType<MatrixIota>(){

        public MatrixIota deserialize(Tag tag, ServerLevel world) throws IllegalArgumentException {
            CompoundTag ctag = (CompoundTag)HexUtils.downcast((Tag)tag, (TagType)CompoundTag.f_128326_);
            try {
                return new MatrixIota(this.deserialise(ctag));
            }
            catch (MishapInvalidIota e) {
                throw new IllegalArgumentException(e);
            }
        }

        public Component display(Tag tag) {
            DoubleMatrix mat;
            if (!(tag instanceof CompoundTag)) {
                return Component.m_237115_((String)"hexcasting.spelldata.unknown");
            }
            CompoundTag ctag = (CompoundTag)tag;
            try {
                mat = this.deserialise(ctag);
            }
            catch (IllegalArgumentException e) {
                return Component.m_237115_((String)"hexcasting.spelldata.unknown");
            }
            MutableComponent out = Component.m_237119_();
            out.m_130946_(String.format("(%d, %d)", mat.rows, mat.columns));
            if (!mat.isEmpty()) {
                out.m_130946_(" | ");
            }
            for (int r = 0; r < mat.rows; ++r) {
                for (int c = 0; c < mat.columns; ++c) {
                    out.m_7220_((Component)Component.m_237113_((String)String.format("%.2f", mat.get(r, c))).m_130940_(ChatFormatting.GREEN));
                    if (c >= mat.columns - 1) continue;
                    out.m_130946_(", ");
                }
                if (r >= mat.rows - 1) continue;
                out.m_130946_("; ");
            }
            return Component.m_237110_((String)"hexcasting.tooltip.list_contents", (Object[])new Object[]{out}).m_130940_(ChatFormatting.AQUA);
        }

        private DoubleMatrix deserialise(CompoundTag ctag) throws IllegalArgumentException {
            if (!(ctag.m_128441_(MatrixIota.TAG_ROWS) && ctag.m_128441_(MatrixIota.TAG_COLS) && ctag.m_128441_(MatrixIota.TAG_MAT))) {
                throw new IllegalArgumentException("expected tags \"rows\": int, \"cols\": int, and \"mat\": list(list(double))");
            }
            int rows = ctag.m_128451_(MatrixIota.TAG_ROWS);
            int cols = ctag.m_128451_(MatrixIota.TAG_COLS);
            DoubleMatrix mat = new DoubleMatrix(rows, cols);
            ListTag list = ctag.m_128437_(MatrixIota.TAG_MAT, 9);
            for (int i = 0; i < rows; ++i) {
                ListTag curList = list.m_128744_(i);
                for (int j = 0; j < cols; ++j) {
                    mat.put(i, j, curList.m_128772_(j));
                }
            }
            return mat;
        }

        public int color() {
            return -11141121;
        }
    };
    private static final String TAG_ROWS = "rows";
    private static final String TAG_COLS = "cols";
    private static final String TAG_MAT = "mat";

    public MatrixIota(@NotNull DoubleMatrix matrix) throws MishapInvalidIota {
        super(MoreIotasIotaTypes.MATRIX, (Object)matrix);
        if (matrix.rows > MoreIotasConfig.getServer().getMaxMatrixSize() || matrix.columns > MoreIotasConfig.getServer().getMaxMatrixSize()) {
            throw MishapInvalidIota.of((Iota)this, (int)0, (String)"matrix.max_size", (Object[])new Object[]{MoreIotasConfig.getServer().getMaxMatrixSize(), matrix.rows, matrix.columns});
        }
    }

    public DoubleMatrix getMatrix() {
        return (DoubleMatrix)this.payload;
    }

    protected boolean toleratesOther(Iota that) {
        return false;
    }

    public boolean isTruthy() {
        return !this.getMatrix().isEmpty() && this.getMatrix().norm1() > 1.0E-4;
    }

    @NotNull
    public Tag serialize() {
        CompoundTag tag = new CompoundTag();
        DoubleMatrix mat = this.getMatrix();
        tag.m_128405_(TAG_ROWS, mat.rows);
        tag.m_128405_(TAG_COLS, mat.columns);
        ListTag list = new ListTag();
        for (int i = 0; i < mat.rows; ++i) {
            ListTag curList = new ListTag();
            for (int j = 0; j < mat.columns; ++j) {
                curList.add((Object)DoubleTag.m_128500_((double)mat.get(i, j)));
            }
            list.add((Object)curList);
        }
        tag.m_128365_(TAG_MAT, (Tag)list);
        return tag;
    }
}

