/*
 * Decompiled with CFR 0.152.
 */
package ram.talia.moreiotas.api.casting.iota;

import at.petrak.hexcasting.api.casting.iota.Iota;
import at.petrak.hexcasting.api.casting.iota.IotaType;
import at.petrak.hexcasting.api.utils.HexUtils;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.DataResult;
import java.util.Optional;
import net.minecraft.ChatFormatting;
import net.minecraft.core.DefaultedRegistry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.nbt.TagType;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import ram.talia.moreiotas.common.lib.hex.MoreIotasIotaTypes;

public class ItemTypeIota
extends Iota {
    public static IotaType<ItemTypeIota> TYPE = new IotaType<ItemTypeIota>(){

        @Nullable
        public ItemTypeIota deserialize(Tag tag, ServerLevel world) throws IllegalArgumentException {
            CompoundTag ctag = (CompoundTag)HexUtils.downcast((Tag)tag, (TagType)CompoundTag.f_128326_);
            if (ctag.m_128441_(ItemTypeIota.TAG_ITEM)) {
                DataResult typeLocation = ResourceLocation.m_135837_((String)ctag.m_128461_(ItemTypeIota.TAG_ITEM));
                Optional type = typeLocation.map(arg_0 -> ((DefaultedRegistry)BuiltInRegistries.f_257033_).m_7745_(arg_0)).get().left();
                return type.map(ItemTypeIota::new).orElse(null);
            }
            if (ctag.m_128441_(ItemTypeIota.TAG_BLOCK)) {
                DataResult typeLocation = ResourceLocation.m_135837_((String)ctag.m_128461_(ItemTypeIota.TAG_BLOCK));
                Optional type = typeLocation.map(arg_0 -> ((DefaultedRegistry)BuiltInRegistries.f_256975_).m_7745_(arg_0)).get().left();
                return type.map(ItemTypeIota::new).orElse(null);
            }
            return null;
        }

        public Component display(Tag tag) {
            if (!(tag instanceof CompoundTag)) {
                return Component.m_237115_((String)"hexcasting.spelldata.unknown");
            }
            CompoundTag ctag = (CompoundTag)tag;
            if (ctag.m_128441_(ItemTypeIota.TAG_ITEM)) {
                DataResult typeLocation = ResourceLocation.m_135837_((String)ctag.m_128461_(ItemTypeIota.TAG_ITEM));
                Optional type = typeLocation.map(arg_0 -> ((DefaultedRegistry)BuiltInRegistries.f_257033_).m_7745_(arg_0)).get().left();
                return (Component)type.map(t -> t.m_41466_().m_6881_().m_130940_(ChatFormatting.GOLD)).orElse(Component.m_237115_((String)"hexcasting.spelldata.unknown"));
            }
            if (ctag.m_128441_(ItemTypeIota.TAG_BLOCK)) {
                DataResult typeLocation = ResourceLocation.m_135837_((String)ctag.m_128461_(ItemTypeIota.TAG_BLOCK));
                Optional type = typeLocation.map(arg_0 -> ((DefaultedRegistry)BuiltInRegistries.f_256975_).m_7745_(arg_0)).get().left();
                return (Component)type.map(b -> b.m_49954_().m_130940_(ChatFormatting.GOLD)).orElse(Component.m_237115_((String)"hexcasting.spelldata.unknown"));
            }
            return Component.m_237115_((String)"hexcasting.spelldata.unknown");
        }

        public int color() {
            return -87551;
        }
    };
    private static final String TAG_ITEM = "item";
    private static final String TAG_BLOCK = "block";

    public ItemTypeIota(@NotNull Item item) {
        super(MoreIotasIotaTypes.ITEM_TYPE, (Object)Either.left((Object)item));
    }

    public ItemTypeIota(@NotNull Block block) {
        super(MoreIotasIotaTypes.ITEM_TYPE, (Object)Either.right((Object)block));
    }

    public Either<Item, Block> getEither() {
        return (Either)this.payload;
    }

    @Nullable
    public Block getBlock() {
        return (Block)this.getEither().map(item -> {
            if (item instanceof BlockItem) {
                BlockItem blockItem = (BlockItem)item;
                return blockItem.m_40614_();
            }
            return null;
        }, block -> block);
    }

    @Nullable
    public Item getItem() {
        return (Item)this.getEither().map(item -> item, Block::m_5456_);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected boolean toleratesOther(Iota that) {
        if (!ItemTypeIota.typesMatch((Iota)this, (Iota)that)) return false;
        if (!(that instanceof ItemTypeIota)) return false;
        ItemTypeIota dent = (ItemTypeIota)that;
        if ((Boolean)this.getEither().map(itemThis -> (Boolean)dent.getEither().map(itemThis::equals, blockThat -> {
            Item itemThat = blockThat.m_5456_();
            if (itemThat.equals(Items.f_41852_) && !blockThat.equals(Blocks.f_50016_)) {
                return false;
            }
            return itemThis.equals(itemThat);
        }), blockThis -> (Boolean)dent.getEither().map(itemThat -> {
            Item itemThis = blockThis.m_5456_();
            if (itemThis.equals(Items.f_41852_) && !blockThis.equals(Blocks.f_50016_)) {
                return false;
            }
            return itemThis.equals(itemThat);
        }, blockThis::equals)) == false) return false;
        return true;
    }

    public boolean isTruthy() {
        return (Boolean)this.getEither().map(item -> !item.equals(Items.f_41852_), block -> !block.equals(Blocks.f_50016_));
    }

    @NotNull
    public Tag serialize() {
        CompoundTag tag = new CompoundTag();
        return (Tag)this.getEither().map(item -> {
            tag.m_128359_(TAG_ITEM, BuiltInRegistries.f_257033_.m_7981_(item).toString());
            return tag;
        }, block -> {
            tag.m_128359_(TAG_BLOCK, BuiltInRegistries.f_256975_.m_7981_(block).toString());
            return tag;
        });
    }
}

