/*
 * Decompiled with CFR 0.152.
 */
package ram.talia.moreiotas.api.casting.iota;

import at.petrak.hexcasting.api.casting.iota.Iota;
import at.petrak.hexcasting.api.casting.iota.IotaType;
import at.petrak.hexcasting.api.utils.HexUtils;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.nbt.TagType;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.NotNull;
import ram.talia.moreiotas.common.lib.hex.MoreIotasIotaTypes;

public class ItemStackIota
extends Iota {
    public static IotaType<ItemStackIota> TYPE = new IotaType<ItemStackIota>(){

        public ItemStackIota deserialize(Tag tag, ServerLevel world) throws IllegalArgumentException {
            CompoundTag ctag = (CompoundTag)HexUtils.downcast((Tag)tag, (TagType)CompoundTag.f_128326_);
            if (ctag.m_128456_()) {
                return new ItemStackIota(ItemStack.f_41583_);
            }
            Item item = (Item)BuiltInRegistries.f_257033_.m_7745_(new ResourceLocation(ctag.m_128461_(ItemStackIota.TAG_STACK_ID)));
            int count = ctag.m_128451_(ItemStackIota.TAG_STACK_COUNT);
            Optional<Object> stackTag = Optional.empty();
            if (ctag.m_128425_(ItemStackIota.TAG_STACK_TAG, 10)) {
                stackTag = Optional.of(ctag.m_128469_(ItemStackIota.TAG_STACK_TAG));
                item.m_142312_((CompoundTag)stackTag.get());
            }
            ItemStack stack = new ItemStack((ItemLike)item, count);
            stackTag.ifPresent(arg_0 -> ((ItemStack)stack).m_41751_(arg_0));
            return new ItemStackIota(stack);
        }

        public Component display(Tag tag) {
            if (!(tag instanceof CompoundTag)) {
                return Component.m_237115_((String)"hexcasting.spelldata.unknown");
            }
            ItemStack stack = this.deserialize(tag, null).getItemStack();
            if (stack.m_41619_()) {
                return Component.m_237115_((String)"moreiotas.tooltip.stack.empty").m_130948_(Style.f_131099_.m_178520_(2003199));
            }
            return Component.m_237110_((String)"moreiotas.tooltip.stack.format", (Object[])new Object[]{stack.m_41613_(), stack.m_41611_()}).m_130948_(Style.f_131099_.m_178520_(2003199));
        }

        public int color() {
            return -14774017;
        }
    };
    private static final String TAG_STACK_ID = "moreiotas:stack_id";
    private static final String TAG_STACK_COUNT = "moreiotas:stack_count";
    private static final String TAG_STACK_TAG = "moreiotas:stack_tag";

    private ItemStackIota(ItemStack stack) {
        super(MoreIotasIotaTypes.ITEM_STACK, (Object)stack);
    }

    public ItemStack getItemStack() {
        return (ItemStack)this.payload;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected boolean toleratesOther(Iota iota) {
        if (!(iota instanceof ItemStackIota)) return false;
        ItemStackIota iiota = (ItemStackIota)iota;
        if (!ItemStack.m_41728_((ItemStack)this.getItemStack(), (ItemStack)iiota.getItemStack())) return false;
        return true;
    }

    public boolean isTruthy() {
        return !this.getItemStack().m_41619_();
    }

    @NotNull
    public Tag serialize() {
        CompoundTag tag = new CompoundTag();
        ItemStack stack = this.getItemStack();
        ResourceLocation item = BuiltInRegistries.f_257033_.m_7981_((Object)stack.m_41720_());
        tag.m_128359_(TAG_STACK_ID, item.toString());
        tag.m_128405_(TAG_STACK_COUNT, stack.m_41613_());
        if (stack.m_41783_() != null) {
            tag.m_128365_(TAG_STACK_TAG, (Tag)stack.m_41783_().m_6426_());
        }
        return tag;
    }

    public static ItemStackIota createFiltered(ItemStack originalStack) {
        ItemStack stack = originalStack.m_41777_();
        ArrayDeque<Object> workQueue = new ArrayDeque<Object>();
        if (stack.m_41782_()) {
            assert (stack.m_41783_() != null);
            workQueue.addLast(stack.m_41783_());
        }
        while (!workQueue.isEmpty()) {
            Tag next = (Tag)workQueue.removeFirst();
            if (next instanceof ListTag) {
                ListTag list = (ListTag)next;
                workQueue.addAll((Collection<Object>)list);
            }
            if (!(next instanceof CompoundTag)) continue;
            CompoundTag ctag = (CompoundTag)next;
            if (ctag.m_128441_(TAG_STACK_ID)) {
                ctag.m_128473_(TAG_STACK_ID);
                ctag.m_128473_(TAG_STACK_COUNT);
                ctag.m_128473_(TAG_STACK_TAG);
            }
            for (String key : ctag.m_128431_()) {
                workQueue.add(Objects.requireNonNull(ctag.m_128423_(key)));
            }
        }
        return new ItemStackIota(stack);
    }
}

