/*
 * Decompiled with CFR 0.152.
 */
package org.jblas.ranges;

import org.jblas.ranges.Range;

public class IntervalRange
implements Range {
    private int start;
    private int end;
    private int value;

    public IntervalRange(int a, int b) {
        this.start = a;
        this.end = b;
    }

    @Override
    public void init(int lower, int upper) {
        this.value = this.start;
        if (this.start < lower || this.end > upper + 1) {
            throw new IllegalArgumentException("Bounds " + lower + " to " + upper + " are beyond range interval " + this.start + " to " + this.end + ".");
        }
    }

    @Override
    public int length() {
        return this.end - this.start;
    }

    @Override
    public void next() {
        ++this.value;
    }

    @Override
    public int index() {
        return this.value - this.start;
    }

    @Override
    public int value() {
        return this.value;
    }

    @Override
    public boolean hasMore() {
        return this.value < this.end;
    }

    public String toString() {
        return String.format("<Interval Range from %d to %d, length %d index=%d value=%d>", this.start, this.end, this.length(), this.index(), this.value());
    }
}

