/*
 * Decompiled with CFR 0.152.
 */
package org.jblas.benchmark;

import org.jblas.FloatMatrix;
import org.jblas.benchmark.Benchmark;
import org.jblas.benchmark.BenchmarkResult;
import org.jblas.benchmark.Timer;

class JavaFloatMultiplicationBenchmark
implements Benchmark {
    JavaFloatMultiplicationBenchmark() {
    }

    @Override
    public String getName() {
        return "Java matrix multiplication, single precision";
    }

    private void mmuli(int n, float[] A, float[] B, float[] C) {
        for (int i = 0; i < n * n; ++i) {
            C[i] = 0.0f;
        }
        for (int j = 0; j < n; ++j) {
            int jn = j * n;
            for (int k = 0; k < n; ++k) {
                int kn = k * n;
                float bkjn = B[k + jn];
                for (int i = 0; i < n; ++i) {
                    int n2 = i + jn;
                    C[n2] = C[n2] + A[i + kn] * bkjn;
                }
            }
        }
    }

    @Override
    public BenchmarkResult run(int size, double seconds) {
        int counter = 0;
        long ops = 0L;
        float[] A = FloatMatrix.randn((int)size, (int)size).data;
        float[] B = FloatMatrix.randn((int)size, (int)size).data;
        float[] C = FloatMatrix.randn((int)size, (int)size).data;
        Timer t = new Timer();
        t.start();
        while (!t.ranFor(seconds)) {
            this.mmuli(size, A, B, C);
            ++counter;
            ops += 2L * (long)size * (long)size * (long)size;
        }
        t.stop();
        return new BenchmarkResult(ops, t.elapsedSeconds(), counter);
    }
}

