/*
 * Decompiled with CFR 0.152.
 */
package com.alrex.parcool.common.info;

import com.alrex.parcool.ParCool;
import com.alrex.parcool.common.action.Action;
import com.alrex.parcool.common.info.ClientSetting;
import com.alrex.parcool.common.info.ServerLimitation;
import com.alrex.parcool.config.ParCoolConfig;

public class ActionInfo {
    private ClientSetting clientSetting = ClientSetting.UNSYNCED_INSTANCE;
    private ServerLimitation serverLimitation = ServerLimitation.UNSYNCED_INSTANCE;

    public ClientSetting getClientSetting() {
        return this.clientSetting;
    }

    public void setClientSetting(ClientSetting clientSetting) {
        this.clientSetting = clientSetting;
    }

    public ServerLimitation getServerLimitation() {
        return this.serverLimitation;
    }

    public void setServerLimitation(ServerLimitation serverLimitation) {
        this.serverLimitation = serverLimitation;
    }

    public boolean can(Class<? extends Action> action) {
        return ParCool.isActive() && this.getClientSetting().getPossibilityOf(action) && this.getServerLimitation().isPermitted(action);
    }

    public int getStaminaConsumptionOf(Class<? extends Action> action) {
        return Math.max(this.getClientSetting().getStaminaConsumptionOf(action), this.getServerLimitation().getStaminaConsumptionOf(action));
    }

    public int getStaminaRecoveryLimit() {
        return this.getServerLimitation().get(ParCoolConfig.Server.Integers.MaxStaminaRecovery);
    }

    public int getMaxStaminaLimit() {
        return this.getServerLimitation().get(ParCoolConfig.Server.Integers.MaxStaminaLimit);
    }

    public boolean isStaminaInfinite(boolean creativeOrSpectator) {
        if (this.getClientSetting().get(ParCoolConfig.Client.Booleans.InfiniteStamina).booleanValue() && this.isInfiniteStaminaPermitted()) {
            return true;
        }
        return creativeOrSpectator && this.getClientSetting().get(ParCoolConfig.Client.Booleans.InfiniteStaminaWhenCreative) != false;
    }

    public boolean isInfiniteStaminaPermitted() {
        return this.serverLimitation.get(ParCoolConfig.Server.Booleans.AllowInfiniteStamina);
    }
}

