/*
 * Decompiled with CFR 0.152.
 */
package com.alrex.parcool.common.action;

import com.alrex.parcool.ParCool;
import com.alrex.parcool.api.unstable.action.ParCoolActionEvent;
import com.alrex.parcool.common.action.Action;
import com.alrex.parcool.common.action.StaminaConsumeTiming;
import com.alrex.parcool.common.capability.Animation;
import com.alrex.parcool.common.capability.IStamina;
import com.alrex.parcool.common.capability.Parkourability;
import com.alrex.parcool.common.network.SyncActionStateMessage;
import com.alrex.parcool.common.network.SyncStaminaMessage;
import com.alrex.parcool.config.ParCoolConfig;
import java.nio.ByteBuffer;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.ViewportEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.LogicalSide;
import org.apache.logging.log4j.Level;

public class ActionProcessor {
    private final ByteBuffer bufferOfPostState = ByteBuffer.allocate(128);
    private final ByteBuffer bufferOfPreState = ByteBuffer.allocate(128);
    private final ByteBuffer bufferOfStarting = ByteBuffer.allocate(128);
    private int staminaSyncCoolTimeTick = 0;

    @OnlyIn(value=Dist.CLIENT)
    @SubscribeEvent
    public void onTickInClient(TickEvent.PlayerTickEvent event) {
        if (event.phase == TickEvent.Phase.START) {
            return;
        }
        if (event.side != LogicalSide.CLIENT) {
            return;
        }
        AbstractClientPlayer player = (AbstractClientPlayer)event.player;
        Animation animation = Animation.get((Player)player);
        if (animation == null) {
            return;
        }
        Parkourability parkourability = Parkourability.get((Player)player);
        if (parkourability == null) {
            return;
        }
        animation.tick(player, parkourability);
    }

    @SubscribeEvent
    public void onTick(TickEvent.PlayerTickEvent event) {
        Player player = event.player;
        IStamina stamina = IStamina.get(player);
        if (stamina == null) {
            return;
        }
        if (event.phase == TickEvent.Phase.START) {
            stamina.tick();
            return;
        }
        Parkourability parkourability = Parkourability.get(player);
        if (parkourability == null) {
            return;
        }
        List<Action> actions = parkourability.getList();
        boolean needSync = event.side == LogicalSide.CLIENT && player.m_7578_();
        SyncActionStateMessage.Encoder builder = SyncActionStateMessage.Encoder.reset();
        if (needSync && player.f_19797_ > 100 && player.f_19797_ % 150 == 0 && parkourability.limitationIsNotSynced() && player instanceof LocalPlayer) {
            LocalPlayer localPlayer = (LocalPlayer)player;
            int trialCount = parkourability.getSynchronizeTrialCount();
            if (trialCount < 5) {
                parkourability.trySyncLimitation(localPlayer);
                if (ParCoolConfig.Client.Booleans.ShowAutoResynchronizationNotification.get().booleanValue()) {
                    player.m_5661_((Component)Component.m_237115_((String)"parcool.message.error.limitation.not_synced"), false);
                }
                ParCool.LOGGER.log(Level.WARN, "Detected ParCool Limitation is not synced. Sending synchronization request...");
            } else if (trialCount == 5) {
                parkourability.incrementSynchronizeTrialCount();
                player.m_5661_((Component)Component.m_237115_((String)"parcool.message.error.limitation.fail_sync").m_130940_(ChatFormatting.DARK_RED), false);
                ParCool.LOGGER.log(Level.ERROR, "Failed to synchronize ParCool Limitation. There may be problems about server connection. Please report to the developer after checking connection");
            }
        }
        parkourability.getAdditionalProperties().onTick(player, parkourability);
        block0: for (Action action : actions) {
            StaminaConsumeTiming timing = action.getStaminaConsumeTiming();
            if (needSync) {
                this.bufferOfPreState.clear();
                action.saveSynchronizedState(this.bufferOfPreState);
                this.bufferOfPreState.flip();
            }
            if (action.isDoing()) {
                action.setDoingTick(action.getDoingTick() + 1);
                action.setNotDoingTick(0);
            } else {
                action.setDoingTick(0);
                action.setNotDoingTick(action.getNotDoingTick() + 1);
            }
            action.onTick(player, parkourability, stamina);
            if (event.side == LogicalSide.CLIENT) {
                action.onClientTick(player, parkourability, stamina);
            } else {
                action.onServerTick(player, parkourability, stamina);
            }
            if (player.m_7578_()) {
                if (action.isDoing()) {
                    boolean canContinue;
                    boolean bl = canContinue = parkourability.getActionInfo().can(action.getClass()) && !MinecraftForge.EVENT_BUS.post((Event)new ParCoolActionEvent.TryToContinueEvent(player, action)) && action.canContinue(player, parkourability, stamina);
                    if (!canContinue) {
                        action.setDoing(false);
                        action.onStopInLocalClient(player);
                        action.onStop(player);
                        MinecraftForge.EVENT_BUS.post((Event)new ParCoolActionEvent.StopEvent(player, action));
                        builder.appendFinishMsg(parkourability, action);
                    }
                } else {
                    this.bufferOfStarting.clear();
                    boolean start = !player.m_5833_() && parkourability.getActionInfo().can(action.getClass()) && !MinecraftForge.EVENT_BUS.post((Event)new ParCoolActionEvent.TryToStartEvent(player, action)) && action.canStart(player, parkourability, stamina, this.bufferOfStarting);
                    this.bufferOfStarting.flip();
                    if (start) {
                        action.setDoing(true);
                        action.onStart(player, parkourability, this.bufferOfStarting);
                        this.bufferOfStarting.rewind();
                        action.onStartInLocalClient(player, parkourability, stamina, this.bufferOfStarting);
                        this.bufferOfStarting.rewind();
                        MinecraftForge.EVENT_BUS.post((Event)new ParCoolActionEvent.StartEvent(player, action));
                        builder.appendStartData(parkourability, action, this.bufferOfStarting);
                        if (timing == StaminaConsumeTiming.OnStart) {
                            stamina.consume(parkourability.getActionInfo().getStaminaConsumptionOf(action.getClass()));
                        }
                    }
                }
            }
            if (action.isDoing()) {
                action.onWorkingTick(player, parkourability, stamina);
                if (event.side == LogicalSide.CLIENT) {
                    action.onWorkingTickInClient(player, parkourability, stamina);
                    if (player.m_7578_()) {
                        action.onWorkingTickInLocalClient(player, parkourability, stamina);
                        if (timing == StaminaConsumeTiming.OnWorking) {
                            stamina.consume(parkourability.getActionInfo().getStaminaConsumptionOf(action.getClass()));
                        }
                    }
                } else {
                    action.onWorkingTickInServer(player, parkourability, stamina);
                }
            }
            if (!needSync) continue;
            this.bufferOfPostState.clear();
            action.saveSynchronizedState(this.bufferOfPostState);
            this.bufferOfPostState.flip();
            if (this.bufferOfPostState.limit() == this.bufferOfPreState.limit()) {
                while (this.bufferOfPreState.hasRemaining()) {
                    if (this.bufferOfPostState.get() == this.bufferOfPreState.get()) continue;
                    this.bufferOfPostState.rewind();
                    builder.appendSyncData(parkourability, action, this.bufferOfPostState);
                    continue block0;
                }
                continue;
            }
            this.bufferOfPostState.rewind();
            builder.appendSyncData(parkourability, action, this.bufferOfPostState);
        }
        if (needSync) {
            SyncActionStateMessage.sync(player, builder);
            ++this.staminaSyncCoolTimeTick;
            if (!parkourability.limitationIsNotSynced() && (this.staminaSyncCoolTimeTick > 3 || stamina.wantToConsumeOnServer())) {
                this.staminaSyncCoolTimeTick = 0;
                SyncStaminaMessage.sync(player);
            }
            if (stamina.isImposingExhaustionPenalty() && parkourability.getClientInfo().get(ParCoolConfig.Client.Booleans.EnableStaminaExhaustionPenalty).booleanValue()) {
                player.m_6858_(false);
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    @SubscribeEvent
    public void onRenderTick(TickEvent.RenderTickEvent event) {
        LocalPlayer clientPlayer = Minecraft.m_91087_().f_91074_;
        if (clientPlayer == null) {
            return;
        }
        for (Player player : clientPlayer.m_20193_().m_6907_()) {
            Parkourability parkourability = Parkourability.get(player);
            if (parkourability == null) {
                return;
            }
            List<Action> actions = parkourability.getList();
            for (Action action : actions) {
                action.onRenderTick(event, player, parkourability);
            }
            Animation animation = Animation.get(player);
            if (animation == null) {
                return;
            }
            animation.onRenderTick(event, player, parkourability);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    @SubscribeEvent
    public void onViewRender(ViewportEvent.ComputeCameraAngles event) {
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player == null) {
            return;
        }
        Parkourability parkourability = Parkourability.get((Player)player);
        if (parkourability == null) {
            return;
        }
        Animation animation = Animation.get((Player)player);
        if (animation == null) {
            return;
        }
        animation.cameraSetup(event, player, parkourability);
    }
}

