/*
 * Decompiled with CFR 0.152.
 */
package dev.shadowsoffire.apotheosis.spawn.compat;

import dev.shadowsoffire.apotheosis.Apotheosis;
import dev.shadowsoffire.apotheosis.spawn.modifiers.SpawnerStats;
import dev.shadowsoffire.apotheosis.spawn.spawner.ApothSpawnerBlock;
import dev.shadowsoffire.apotheosis.spawn.spawner.ApothSpawnerTile;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import snownee.jade.api.BlockAccessor;
import snownee.jade.api.IBlockComponentProvider;
import snownee.jade.api.IServerDataProvider;
import snownee.jade.api.ITooltip;
import snownee.jade.api.IWailaClientRegistration;
import snownee.jade.api.IWailaCommonRegistration;
import snownee.jade.api.IWailaPlugin;
import snownee.jade.api.WailaPlugin;
import snownee.jade.api.config.IPluginConfig;

@WailaPlugin
public class SpawnerHwylaPlugin
implements IWailaPlugin,
IBlockComponentProvider,
IServerDataProvider<BlockAccessor> {
    private static final ApothSpawnerTile tooltipTile = new ApothSpawnerTile(BlockPos.f_121853_, Blocks.f_50016_.m_49966_());

    public void register(IWailaCommonRegistration reg) {
        if (Apotheosis.enableSpawner) {
            reg.registerBlockDataProvider((IServerDataProvider)this, ApothSpawnerTile.class);
        }
    }

    public void registerClient(IWailaClientRegistration reg) {
        if (Apotheosis.enableSpawner) {
            reg.registerBlockComponent((IBlockComponentProvider)this, ApothSpawnerBlock.class);
        }
    }

    public void appendTooltip(ITooltip tooltip, BlockAccessor accessor, IPluginConfig config) {
        if (Screen.m_96637_()) {
            tooltipTile.m_142466_(accessor.getServerData());
            SpawnerStats.generateTooltip(tooltipTile, arg_0 -> ((ITooltip)tooltip).add(arg_0));
        } else {
            tooltip.add((Component)Component.m_237115_((String)"misc.apotheosis.ctrl_stats"));
        }
    }

    public void appendServerData(CompoundTag tag, BlockAccessor access) {
        BlockEntity blockEntity = access.getBlockEntity();
        if (blockEntity instanceof ApothSpawnerTile) {
            ApothSpawnerTile spw = (ApothSpawnerTile)blockEntity;
            spw.m_183515_(tag);
        }
    }

    public ResourceLocation getUid() {
        return Apotheosis.loc("spawner");
    }
}

