/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.dyenamicsandfriends.compat;

import cy.jdkdigital.dyenamics.common.blocks.DyenamicCarpetBlock;
import cy.jdkdigital.dyenamics.core.util.DyenamicDyeColor;
import cy.jdkdigital.dyenamicsandfriends.common.block.entity.furnish.DyenamicsAmphoraBlockEntity;
import cy.jdkdigital.dyenamicsandfriends.common.block.entity.furnish.DyenamicsPlateBlockEntity;
import cy.jdkdigital.dyenamicsandfriends.common.block.entity.furnish.DyenamicsShowcaseBlockEntity;
import cy.jdkdigital.dyenamicsandfriends.common.block.furnish.DyenamicsAmphora;
import cy.jdkdigital.dyenamicsandfriends.common.block.furnish.DyenamicsCarpetOnStairs;
import cy.jdkdigital.dyenamicsandfriends.common.block.furnish.DyenamicsCarpetOnTrapdoor;
import cy.jdkdigital.dyenamicsandfriends.common.block.furnish.DyenamicsPlate;
import cy.jdkdigital.dyenamicsandfriends.common.block.furnish.DyenamicsShowcase;
import cy.jdkdigital.dyenamicsandfriends.registry.DyenamicRegistry;
import io.github.wouink.furnish.block.Awning;
import io.github.wouink.furnish.block.CarpetOnTrapdoor;
import io.github.wouink.furnish.block.Curtain;
import io.github.wouink.furnish.block.PaperLamp;
import io.github.wouink.furnish.block.Sofa;
import io.github.wouink.furnish.client.renderer.PlateRenderer;
import io.github.wouink.furnish.client.renderer.ShowcaseRenderer;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.core.Direction;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.StairBlock;
import net.minecraft.world.level.block.TrapDoorBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Half;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.StairsShape;
import net.minecraftforge.client.event.EntityRenderersEvent;
import net.minecraftforge.event.BuildCreativeModeTabContentsEvent;
import net.minecraftforge.event.level.BlockEvent;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.RegistryObject;

public class FurnishCompat {
    private static final Map<DyenamicDyeColor, RegistryObject<? extends Block>> SOFAS = new HashMap<DyenamicDyeColor, RegistryObject<? extends Block>>();
    private static final Map<DyenamicDyeColor, RegistryObject<? extends Block>> AWNINGS = new HashMap<DyenamicDyeColor, RegistryObject<? extends Block>>();
    private static final Map<DyenamicDyeColor, RegistryObject<? extends Block>> CURTAINS = new HashMap<DyenamicDyeColor, RegistryObject<? extends Block>>();
    private static final Map<DyenamicDyeColor, RegistryObject<? extends Block>> SHOWCASES = new HashMap<DyenamicDyeColor, RegistryObject<? extends Block>>();
    private static final Map<DyenamicDyeColor, RegistryObject<? extends Block>> AMPHORAS = new HashMap<DyenamicDyeColor, RegistryObject<? extends Block>>();
    private static final Map<DyenamicDyeColor, RegistryObject<? extends Block>> PLATES = new HashMap<DyenamicDyeColor, RegistryObject<? extends Block>>();
    private static final Map<DyenamicDyeColor, RegistryObject<? extends Block>> PAPER_LAMPS = new HashMap<DyenamicDyeColor, RegistryObject<? extends Block>>();
    public static final Map<DyenamicDyeColor, RegistryObject<? extends Block>> CARPET_ON_STAIRS = new HashMap<DyenamicDyeColor, RegistryObject<? extends Block>>();
    public static final Map<DyenamicDyeColor, RegistryObject<? extends Block>> CARPET_ON_TRAPDOOR = new HashMap<DyenamicDyeColor, RegistryObject<? extends Block>>();

    public static void registerBlocks(DyenamicDyeColor color) {
        String prefix = "furnish_" + color.m_7912_();
        BlockBehaviour.Properties carpetProps = BlockBehaviour.Properties.m_284310_().m_284180_(color.getMapColor()).m_60978_(0.1f).m_60918_(SoundType.f_56745_).m_60953_(state -> color.getLightValue());
        CARPET_ON_STAIRS.put(color, DyenamicRegistry.registerBlock(prefix + "_carpet_on_stairs", () -> new DyenamicsCarpetOnStairs(carpetProps, color), false));
        CARPET_ON_TRAPDOOR.put(color, DyenamicRegistry.registerBlock(prefix + "_carpet_on_trapdoor", () -> new DyenamicsCarpetOnTrapdoor(carpetProps, color), false));
        AWNINGS.put(color, DyenamicRegistry.registerBlock(prefix + "_awning", () -> new Awning(carpetProps), true));
        CURTAINS.put(color, DyenamicRegistry.registerBlock(prefix + "_curtain", () -> new Curtain(carpetProps), true));
        BlockBehaviour.Properties woolProps = BlockBehaviour.Properties.m_284310_().m_284180_(color.getMapColor()).m_60978_(0.8f).m_60918_(SoundType.f_56745_).m_60953_(state -> color.getLightValue());
        SOFAS.put(color, DyenamicRegistry.registerBlock(prefix + "_sofa", () -> new Sofa(woolProps), true));
        SHOWCASES.put(color, DyenamicRegistry.registerBlock(prefix + "_showcase", () -> new DyenamicsShowcase(woolProps, DyenamicRegistry.registerBlockEntity(prefix + "_showcase", () -> DyenamicRegistry.createBlockEntityType((pos, state) -> new DyenamicsShowcaseBlockEntity(pos, state, (DyenamicsShowcase)((Object)((Object)((Object)((Object)SHOWCASES.get(color).get()))))), (Block)SHOWCASES.get(color).get()))), true));
        BlockBehaviour.Properties terracottaProps = BlockBehaviour.Properties.m_284310_().m_284180_(color.getMapColor()).m_60913_(1.25f, 4.2f).m_60953_(state -> color.getLightValue());
        AMPHORAS.put(color, DyenamicRegistry.registerBlock(prefix + "_amphora", () -> new DyenamicsAmphora(terracottaProps, DyenamicRegistry.registerBlockEntity(prefix + "_amphora", () -> DyenamicRegistry.createBlockEntityType((pos, state) -> new DyenamicsAmphoraBlockEntity(pos, state, (DyenamicsAmphora)((Object)((Object)((Object)((Object)AMPHORAS.get(color).get()))))), (Block)AMPHORAS.get(color).get()))), true));
        PLATES.put(color, DyenamicRegistry.registerBlock(prefix + "_plate", () -> new DyenamicsPlate(terracottaProps, DyenamicRegistry.registerBlockEntity(prefix + "_plate", () -> DyenamicRegistry.createBlockEntityType((pos, state) -> new DyenamicsPlateBlockEntity(pos, state, (DyenamicsPlate)((Object)((Object)((Object)((Object)PLATES.get(color).get()))))), (Block)PLATES.get(color).get()))), true));
        PAPER_LAMPS.put(color, DyenamicRegistry.registerBlock(prefix + "_paper_lamp", PaperLamp::new, true));
    }

    public static void entityPlace(BlockEvent.EntityPlaceEvent event) {
        if (event.getPlacedBlock().m_60734_() instanceof DyenamicCarpetBlock) {
            if (!ForgeRegistries.BLOCKS.getKey((Object)event.getPlacedBlock().m_60734_()).m_135827_().equals("dyenamics")) {
                return;
            }
            BlockState stateBelow = event.getLevel().m_8055_(event.getPos().m_7495_());
            if (stateBelow.m_60734_() instanceof StairBlock && !event.getEntity().m_6144_()) {
                if (stateBelow.m_61143_((Property)StairBlock.f_56842_) == Half.BOTTOM && stateBelow.m_61143_((Property)StairBlock.f_56843_) == StairsShape.STRAIGHT) {
                    DyenamicDyeColor color = ((DyenamicCarpetBlock)event.getPlacedBlock().m_60734_()).getDyenamicColor();
                    event.getLevel().m_7731_(event.getPos(), (BlockState)((Block)CARPET_ON_STAIRS.get(color).get()).m_49966_().m_61124_((Property)BlockStateProperties.f_61374_, (Comparable)((Direction)stateBelow.m_61143_((Property)BlockStateProperties.f_61374_))), 3);
                }
            } else if (stateBelow.m_60734_() instanceof TrapDoorBlock && stateBelow.m_61143_((Property)TrapDoorBlock.f_57515_) == Half.TOP) {
                DyenamicDyeColor color = ((DyenamicCarpetBlock)event.getPlacedBlock().m_60734_()).getDyenamicColor();
                event.getLevel().m_7731_(event.getPos(), (BlockState)((BlockState)((Block)CARPET_ON_TRAPDOOR.get(color).get()).m_49966_().m_61124_((Property)BlockStateProperties.f_61374_, (Comparable)((Direction)stateBelow.m_61143_((Property)BlockStateProperties.f_61374_)))).m_61124_((Property)CarpetOnTrapdoor.OPEN, (Comparable)((Boolean)stateBelow.m_61143_((Property)TrapDoorBlock.f_57514_))), 3);
            }
        }
    }

    public static void buildTabContents(BuildCreativeModeTabContentsEvent event) {
        ResourceKey key = ResourceKey.m_135785_((ResourceKey)Registries.f_279569_, (ResourceLocation)new ResourceLocation("furnish:furnish"));
        if (event.getTabKey().equals((Object)key)) {
            SOFAS.forEach((dyenamicDyeColor, registryObject) -> event.accept((Supplier)registryObject));
            AWNINGS.forEach((dyenamicDyeColor, registryObject) -> event.accept((Supplier)registryObject));
            CURTAINS.forEach((dyenamicDyeColor, registryObject) -> event.accept((Supplier)registryObject));
            SHOWCASES.forEach((dyenamicDyeColor, registryObject) -> event.accept((Supplier)registryObject));
            AMPHORAS.forEach((dyenamicDyeColor, registryObject) -> event.accept((Supplier)registryObject));
            PLATES.forEach((dyenamicDyeColor, registryObject) -> event.accept((Supplier)registryObject));
            PAPER_LAMPS.forEach((dyenamicDyeColor, registryObject) -> event.accept((Supplier)registryObject));
        }
    }

    public static class Client {
        public static void registerBlockEntityRenderers(EntityRenderersEvent.RegisterRenderers event) {
            SHOWCASES.values().forEach(registryObject -> {
                Object patt8726$temp = registryObject.get();
                if (patt8726$temp instanceof DyenamicsShowcase) {
                    DyenamicsShowcase showcase = (DyenamicsShowcase)((Object)((Object)patt8726$temp));
                    event.registerBlockEntityRenderer(showcase.getBlockEntitySupplier().get(), ShowcaseRenderer::new);
                }
            });
            PLATES.values().forEach(registryObject -> {
                Object patt9022$temp = registryObject.get();
                if (patt9022$temp instanceof DyenamicsPlate) {
                    DyenamicsPlate plate = (DyenamicsPlate)((Object)((Object)patt9022$temp));
                    event.registerBlockEntityRenderer(plate.getBlockEntitySupplier().get(), PlateRenderer::new);
                }
            });
        }
    }
}

