/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.dyenamicsandfriends.client.render.sleep_tight;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import cy.jdkdigital.dyenamics.core.util.DyenamicDyeColor;
import cy.jdkdigital.dyenamicsandfriends.common.block.entity.sleep_tight.DyenamicsHammockBlockEntity;
import java.util.Arrays;
import java.util.Comparator;
import net.mehvahdjukaar.sleep_tight.SleepTightClient;
import net.mehvahdjukaar.sleep_tight.client.renderers.HammockBlockTileRenderer;
import net.mehvahdjukaar.sleep_tight.common.HammockPart;
import net.mehvahdjukaar.sleep_tight.common.blocks.HammockBlock;
import net.mehvahdjukaar.sleep_tight.common.tiles.HammockTile;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.resources.model.Material;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class DyenamicsHammockBlockTileRenderer
extends HammockBlockTileRenderer {
    public static final ResourceLocation BED_SHEET = new ResourceLocation("textures/atlas/beds.png");
    public static final Material[] HAMMOCK_TEXTURES = (Material[])Arrays.stream(DyenamicDyeColor.values()).sorted(Comparator.comparingInt(DyenamicDyeColor::getId)).map(dyeColor -> new Material(BED_SHEET, new ResourceLocation("dyenamicsandfriends", "entity/sleep_tight/hammocks/" + dyeColor.m_7912_()))).toArray(Material[]::new);
    private final ModelPart model;
    private final ModelPart ropeF;
    private final ModelPart ropeB;

    public DyenamicsHammockBlockTileRenderer(BlockEntityRendererProvider.Context context) {
        super(context);
        this.model = context.m_173582_(SleepTightClient.HAMMOCK);
        this.ropeF = this.model.m_171324_("rope_f");
        this.ropeB = this.model.m_171324_("rope_b");
    }

    public void render(HammockTile blockEntity, float partialTick, PoseStack poseStack, MultiBufferSource bufferSource, int packedLight, int packedOverlay) {
        if (blockEntity instanceof DyenamicsHammockBlockEntity) {
            float zOffset;
            DyenamicsHammockBlockEntity hammockBlockEntity = (DyenamicsHammockBlockEntity)blockEntity;
            BlockState state = hammockBlockEntity.m_58900_();
            HammockPart value = (HammockPart)state.m_61143_((Property)HammockBlock.PART);
            boolean onRope = value.isOnFence();
            double dy = value.getPivotOffset();
            if (onRope) {
                zOffset = -0.5f;
                this.ropeB.f_104203_ = -2.6179938f;
                this.ropeF.f_104203_ = -0.5235988f;
            } else {
                zOffset = 0.0f;
                this.ropeB.f_104203_ = -2.268928f;
                this.ropeF.f_104203_ = -0.8726647f;
            }
            poseStack.m_85836_();
            poseStack.m_85837_(0.5, 0.5 + dy, 0.5);
            poseStack.m_252781_(Axis.f_252436_.m_252977_(-((Direction)state.m_61143_((Property)HammockBlock.f_54117_)).m_122435_()));
            float yaw = hammockBlockEntity.getRoll(partialTick);
            poseStack.m_252781_(Axis.f_252403_.m_252977_(180.0f + yaw));
            poseStack.m_85837_(0.0, 0.5 + dy, (double)zOffset);
            Material material = HAMMOCK_TEXTURES[hammockBlockEntity.getDyenamicColor().getId()];
            VertexConsumer vertexConsumer = material.m_119194_(bufferSource, RenderType::m_110458_);
            this.model.m_104301_(poseStack, vertexConsumer, packedLight, packedOverlay);
            poseStack.m_85849_();
        }
    }
}

