/*
 * Decompiled with CFR 0.152.
 */
package at.petrak.hexcasting.forge.interop.jei;

import at.petrak.hexcasting.api.casting.ActionRegistryEntry;
import at.petrak.hexcasting.api.casting.math.HexPattern;
import at.petrak.hexcasting.api.mod.HexTags;
import at.petrak.hexcasting.api.utils.HexUtils;
import at.petrak.hexcasting.client.render.PatternColors;
import at.petrak.hexcasting.client.render.PatternRenderer;
import at.petrak.hexcasting.client.render.PatternSettings;
import at.petrak.hexcasting.xplat.IXplatAbstractions;
import com.mojang.blaze3d.vertex.PoseStack;
import mezz.jei.api.gui.drawable.IDrawable;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceLocation;

public class PatternDrawable
implements IDrawable {
    private final int width;
    private final int height;
    private boolean strokeOrder;
    private final HexPattern pat;
    private PatternSettings patSets;

    public PatternDrawable(ResourceLocation pattern, int w, int h) {
        Registry<ActionRegistryEntry> regi = IXplatAbstractions.INSTANCE.getActionRegistry();
        ActionRegistryEntry entry = (ActionRegistryEntry)regi.m_7745_(pattern);
        this.strokeOrder = !HexUtils.isOfTag(regi, pattern, HexTags.Actions.PER_WORLD_PATTERN);
        this.pat = entry.prototype();
        this.width = w;
        this.height = h;
        this.patSets = new PatternSettings("pattern_drawable_" + w + "_" + h, new PatternSettings.PositionSettings(this.width, this.height, 0.0, 0.0, PatternSettings.AxisAlignment.CENTER_FIT, PatternSettings.AxisAlignment.CENTER_FIT, Math.max(this.width, this.height), 0.0, 0.0), PatternSettings.StrokeSettings.fromStroke(0.075 * (double)Math.min(this.width, this.height)), PatternSettings.ZappySettings.READABLE);
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public PatternDrawable strokeOrder(boolean order) {
        if (order != this.strokeOrder) {
            this.patSets = new PatternSettings("pattern_drawable_" + this.width + "_" + this.height + (order ? "" : "nostroke"), this.patSets.posSets, this.patSets.strokeSets, order ? PatternSettings.ZappySettings.READABLE : PatternSettings.ZappySettings.STATIC);
        }
        this.strokeOrder = order;
        return this;
    }

    public void draw(GuiGraphics graphics, int x, int y) {
        PoseStack ps = graphics.m_280168_();
        ps.m_85836_();
        ps.m_252880_((float)x, (float)(y + 1), 0.0f);
        PatternRenderer.renderPattern(this.pat, graphics.m_280168_(), this.patSets, new PatternColors(-938735092, -13422544).withDotColors(-2140773533, 0), 0.0, 10);
        ps.m_85849_();
    }
}

