/*
 * Decompiled with CFR 0.152.
 */
package at.petrak.hexcasting.forge.datagen.xplat;

import at.petrak.hexcasting.client.render.GaslightingTracker;
import at.petrak.hexcasting.common.items.ItemStaff;
import at.petrak.hexcasting.common.items.magic.ItemMediaBattery;
import at.petrak.hexcasting.common.items.magic.ItemPackagedHex;
import at.petrak.hexcasting.common.items.pigment.ItemPridePigment;
import at.petrak.hexcasting.common.items.storage.ItemFocus;
import at.petrak.hexcasting.common.items.storage.ItemScroll;
import at.petrak.hexcasting.common.items.storage.ItemSlate;
import at.petrak.hexcasting.common.items.storage.ItemThoughtKnot;
import at.petrak.hexcasting.common.lib.HexBlocks;
import at.petrak.hexcasting.common.lib.HexItems;
import at.petrak.paucal.api.forge.datagen.PaucalItemModelProvider;
import java.util.Arrays;
import java.util.Objects;
import java.util.function.BiFunction;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.client.model.generators.ItemModelBuilder;
import net.minecraftforge.client.model.generators.ModelFile;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.registries.ForgeRegistries;

public class HexItemModels
extends PaucalItemModelProvider {
    private static final String[] PHIAL_SIZES = new String[]{"small", "medium", "large", "larger", "largest"};
    private static final Integer[] PACKAGED_SPELL_HANDHELD_VARIANTS = new Integer[]{5};

    public HexItemModels(PackOutput output, ExistingFileHelper existingFileHelper) {
        super(output, "hexcasting", existingFileHelper);
    }

    private static String getPath(Item item) {
        return Objects.requireNonNull(ForgeRegistries.ITEMS.getKey((Object)item)).m_135815_();
    }

    private static String getPath(Block block) {
        return Objects.requireNonNull(ForgeRegistries.BLOCKS.getKey((Object)block)).m_135815_();
    }

    /*
     * WARNING - void declaration
     */
    protected void registerModels() {
        void var2_5;
        this.simpleItem(HexItems.AMETHYST_DUST);
        this.simpleItem(HexItems.CHARGED_AMETHYST);
        this.simpleItem(HexItems.SUBMARINE_SANDWICH);
        this.simpleItem(HexItems.ABACUS);
        this.brandishedItem((Item)HexItems.JEWELER_HAMMER);
        this.simpleItem(HexItems.CREATIVE_UNLOCKER);
        this.simpleItem(HexItems.LORE_FRAGMENT);
        this.singleTexture(HexItemModels.getPath(HexBlocks.CONJURED_BLOCK), new ResourceLocation("item/generated"), "layer0", new ResourceLocation("item/amethyst_shard"));
        this.singleTexture(HexItemModels.getPath(HexBlocks.CONJURED_LIGHT), new ResourceLocation("item/generated"), "layer0", new ResourceLocation("item/amethyst_shard"));
        for (String age : new String[]{"pristine", "ancient"}) {
            for (String size : new String[]{"small", "medium", "large"}) {
                this.simpleItem(this.modLoc("scroll_" + age + "_" + size));
            }
        }
        this.buildScroll(HexItems.SCROLL_SMOL, "small");
        this.buildScroll(HexItems.SCROLL_MEDIUM, "medium");
        this.buildScroll(HexItems.SCROLL_LARGE, "large");
        this.simpleItem(HexItems.SCRYING_LENS);
        ((ItemModelBuilder)this.getBuilder(HexItemModels.getPath(HexItems.SCRYING_LENS))).transforms().transform(ItemDisplayContext.HEAD).rotation(0.0f, 0.0f, 0.0f).translation(-2.5f, 0.0f, -8.0f).scale(0.4f);
        this.singleTexture("old_staff", new ResourceLocation("item/handheld_rod"), "layer0", this.modLoc("item/staff/old"));
        this.singleTexture("cherry_staff", new ResourceLocation("item/handheld_rod"), "layer0", this.modLoc("item/staff/cherry"));
        this.buildStaff(HexItems.STAFF_OAK, "oak");
        this.buildStaff(HexItems.STAFF_BIRCH, "birch");
        this.buildStaff(HexItems.STAFF_SPRUCE, "spruce");
        this.buildStaff(HexItems.STAFF_JUNGLE, "jungle");
        this.buildStaff(HexItems.STAFF_DARK_OAK, "dark_oak");
        this.buildStaff(HexItems.STAFF_ACACIA, "acacia");
        this.buildStaff(HexItems.STAFF_CRIMSON, "crimson");
        this.buildStaff(HexItems.STAFF_WARPED, "warped");
        this.buildStaff(HexItems.STAFF_MANGROVE, "mangrove");
        this.buildStaff(HexItems.STAFF_CHERRY, "cherry");
        this.buildStaff(HexItems.STAFF_BAMBOO, "bamboo");
        this.buildStaff(HexItems.STAFF_EDIFIED, "edified");
        this.buildStaff(HexItems.STAFF_MINDSPLICE, "mindsplice");
        this.buildFourVariantGaslight("item/staff/quenched", "item/staff/quenched", (name, path) -> this.singleTexture(path.m_135815_(), new ResourceLocation("item/handheld_rod"), "layer0", this.modLoc(path.m_135815_())));
        this.buildFourVariantGaslight(HexItemModels.getPath(HexItems.QUENCHED_SHARD), "item/quenched_shard", (name, path) -> this.singleTexture(path.m_135815_(), new ResourceLocation("item/handheld"), "layer0", this.modLoc(path.m_135815_())));
        this.buildFourVariantGaslight(HexItemModels.getPath(HexBlocks.QUENCHED_ALLAY), "block/quenched_allay", (name, path) -> this.cubeAll(path.m_135815_(), (ResourceLocation)path));
        this.buildFourVariantGaslight(HexItemModels.getPath(HexBlocks.QUENCHED_ALLAY_TILES), "block/deco/quenched_allay_tiles", (name, path) -> this.cubeAll(path.m_135815_(), (ResourceLocation)path));
        this.buildFourVariantGaslight(HexItemModels.getPath(HexBlocks.QUENCHED_ALLAY_BRICKS), "block/deco/quenched_allay_bricks", (name, path) -> this.cubeAll(path.m_135815_(), (ResourceLocation)path));
        this.buildFourVariantGaslight(HexItemModels.getPath(HexBlocks.QUENCHED_ALLAY_BRICKS_SMALL), "block/deco/quenched_allay_bricks_small", (name, path) -> this.cubeAll(path.m_135815_(), (ResourceLocation)path));
        this.simpleItem(this.modLoc("patchouli_book"));
        this.buildThoughtKnot();
        this.buildSealableIotaHolder(HexItems.FOCUS, "focus", HexItems.FOCUS.numVariants());
        this.buildSealableIotaHolder(HexItems.SPELLBOOK, "spellbook", HexItems.SPELLBOOK.numVariants());
        this.buildPackagedSpell(HexItems.ANCIENT_CYPHER, "ancient_cypher", HexItems.ANCIENT_CYPHER.numVariants());
        this.buildPackagedSpell(HexItems.CYPHER, "cypher", HexItems.CYPHER.numVariants());
        this.buildPackagedSpell(HexItems.TRINKET, "trinket", HexItems.TRINKET.numVariants());
        this.buildPackagedSpell(HexItems.ARTIFACT, "artifact", HexItems.ARTIFACT.numVariants());
        int maxFill = 4;
        boolean bl = false;
        while (var2_5 < PHIAL_SIZES.length) {
            for (int fill = 0; fill <= maxFill; ++fill) {
                String name2 = "phial_" + PHIAL_SIZES[var2_5] + "_" + fill;
                this.singleTexture(name2, new ResourceLocation("item/generated"), "layer0", this.modLoc("item/phial/" + name2));
                float f = (float)fill / (float)maxFill;
                ((ItemModelBuilder)this.getBuilder(HexItemModels.getPath(HexItems.BATTERY))).override().predicate(ItemMediaBattery.MEDIA_PREDICATE, f).predicate(ItemMediaBattery.MAX_MEDIA_PREDICATE, (float)var2_5).model((ModelFile)new ModelFile.UncheckedModelFile(this.modLoc("item/" + name2))).end();
            }
            ++var2_5;
        }
        for (DyeColor dyeColor : DyeColor.values()) {
            this.singleTexture(HexItemModels.getPath(HexItems.DYE_PIGMENTS.get(dyeColor)), new ResourceLocation("item/generated"), "layer0", this.modLoc("item/colorizer/dye_" + dyeColor.m_41065_()));
        }
        for (ItemPridePigment.Type type : ItemPridePigment.Type.values()) {
            this.singleTexture(HexItemModels.getPath(HexItems.PRIDE_PIGMENTS.get((Object)type)), new ResourceLocation("item/generated"), "layer0", this.modLoc("item/colorizer/pride_" + type.getName()));
        }
        this.singleTexture(HexItemModels.getPath(HexItems.UUID_PIGMENT), new ResourceLocation("item/generated"), "layer0", this.modLoc("item/colorizer/uuid"));
        this.singleTexture(HexItemModels.getPath(HexItems.DEFAULT_PIGMENT), new ResourceLocation("item/generated"), "layer0", this.modLoc("item/colorizer/default"));
        this.singleTexture(HexItemModels.getPath(HexItems.ANCIENT_PIGMENT), new ResourceLocation("item/generated"), "layer0", this.modLoc("item/colorizer/ancient"));
        this.simpleItem(this.modLoc("slate_blank"));
        this.simpleItem(this.modLoc("slate_written"));
        ((ItemModelBuilder)this.getBuilder(HexItemModels.getPath((Item)HexItems.SLATE))).override().predicate(ItemSlate.WRITTEN_PRED, 0.0f).model((ModelFile)new ModelFile.UncheckedModelFile(this.modLoc("item/slate_blank"))).end().override().predicate(ItemSlate.WRITTEN_PRED, 1.0f).model((ModelFile)new ModelFile.UncheckedModelFile(this.modLoc("item/slate_written"))).end();
        ((ItemModelBuilder)this.getBuilder(HexItemModels.getPath((Block)HexBlocks.SLATE_PILLAR))).parent((ModelFile)new ModelFile.UncheckedModelFile(this.modLoc("block/slate_pillar")));
        ((ItemModelBuilder)this.getBuilder(HexItemModels.getPath((Block)HexBlocks.AMETHYST_PILLAR))).parent((ModelFile)new ModelFile.UncheckedModelFile(this.modLoc("block/deco/amethyst_pillar")));
        ((ItemModelBuilder)this.getBuilder(HexItemModels.getPath((Block)HexBlocks.SLATE_AMETHYST_PILLAR))).parent((ModelFile)new ModelFile.UncheckedModelFile(this.modLoc("block/slate_amethyst_pillar")));
        ((ItemModelBuilder)this.getBuilder(HexItemModels.getPath(HexBlocks.AKASHIC_RECORD))).parent((ModelFile)new ModelFile.UncheckedModelFile(this.modLoc("block/akashic_record")));
        this.simpleItem(this.modLoc("edified_door"));
        ((ItemModelBuilder)this.getBuilder(HexItemModels.getPath((Block)HexBlocks.EDIFIED_TRAPDOOR))).parent((ModelFile)new ModelFile.UncheckedModelFile(this.modLoc("block/edified_trapdoor_bottom")));
        ((ItemModelBuilder)this.getBuilder(HexItemModels.getPath((Block)HexBlocks.EDIFIED_LOG))).parent((ModelFile)new ModelFile.UncheckedModelFile(this.modLoc("block/edified_log")));
        ((ItemModelBuilder)this.getBuilder(HexItemModels.getPath((Block)HexBlocks.EDIFIED_LOG_AMETHYST))).parent((ModelFile)new ModelFile.UncheckedModelFile(this.modLoc("block/edified_log_amethyst")));
        ((ItemModelBuilder)this.getBuilder(HexItemModels.getPath((Block)HexBlocks.EDIFIED_LOG_AVENTURINE))).parent((ModelFile)new ModelFile.UncheckedModelFile(this.modLoc("block/edified_log_aventurine")));
        ((ItemModelBuilder)this.getBuilder(HexItemModels.getPath((Block)HexBlocks.EDIFIED_LOG_CITRINE))).parent((ModelFile)new ModelFile.UncheckedModelFile(this.modLoc("block/edified_log_citrine")));
        ((ItemModelBuilder)this.getBuilder(HexItemModels.getPath((Block)HexBlocks.EDIFIED_LOG_PURPLE))).parent((ModelFile)new ModelFile.UncheckedModelFile(this.modLoc("block/edified_log_purple")));
        ((ItemModelBuilder)this.getBuilder(HexItemModels.getPath((Block)HexBlocks.STRIPPED_EDIFIED_LOG))).parent((ModelFile)new ModelFile.UncheckedModelFile(this.modLoc("block/stripped_edified_log")));
        ((ItemModelBuilder)this.getBuilder(HexItemModels.getPath((Block)HexBlocks.EDIFIED_WOOD))).parent((ModelFile)new ModelFile.UncheckedModelFile(this.modLoc("block/edified_wood")));
        ((ItemModelBuilder)this.getBuilder(HexItemModels.getPath((Block)HexBlocks.STRIPPED_EDIFIED_WOOD))).parent((ModelFile)new ModelFile.UncheckedModelFile(this.modLoc("block/stripped_edified_wood")));
        ((ItemModelBuilder)this.getBuilder(HexItemModels.getPath((Block)HexBlocks.EDIFIED_STAIRS))).parent((ModelFile)new ModelFile.UncheckedModelFile(this.modLoc("block/edified_stairs")));
        ((ItemModelBuilder)this.getBuilder(HexItemModels.getPath((Block)HexBlocks.EDIFIED_FENCE))).parent((ModelFile)new ModelFile.UncheckedModelFile(this.modLoc("block/edified_fence_inventory")));
        ((ItemModelBuilder)this.getBuilder(HexItemModels.getPath((Block)HexBlocks.EDIFIED_FENCE_GATE))).parent((ModelFile)new ModelFile.UncheckedModelFile(this.modLoc("block/edified_fence_gate")));
        ((ItemModelBuilder)this.getBuilder(HexItemModels.getPath((Block)HexBlocks.EDIFIED_SLAB))).parent((ModelFile)new ModelFile.UncheckedModelFile(this.modLoc("block/edified_slab")));
        ((ItemModelBuilder)((ItemModelBuilder)this.getBuilder(HexItemModels.getPath((Block)HexBlocks.EDIFIED_BUTTON))).parent((ModelFile)new ModelFile.UncheckedModelFile(new ResourceLocation("block/button_inventory")))).texture("texture", this.modLoc("block/edified_planks"));
        ((ItemModelBuilder)this.getBuilder(HexItemModels.getPath((Block)HexBlocks.EDIFIED_PRESSURE_PLATE))).parent((ModelFile)new ModelFile.UncheckedModelFile(this.modLoc("block/edified_pressure_plate")));
    }

    private void buildThoughtKnot() {
        ItemModelBuilder unwritten = (ItemModelBuilder)this.singleTexture("thought_knot", new ResourceLocation("item/generated"), "layer0", this.modLoc("item/thought_knot"));
        ItemModelBuilder written = (ItemModelBuilder)((ItemModelBuilder)((ItemModelBuilder)this.withExistingParent("thought_knot_written", new ResourceLocation("item/generated"))).texture("layer0", this.modLoc("item/thought_knot"))).texture("layer1", this.modLoc("item/thought_knot_overlay"));
        ((ItemModelBuilder)this.getBuilder("thought_knot")).override().predicate(ItemThoughtKnot.WRITTEN_PRED, 0.0f).model((ModelFile)unwritten).end().override().predicate(ItemThoughtKnot.WRITTEN_PRED, 1.0f).model((ModelFile)written).end();
    }

    private void buildSealableIotaHolder(Item item, String stub, int numVariants) {
        String name = HexItemModels.getPath(item);
        ItemModelBuilder builder = (ItemModelBuilder)this.getBuilder(name);
        for (int i = 0; i < numVariants; ++i) {
            ItemModelBuilder plain = i == 0 ? (ItemModelBuilder)this.singleTexture(name, new ResourceLocation("item/generated"), "layer0", this.modLoc("item/cad/" + i + "_" + stub + "_empty")) : (ItemModelBuilder)((ItemModelBuilder)this.withExistingParent(name + "_" + i, new ResourceLocation("item/generated"))).texture("layer0", this.modLoc("item/cad/" + i + "_" + stub + "_empty"));
            ItemModelBuilder unsealed = (ItemModelBuilder)((ItemModelBuilder)((ItemModelBuilder)this.withExistingParent(name + "_" + i + "_filled", new ResourceLocation("item/generated"))).texture("layer0", this.modLoc("item/cad/" + i + "_" + stub + "_filled"))).texture("layer1", this.modLoc("item/cad/" + i + "_" + stub + "_filled_overlay"));
            ItemModelBuilder sealed = (ItemModelBuilder)((ItemModelBuilder)((ItemModelBuilder)this.withExistingParent(name + "_" + i + "_sealed", new ResourceLocation("item/generated"))).texture("layer0", this.modLoc("item/cad/" + i + "_" + stub + "_sealed"))).texture("layer1", this.modLoc("item/cad/" + i + "_" + stub + "_sealed_overlay"));
            builder.override().predicate(ItemFocus.VARIANT_PRED, (float)i).predicate(ItemFocus.OVERLAY_PRED, 0.0f).model((ModelFile)plain).end().override().predicate(ItemFocus.VARIANT_PRED, (float)i).predicate(ItemFocus.OVERLAY_PRED, 1.0f).model((ModelFile)unsealed).end().override().predicate(ItemFocus.VARIANT_PRED, (float)i).predicate(ItemFocus.OVERLAY_PRED, 2.0f).model((ModelFile)sealed).end();
        }
    }

    private void buildScroll(Item item, String size) {
        ((ItemModelBuilder)this.getBuilder(HexItemModels.getPath(item))).override().predicate(ItemScroll.ANCIENT_PREDICATE, 0.0f).model((ModelFile)new ModelFile.UncheckedModelFile(this.modLoc("item/scroll_pristine_" + size))).end().override().predicate(ItemScroll.ANCIENT_PREDICATE, 1.0f).model((ModelFile)new ModelFile.UncheckedModelFile(this.modLoc("item/scroll_ancient_" + size))).end();
    }

    private void buildStaff(Item item, String name) {
        this.singleTexture("item/" + HexItemModels.getPath(item), new ResourceLocation("item/handheld_rod"), "layer0", this.modLoc("item/staff/" + name));
        ((ItemModelBuilder)this.getBuilder(HexItemModels.getPath(item))).override().predicate(ItemStaff.FUNNY_LEVEL_PREDICATE, 0.0f).model((ModelFile)new ModelFile.UncheckedModelFile(this.modLoc("item/" + name + "_staff"))).end().override().predicate(ItemStaff.FUNNY_LEVEL_PREDICATE, 1.0f).model((ModelFile)new ModelFile.UncheckedModelFile(this.modLoc("item/old_staff"))).predicate(ItemStaff.FUNNY_LEVEL_PREDICATE, 2.0f).model((ModelFile)new ModelFile.UncheckedModelFile(this.modLoc("item/cherry_staff"))).end();
    }

    private void buildPackagedSpell(Item item, String stub, int numVariants) {
        String name = HexItemModels.getPath(item);
        ItemModelBuilder builder = (ItemModelBuilder)this.getBuilder(name);
        for (int i = 0; i < numVariants; ++i) {
            String parent_tag = Arrays.asList(PACKAGED_SPELL_HANDHELD_VARIANTS).contains(i) ? "item/handheld_rod" : "item/generated";
            ItemModelBuilder plain = i == 0 ? (ItemModelBuilder)this.singleTexture(name, new ResourceLocation(parent_tag), "layer0", this.modLoc("item/cad/" + i + "_" + stub)) : (ItemModelBuilder)((ItemModelBuilder)this.withExistingParent(name + "_" + i, new ResourceLocation(parent_tag))).texture("layer0", this.modLoc("item/cad/" + i + "_" + stub));
            ItemModelBuilder filled = (ItemModelBuilder)((ItemModelBuilder)((ItemModelBuilder)this.withExistingParent(name + "_" + i + "_filled", new ResourceLocation(parent_tag))).texture("layer0", this.modLoc("item/cad/" + i + "_" + stub))).texture("layer1", this.modLoc("item/cad/" + i + "_" + stub + "_overlay"));
            builder.override().predicate(ItemFocus.VARIANT_PRED, (float)i).predicate(ItemPackagedHex.HAS_PATTERNS_PRED, -0.01f).model((ModelFile)plain).end().override().predicate(ItemFocus.VARIANT_PRED, (float)i).predicate(ItemPackagedHex.HAS_PATTERNS_PRED, 0.99f).model((ModelFile)filled).end();
        }
    }

    private void buildFourVariantGaslight(String name, String path, BiFunction<String, ResourceLocation, ModelFile> makeModel) {
        ItemModelBuilder builder = (ItemModelBuilder)this.getBuilder(name);
        for (int i = 0; i < 4; ++i) {
            ResourceLocation textureLoc = this.modLoc(path + "_" + i);
            ModelFile model = makeModel.apply(name, textureLoc);
            builder.override().predicate(GaslightingTracker.GASLIGHTING_PRED, (float)i).model(model).end();
        }
    }
}

