/*
 * Decompiled with CFR 0.152.
 */
package at.petrak.hexcasting.common.items.magic;

import at.petrak.hexcasting.api.casting.iota.IotaType;
import at.petrak.hexcasting.api.utils.NBTHelper;
import at.petrak.hexcasting.common.items.magic.ItemCypher;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public class ItemAncientCypher
extends ItemCypher {
    public static final String TAG_PATTERNS = "patterns";
    public static final String TAG_HEX_NAME = "hex_name";

    public ItemAncientCypher(Item.Properties pProperties) {
        super(pProperties);
    }

    @Override
    public void clearHex(ItemStack stack) {
        super.clearHex(stack);
        NBTHelper.remove(stack, TAG_HEX_NAME);
    }

    public Component m_7626_(ItemStack pStack) {
        String descID = this.m_5671_(pStack);
        String hexName = NBTHelper.getString(pStack, TAG_HEX_NAME);
        if (hexName != null) {
            return Component.m_237110_((String)(descID + ".preset"), (Object[])new Object[]{Component.m_237115_((String)hexName)});
        }
        return Component.m_237115_((String)descID);
    }

    @Override
    public void m_7373_(ItemStack pStack, @Nullable Level pLevel, List<Component> pTooltipComponents, TooltipFlag pIsAdvanced) {
        super.m_7373_(pStack, pLevel, pTooltipComponents, pIsAdvanced);
        ListTag patternsTag = NBTHelper.getList(pStack, TAG_PATTERNS, 10);
        if (patternsTag != null) {
            MutableComponent storedHex = Component.m_237115_((String)"hexcasting.tooltip.stored_hex");
            for (Tag iotaTag : patternsTag) {
                CompoundTag iotaTagC = NBTHelper.getAsCompound(iotaTag);
                MutableComponent iotaComponent = IotaType.getDisplay(iotaTagC).m_6881_();
                storedHex.m_7220_((Component)iotaComponent.m_130940_(ChatFormatting.DARK_PURPLE));
            }
            pTooltipComponents.add((Component)storedHex);
        }
    }
}

