/*
 * Decompiled with CFR 0.152.
 */
package at.petrak.hexcasting.common.casting.arithmetic;

import at.petrak.hexcasting.api.casting.arithmetic.Arithmetic;
import at.petrak.hexcasting.api.casting.arithmetic.engine.InvalidOperatorException;
import at.petrak.hexcasting.api.casting.arithmetic.operator.Operator;
import at.petrak.hexcasting.api.casting.arithmetic.operator.OperatorUnary;
import at.petrak.hexcasting.api.casting.arithmetic.predicates.IotaMultiPredicate;
import at.petrak.hexcasting.api.casting.arithmetic.predicates.IotaPredicate;
import at.petrak.hexcasting.api.casting.iota.DoubleIota;
import at.petrak.hexcasting.api.casting.iota.Vec3Iota;
import at.petrak.hexcasting.api.casting.math.HexPattern;
import at.petrak.hexcasting.common.casting.arithmetic.operator.vec.OperatorPack;
import at.petrak.hexcasting.common.casting.arithmetic.operator.vec.OperatorUnpack;
import at.petrak.hexcasting.common.casting.arithmetic.operator.vec.OperatorVec3Delegating;
import at.petrak.hexcasting.common.lib.hex.HexIotaTypes;
import java.util.List;
import java.util.function.BiFunction;
import java.util.function.Function;
import net.minecraft.world.phys.Vec3;

public enum Vec3Arithmetic implements Arithmetic
{
    INSTANCE;

    public static final List<HexPattern> OPS;
    public static final IotaMultiPredicate ACCEPTS;

    @Override
    public String arithName() {
        return "vec3_math";
    }

    @Override
    public Iterable<HexPattern> opTypes() {
        return OPS;
    }

    @Override
    public Operator getOperator(HexPattern pattern) {
        if (pattern.equals(PACK)) {
            return OperatorPack.INSTANCE;
        }
        if (pattern.equals(UNPACK)) {
            return OperatorUnpack.INSTANCE;
        }
        if (pattern.equals(ADD)) {
            return Vec3Arithmetic.make2Fallback(pattern);
        }
        if (pattern.equals(SUB)) {
            return Vec3Arithmetic.make2Fallback(pattern);
        }
        if (pattern.equals(MUL)) {
            return Vec3Arithmetic.make2Double(pattern, Vec3::m_82526_);
        }
        if (pattern.equals(DIV)) {
            return Vec3Arithmetic.make2Vec(pattern, Vec3::m_82537_);
        }
        if (pattern.equals(ABS)) {
            return Vec3Arithmetic.make1Double(Vec3::m_82553_);
        }
        if (pattern.equals(POW)) {
            return Vec3Arithmetic.make2Vec(pattern, (u, v) -> v.m_82541_().m_82490_(u.m_82526_(v.m_82541_())));
        }
        if (pattern.equals(FLOOR)) {
            return Vec3Arithmetic.make1(v -> new Vec3(Math.floor(v.f_82479_), Math.floor(v.f_82480_), Math.floor(v.f_82481_)));
        }
        if (pattern.equals(CEIL)) {
            return Vec3Arithmetic.make1(v -> new Vec3(Math.ceil(v.f_82479_), Math.ceil(v.f_82480_), Math.ceil(v.f_82481_)));
        }
        if (pattern.equals(MOD)) {
            return Vec3Arithmetic.make2Fallback(pattern);
        }
        throw new InvalidOperatorException(pattern + " is not a valid operator in Arithmetic " + this + ".");
    }

    public static OperatorUnary make1(Function<Vec3, Vec3> op) {
        return new OperatorUnary(ACCEPTS, i -> new Vec3Iota((Vec3)op.apply(Operator.downcast(i, HexIotaTypes.VEC3).getVec3())));
    }

    public static OperatorUnary make1Double(Function<Vec3, Double> op) {
        return new OperatorUnary(ACCEPTS, i -> new DoubleIota((Double)op.apply(Operator.downcast(i, HexIotaTypes.VEC3).getVec3())));
    }

    public static OperatorVec3Delegating make2Fallback(HexPattern pattern) {
        return new OperatorVec3Delegating(null, pattern);
    }

    public static OperatorVec3Delegating make2Double(HexPattern pattern, BiFunction<Vec3, Vec3, Double> op) {
        return new OperatorVec3Delegating(op.andThen(DoubleIota::new), pattern);
    }

    public static OperatorVec3Delegating make2Vec(HexPattern pattern, BiFunction<Vec3, Vec3, Vec3> op) {
        return new OperatorVec3Delegating(op.andThen(Vec3Iota::new), pattern);
    }

    static {
        OPS = List.of(PACK, UNPACK, ADD, SUB, MUL, DIV, ABS, POW, FLOOR, CEIL, MOD);
        ACCEPTS = IotaMultiPredicate.any(IotaPredicate.ofType(HexIotaTypes.VEC3), IotaPredicate.ofType(HexIotaTypes.DOUBLE));
    }
}

