/*
 * Decompiled with CFR 0.152.
 */
package at.petrak.hexcasting.common.casting.actions.akashic;

import at.petrak.hexcasting.api.casting.OperatorUtils;
import at.petrak.hexcasting.api.casting.RenderedSpell;
import at.petrak.hexcasting.api.casting.castables.SpellAction;
import at.petrak.hexcasting.api.casting.eval.CastingEnvironment;
import at.petrak.hexcasting.api.casting.eval.OperationResult;
import at.petrak.hexcasting.api.casting.eval.vm.CastingImage;
import at.petrak.hexcasting.api.casting.eval.vm.SpellContinuation;
import at.petrak.hexcasting.api.casting.iota.Iota;
import at.petrak.hexcasting.api.casting.math.HexPattern;
import at.petrak.hexcasting.api.casting.mishaps.Mishap;
import at.petrak.hexcasting.api.casting.mishaps.MishapNoAkashicRecord;
import at.petrak.hexcasting.api.casting.mishaps.MishapOthersName;
import at.petrak.hexcasting.common.blocks.akashic.BlockAkashicRecord;
import at.petrak.hexcasting.common.lib.HexSounds;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001\u000eB\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\u0007\u001a\u00020\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\u0006\u0010\f\u001a\u00020\rH\u0016R\u0014\u0010\u0003\u001a\u00020\u0004X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u000f"}, d2={"Lat/petrak/hexcasting/common/casting/actions/akashic/OpAkashicWrite;", "Lat/petrak/hexcasting/api/casting/castables/SpellAction;", "()V", "argc", "", "getArgc", "()I", "execute", "Lat/petrak/hexcasting/api/casting/castables/SpellAction$Result;", "args", "", "Lat/petrak/hexcasting/api/casting/iota/Iota;", "env", "Lat/petrak/hexcasting/api/casting/eval/CastingEnvironment;", "Spell", "hexcasting-forge-1.20.1"})
public final class OpAkashicWrite
implements SpellAction {
    @NotNull
    public static final OpAkashicWrite INSTANCE = new OpAkashicWrite();
    private static final int argc = 3;

    private OpAkashicWrite() {
    }

    @Override
    public int getArgc() {
        return argc;
    }

    @Override
    @NotNull
    public SpellAction.Result execute(@NotNull List<? extends Iota> args, @NotNull CastingEnvironment env) {
        Intrinsics.checkNotNullParameter(args, (String)"args");
        Intrinsics.checkNotNullParameter((Object)env, (String)"env");
        BlockPos pos = OperatorUtils.getBlockPos(args, 0, this.getArgc());
        HexPattern key = OperatorUtils.getPattern(args, 1, this.getArgc());
        Iota datum = args.get(2);
        env.assertPosInRange(pos);
        Block record = env.getWorld().m_8055_(pos).m_60734_();
        if (!(record instanceof BlockAkashicRecord)) {
            throw new MishapNoAkashicRecord(pos);
        }
        LivingEntity livingEntity = env.getCastingEntity();
        Player trueName = MishapOthersName.Companion.getTrueNameFromDatum(datum, (Player)(livingEntity instanceof ServerPlayer ? (ServerPlayer)livingEntity : null));
        if (trueName != null) {
            throw new MishapOthersName(trueName);
        }
        return new SpellAction.Result(new Spell((BlockAkashicRecord)record, pos, key, datum), 10000L, CollectionsKt.emptyList(), 0L, 8, null);
    }

    @Override
    public boolean hasCastingSound(@NotNull CastingEnvironment ctx) {
        return SpellAction.DefaultImpls.hasCastingSound(this, ctx);
    }

    @Override
    public boolean awardsCastingStat(@NotNull CastingEnvironment ctx) {
        return SpellAction.DefaultImpls.awardsCastingStat(this, ctx);
    }

    @Override
    @NotNull
    public SpellAction.Result executeWithUserdata(@NotNull List<? extends Iota> args, @NotNull CastingEnvironment env, @NotNull CompoundTag userData) throws Mishap {
        return SpellAction.DefaultImpls.executeWithUserdata(this, args, env, userData);
    }

    @Override
    @NotNull
    public OperationResult operate(@NotNull CastingEnvironment env, @NotNull CastingImage image, @NotNull SpellContinuation continuation) {
        return SpellAction.DefaultImpls.operate(this, env, image, continuation);
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\t\u0010\u0017\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0018\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0019\u001a\u00020\u0007H\u00c6\u0003J\t\u0010\u001a\u001a\u00020\tH\u00c6\u0003J1\u0010\u001b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00072\b\b\u0002\u0010\b\u001a\u00020\tH\u00c6\u0001J\u0013\u0010\u001c\u001a\u00020\u001d2\b\u0010\u001e\u001a\u0004\u0018\u00010\u001fH\u00d6\u0003J\t\u0010 \u001a\u00020!H\u00d6\u0001J\t\u0010\"\u001a\u00020#H\u00d6\u0001R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006$"}, d2={"Lat/petrak/hexcasting/common/casting/actions/akashic/OpAkashicWrite$Spell;", "Lat/petrak/hexcasting/api/casting/RenderedSpell;", "record", "Lat/petrak/hexcasting/common/blocks/akashic/BlockAkashicRecord;", "recordPos", "Lnet/minecraft/core/BlockPos;", "key", "Lat/petrak/hexcasting/api/casting/math/HexPattern;", "datum", "Lat/petrak/hexcasting/api/casting/iota/Iota;", "(Lat/petrak/hexcasting/common/blocks/akashic/BlockAkashicRecord;Lnet/minecraft/core/BlockPos;Lat/petrak/hexcasting/api/casting/math/HexPattern;Lat/petrak/hexcasting/api/casting/iota/Iota;)V", "getDatum", "()Lat/petrak/hexcasting/api/casting/iota/Iota;", "getKey", "()Lat/petrak/hexcasting/api/casting/math/HexPattern;", "getRecord", "()Lat/petrak/hexcasting/common/blocks/akashic/BlockAkashicRecord;", "getRecordPos", "()Lnet/minecraft/core/BlockPos;", "cast", "", "env", "Lat/petrak/hexcasting/api/casting/eval/CastingEnvironment;", "component1", "component2", "component3", "component4", "copy", "equals", "", "other", "", "hashCode", "", "toString", "", "hexcasting-forge-1.20.1"})
    private static final class Spell
    implements RenderedSpell {
        @NotNull
        private final BlockAkashicRecord record;
        @NotNull
        private final BlockPos recordPos;
        @NotNull
        private final HexPattern key;
        @NotNull
        private final Iota datum;

        public Spell(@NotNull BlockAkashicRecord record, @NotNull BlockPos recordPos, @NotNull HexPattern key, @NotNull Iota datum) {
            Intrinsics.checkNotNullParameter((Object)((Object)record), (String)"record");
            Intrinsics.checkNotNullParameter((Object)recordPos, (String)"recordPos");
            Intrinsics.checkNotNullParameter((Object)key, (String)"key");
            Intrinsics.checkNotNullParameter((Object)datum, (String)"datum");
            this.record = record;
            this.recordPos = recordPos;
            this.key = key;
            this.datum = datum;
        }

        @NotNull
        public final BlockAkashicRecord getRecord() {
            return this.record;
        }

        @NotNull
        public final BlockPos getRecordPos() {
            return this.recordPos;
        }

        @NotNull
        public final HexPattern getKey() {
            return this.key;
        }

        @NotNull
        public final Iota getDatum() {
            return this.datum;
        }

        @Override
        public void cast(@NotNull CastingEnvironment env) {
            Intrinsics.checkNotNullParameter((Object)env, (String)"env");
            this.record.addNewDatum(this.recordPos, (Level)env.getWorld(), this.key, this.datum);
            env.getWorld().m_5594_(null, this.recordPos, HexSounds.SCROLL_SCRIBBLE, SoundSource.BLOCKS, 1.0f, 0.8f);
        }

        @Override
        @Nullable
        public CastingImage cast(@NotNull CastingEnvironment env, @NotNull CastingImage image) {
            return RenderedSpell.DefaultImpls.cast(this, env, image);
        }

        @NotNull
        public final BlockAkashicRecord component1() {
            return this.record;
        }

        @NotNull
        public final BlockPos component2() {
            return this.recordPos;
        }

        @NotNull
        public final HexPattern component3() {
            return this.key;
        }

        @NotNull
        public final Iota component4() {
            return this.datum;
        }

        @NotNull
        public final Spell copy(@NotNull BlockAkashicRecord record, @NotNull BlockPos recordPos, @NotNull HexPattern key, @NotNull Iota datum) {
            Intrinsics.checkNotNullParameter((Object)((Object)record), (String)"record");
            Intrinsics.checkNotNullParameter((Object)recordPos, (String)"recordPos");
            Intrinsics.checkNotNullParameter((Object)key, (String)"key");
            Intrinsics.checkNotNullParameter((Object)datum, (String)"datum");
            return new Spell(record, recordPos, key, datum);
        }

        public static /* synthetic */ Spell copy$default(Spell spell, BlockAkashicRecord blockAkashicRecord, BlockPos blockPos, HexPattern hexPattern, Iota iota, int n, Object object) {
            if ((n & 1) != 0) {
                blockAkashicRecord = spell.record;
            }
            if ((n & 2) != 0) {
                blockPos = spell.recordPos;
            }
            if ((n & 4) != 0) {
                hexPattern = spell.key;
            }
            if ((n & 8) != 0) {
                iota = spell.datum;
            }
            return spell.copy(blockAkashicRecord, blockPos, hexPattern, iota);
        }

        @NotNull
        public String toString() {
            return "Spell(record=" + this.record + ", recordPos=" + this.recordPos + ", key=" + this.key + ", datum=" + this.datum + ")";
        }

        public int hashCode() {
            int result = this.record.hashCode();
            result = result * 31 + this.recordPos.hashCode();
            result = result * 31 + this.key.hashCode();
            result = result * 31 + this.datum.hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Spell)) {
                return false;
            }
            Spell spell = (Spell)other;
            if (!Intrinsics.areEqual((Object)((Object)this.record), (Object)((Object)spell.record))) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.recordPos, (Object)spell.recordPos)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.key, (Object)spell.key)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.datum, (Object)spell.datum);
        }
    }
}

