/*
 * Decompiled with CFR 0.152.
 */
package at.petrak.hexcasting.client.render;

import at.petrak.hexcasting.client.render.HexPatternLike;

public class PatternSettings {
    private final String name;
    public final PositionSettings posSets;
    public final StrokeSettings strokeSets;
    public final ZappySettings zapSets;

    public PatternSettings(String name, PositionSettings posSets, StrokeSettings strokeSets, ZappySettings zapSets) {
        this.name = name;
        this.posSets = posSets;
        this.strokeSets = strokeSets;
        this.zapSets = zapSets;
    }

    public String getCacheKey(HexPatternLike patternlike, double seed) {
        return (patternlike.getName() + "-" + this.getName() + "-" + seed).toLowerCase();
    }

    public String getName() {
        return this.name;
    }

    public double getTargetWidth() {
        return this.posSets.spaceWidth;
    }

    public double getTargetHeight() {
        return this.posSets.spaceHeight;
    }

    public double getHorPadding() {
        return this.posSets.hPadding;
    }

    public double getVertPadding() {
        return this.posSets.vPadding;
    }

    public AxisAlignment getHorAlignment() {
        return this.posSets.hAxis;
    }

    public AxisAlignment getVertAlignment() {
        return this.posSets.vAxis;
    }

    public double getBaseScale() {
        return this.posSets.baseScale;
    }

    public double getMinWidth() {
        return this.posSets.minWidth;
    }

    public double getMinHeight() {
        return this.posSets.minHeight;
    }

    public double getInnerWidth(double scale) {
        return this.strokeSets.innerWidth;
    }

    public double getOuterWidth(double scale) {
        return this.strokeSets.outerWidth;
    }

    public double getStartDotRadius(double scale) {
        return this.strokeSets.startDotRadius;
    }

    public double getGridDotsRadius(double scale) {
        return this.strokeSets.gridDotsRadius;
    }

    public double getStrokeWidth(double scale) {
        return Math.max(this.getOuterWidth(scale), this.getInnerWidth(scale));
    }

    public double getStrokeWidthGuess() {
        return Math.max(this.strokeSets.outerWidth, this.strokeSets.innerWidth);
    }

    public int getHops() {
        return this.zapSets.hops;
    }

    public float getVariance() {
        return this.zapSets.variance;
    }

    public float getFlowIrregular() {
        return this.zapSets.flowIrregular;
    }

    public float getReadabilityOffset() {
        return this.zapSets.readabilityOffset;
    }

    public float getLastSegmentProp() {
        return this.zapSets.lastSegmentLenProportion;
    }

    public float getSpeed() {
        return this.zapSets.speed;
    }

    public record PositionSettings(double spaceWidth, double spaceHeight, double hPadding, double vPadding, AxisAlignment hAxis, AxisAlignment vAxis, double baseScale, double minWidth, double minHeight) {
        public static PositionSettings paddedSquare(double padding) {
            return PositionSettings.paddedSquare(padding, 0.25, 0.0);
        }

        public static PositionSettings paddedSquare(double padding, double baseScale, double minSize) {
            return new PositionSettings(1.0, 1.0, padding, padding, AxisAlignment.CENTER_FIT, AxisAlignment.CENTER_FIT, baseScale, minSize, minSize);
        }
    }

    public record StrokeSettings(double innerWidth, double outerWidth, double startDotRadius, double gridDotsRadius) {
        public static StrokeSettings fromStroke(double stroke) {
            return new StrokeSettings(stroke * 2.0 / 5.0, stroke, 0.8 * stroke * 2.0 / 5.0, 0.4 * stroke * 2.0 / 5.0);
        }
    }

    public record ZappySettings(int hops, float variance, float speed, float flowIrregular, float readabilityOffset, float lastSegmentLenProportion) {
        public static float READABLE_OFFSET = 0.2f;
        public static float READABLE_SEGMENT = 0.8f;
        public static ZappySettings STATIC = new ZappySettings(10, 0.5f, 0.0f, 0.2f, 0.0f, 1.0f);
        public static ZappySettings READABLE = new ZappySettings(10, 0.5f, 0.0f, 0.2f, READABLE_OFFSET, READABLE_SEGMENT);
        public static ZappySettings WOBBLY = new ZappySettings(10, 2.5f, 0.1f, 0.2f, 0.0f, 1.0f);
    }

    public static enum AxisAlignment {
        BEGIN_FIT(true, 0),
        CENTER_FIT(true, 1),
        END_FIT(true, 2),
        BEGIN(false, 0),
        CENTER(false, 1),
        END(false, 2);

        public final boolean fit;
        public final int amtInFront;

        private AxisAlignment(boolean fit, int amtInFront) {
            this.fit = fit;
            this.amtInFront = amtInFront;
        }
    }
}

