/*
 * Decompiled with CFR 0.152.
 */
package com.unascribed.ears.api.registry;

import com.unascribed.ears.Identified;
import com.unascribed.ears.api.Cork;
import com.unascribed.ears.api.EarsFeatureType;
import com.unascribed.ears.api.iface.EarsInhibitor;
import java.util.ArrayList;
import java.util.List;

public final class EarsInhibitorRegistry {
    private static final List<Identified<EarsInhibitor>> inhibitors = new ArrayList<Identified<EarsInhibitor>>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Cork register(String namespace, EarsInhibitor inhibitor) {
        List<Identified<EarsInhibitor>> list = inhibitors;
        synchronized (list) {
            final Identified<EarsInhibitor> iei = Identified.of(namespace, inhibitor);
            inhibitors.add(iei);
            return new Cork(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void cork() {
                    List list = inhibitors;
                    synchronized (list) {
                        inhibitors.remove(iei);
                    }
                }
            };
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String isInhibited(EarsFeatureType feature, Object peer) {
        List<Identified<EarsInhibitor>> list = inhibitors;
        synchronized (list) {
            for (Identified<EarsInhibitor> iei : inhibitors) {
                try {
                    if (!iei.getValue().shouldInhibit(feature, peer)) continue;
                    return iei.getNamespace();
                }
                catch (Throwable t) {
                    t.printStackTrace();
                    System.err.println("[Ears] An inhibitor registered by " + iei.getNamespace() + " threw an exception while checking if " + (Object)((Object)feature) + " should be inhibited for " + peer);
                }
            }
        }
        return null;
    }

    private EarsInhibitorRegistry() {
    }
}

