/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.improvedmobs.utils;

import com.mojang.serialization.DynamicOps;
import io.github.flemmli97.improvedmobs.ImprovedMobs;
import io.github.flemmli97.improvedmobs.config.Config;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.longs.LongArraySet;
import it.unimi.dsi.fastutil.longs.LongSet;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.DustParticleOptions;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.saveddata.SavedData;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.Nullable;

public class BlockRestorationData
extends SavedData {
    private static final String ID = "ImprovedMobsRestoration";
    private final Long2ObjectMap<Long2ObjectMap<SavedBlock>> toRestore = new Long2ObjectOpenHashMap();

    public BlockRestorationData() {
    }

    private BlockRestorationData(CompoundTag tag) {
        this.load(tag);
    }

    public static BlockRestorationData get(ServerLevel level) {
        return (BlockRestorationData)level.m_8895_().m_164861_(BlockRestorationData::new, BlockRestorationData::new, ID);
    }

    public void restore(ServerLevel level, BlockState state, BlockPos pos, @Nullable Entity entity) {
        Long2ObjectMap chunk = (Long2ObjectMap)this.toRestore.computeIfAbsent(ChunkPos.m_151388_((BlockPos)pos), o -> new Long2ObjectOpenHashMap());
        SavedBlock current = (SavedBlock)chunk.get(pos.m_121878_());
        if (current != null) {
            current.toDrop.forEach(stack -> Block.m_49840_((Level)level, (BlockPos)pos, (ItemStack)stack));
        }
        BlockEntity blockEntity = state.m_155947_() ? level.m_7702_(pos) : null;
        List drops = Block.m_49874_((BlockState)state, (ServerLevel)level, (BlockPos)pos, (BlockEntity)blockEntity, (Entity)entity, (ItemStack)ItemStack.f_41583_);
        chunk.put(pos.m_121878_(), (Object)new SavedBlock(state, level.m_46467_(), drops));
        this.m_77762_();
    }

    public void tick(ServerLevel level) {
        LongArraySet toRemove = new LongArraySet();
        long time = level.m_46467_();
        boolean particle = time % 5L == 0L;
        this.toRestore.forEach((arg_0, arg_1) -> this.lambda$tick$4(level, time, particle, (LongSet)toRemove, arg_0, arg_1));
        toRemove.forEach(arg_0 -> this.toRestore.remove(arg_0));
    }

    public void load(CompoundTag data) {
        data.m_128431_().forEach(chunk -> {
            Long2ObjectOpenHashMap blocksMap = new Long2ObjectOpenHashMap();
            ListTag blocks = data.m_128437_(chunk, 10);
            blocks.forEach(arg_0 -> BlockRestorationData.lambda$load$6((Long2ObjectMap)blocksMap, arg_0));
            this.toRestore.put(Long.parseLong(chunk), (Object)blocksMap);
        });
    }

    public CompoundTag m_7176_(CompoundTag data) {
        this.toRestore.forEach((chunk, blocks) -> {
            ListTag list = new ListTag();
            blocks.forEach((pos, d) -> {
                CompoundTag blockSave = new CompoundTag();
                blockSave.m_128356_("Pos", pos.longValue());
                blockSave.m_128365_("State", (Tag)BlockState.f_61039_.encodeStart((DynamicOps)NbtOps.f_128958_, (Object)d.state).getOrThrow(false, arg_0 -> ((Logger)ImprovedMobs.logger).error(arg_0)));
                blockSave.m_128356_("Time", d.time);
                ListTag stacks = new ListTag();
                d.toDrop.forEach(s -> stacks.add((Object)((Tag)ItemStack.f_41582_.encodeStart((DynamicOps)NbtOps.f_128958_, s).getOrThrow(false, arg_0 -> ((Logger)ImprovedMobs.logger).error(arg_0)))));
                blockSave.m_128365_("Drops", (Tag)stacks);
                list.add((Object)blockSave);
            });
            data.m_128365_(String.valueOf(chunk), (Tag)list);
        });
        return data;
    }

    private static /* synthetic */ void lambda$load$6(Long2ObjectMap blocksMap, Tag t) {
        CompoundTag blockSave = (CompoundTag)t;
        ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
        blockSave.m_128437_("Drops", 10).forEach(st -> stacks.add((ItemStack)ItemStack.f_41582_.parse((DynamicOps)NbtOps.f_128958_, st).getOrThrow(false, arg_0 -> ((Logger)ImprovedMobs.logger).error(arg_0))));
        blocksMap.put(blockSave.m_128454_("Pos"), (Object)new SavedBlock((BlockState)BlockState.f_61039_.parse((DynamicOps)NbtOps.f_128958_, (Object)blockSave.m_128423_("State")).getOrThrow(false, arg_0 -> ((Logger)ImprovedMobs.logger).error(arg_0)), blockSave.m_128454_("Time"), stacks));
    }

    private /* synthetic */ void lambda$tick$4(ServerLevel level, long time, boolean particle, LongSet toRemove, Long chunk, Long2ObjectMap data) {
        ChunkPos chunkPos = new ChunkPos(chunk.longValue());
        if (level.m_7232_(chunkPos.f_45578_, chunkPos.f_45579_)) {
            LongArraySet toRemoveBlocks = new LongArraySet();
            LevelChunk levelChunk = level.m_6325_(chunkPos.f_45578_, chunkPos.f_45579_);
            data.forEach((arg_0, arg_1) -> BlockRestorationData.lambda$tick$3(levelChunk, time, level, (LongSet)toRemoveBlocks, particle, arg_0, arg_1));
            toRemoveBlocks.forEach(arg_0 -> ((Long2ObjectMap)data).remove(arg_0));
            if (data.isEmpty()) {
                toRemove.add(chunk.longValue());
            }
            if (!toRemoveBlocks.isEmpty()) {
                this.m_77762_();
            }
        }
    }

    private static /* synthetic */ void lambda$tick$3(LevelChunk levelChunk, long time, ServerLevel level, LongSet toRemoveBlocks, boolean particle, Long packedPos, SavedBlock replace) {
        BlockPos pos = BlockPos.m_122022_((long)packedPos);
        BlockState current = levelChunk.m_8055_(pos);
        if (current.m_60734_() == Blocks.f_50016_) {
            if (Math.abs(time - replace.time) > (long)Config.CommonConfig.restoreDelay) {
                level.m_7731_(pos, replace.state, 3);
                toRemoveBlocks.add(packedPos.longValue());
            } else if (particle) {
                level.m_8767_((ParticleOptions)DustParticleOptions.f_123656_, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5, 0, 0.0, 0.0, 0.0, 0.0);
            }
        } else {
            replace.toDrop.forEach(stack -> Block.m_49840_((Level)level, (BlockPos)pos, (ItemStack)stack));
            toRemoveBlocks.add(packedPos.longValue());
        }
    }

    public record SavedBlock(BlockState state, long time, List<ItemStack> toDrop) {
    }
}

