/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.improvedmobs.difficulty;

import com.google.common.collect.Lists;
import io.github.flemmli97.improvedmobs.api.difficulty.DifficultyFetcher;
import io.github.flemmli97.improvedmobs.config.Config;
import io.github.flemmli97.improvedmobs.config.DifficultyConfig;
import io.github.flemmli97.improvedmobs.platform.CrossPlatformStuff;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import net.minecraft.core.Position;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.EntityGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.saveddata.SavedData;
import net.minecraft.world.phys.Vec3;
import org.apache.commons.lang3.tuple.Pair;

public class DifficultyData
extends SavedData {
    private static final String IDENTIFIER = "Difficulty";
    private float difficultyLevel;
    private long prevTime;
    private boolean paused;

    public DifficultyData() {
    }

    private DifficultyData(CompoundTag tag) {
        this.load(tag);
    }

    public static DifficultyData get(MinecraftServer server) {
        return (DifficultyData)server.m_129783_().m_8895_().m_164861_(DifficultyData::new, DifficultyData::new, IDENTIFIER);
    }

    public static float getDifficulty(Level level, LivingEntity e) {
        if (!(level instanceof ServerLevel)) {
            return 0.0f;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        return DifficultyFetcher.getDifficulty(serverLevel, e.m_20182_());
    }

    public static List<Player> playersIn(EntityGetter getter, Vec3 pos, double radius) {
        ArrayList list = Lists.newArrayList();
        for (Player player : getter.m_6907_()) {
            if (!player.m_20182_().m_82509_((Position)pos, radius)) continue;
            list.add(player);
        }
        return list;
    }

    public void increaseDifficultyBy(Function<Float, Float> increase, long time, MinecraftServer server) {
        if (!this.paused) {
            this.difficultyLevel += increase.apply(Float.valueOf(this.getDifficulty())).floatValue();
        }
        this.prevTime = time;
        server.m_6846_().m_11314_().forEach(player -> CrossPlatformStuff.INSTANCE.getPlayerDifficultyData((ServerPlayer)player).ifPresent(d -> {
            if (!d.paused()) {
                d.setDifficultyLevel(d.getDifficultyLevel() + ((Float)increase.apply(Float.valueOf(d.getDifficultyLevel()))).floatValue());
            }
        }));
        this.m_77762_();
        CrossPlatformStuff.INSTANCE.sendDifficultyData(this, server);
    }

    public void setDifficulty(float level, MinecraftServer server) {
        this.difficultyLevel = level;
        this.prevTime = server.m_129783_().m_46468_();
        CrossPlatformStuff.INSTANCE.sendDifficultyData(this, server);
        this.m_77762_();
    }

    public void addDifficulty(float level, MinecraftServer server) {
        this.difficultyLevel += level;
        CrossPlatformStuff.INSTANCE.sendDifficultyData(this, server);
        this.m_77762_();
    }

    public float getDifficulty() {
        return this.difficultyLevel;
    }

    public long getPrevTime() {
        return this.prevTime;
    }

    public static float getDifficultyFromDist(ServerLevel level, Vec3 pos) {
        float dist = Config.CommonConfig.difficultyType == Config.DifficultyType.DISTANCESPAWN ? Mth.m_14116_((float)((float)pos.m_82531_((double)level.m_220360_().m_123341_() + 0.5, pos.m_7098_(), (double)level.m_220360_().m_123343_() + 0.5))) : Mth.m_14116_((float)((float)pos.m_82531_((double)Config.CommonConfig.centerPos.getPos().m_123341_() + 0.5, pos.m_7098_(), (double)Config.CommonConfig.centerPos.getPos().m_123343_() + 0.5)));
        Pair<Float, DifficultyConfig.Zone> conf = Config.CommonConfig.increaseHandler.get(dist);
        return ((DifficultyConfig.Zone)conf.getRight()).start() + (dist - ((Float)conf.getLeft()).floatValue()) * ((DifficultyConfig.Zone)conf.getRight()).increasePerBlock();
    }

    public void setPaused(boolean paused) {
        this.paused = paused;
    }

    public void load(CompoundTag nbt) {
        this.difficultyLevel = nbt.m_128457_(IDENTIFIER);
        this.prevTime = nbt.m_128454_("Time");
        this.paused = nbt.m_128471_("Paused");
    }

    public CompoundTag m_7176_(CompoundTag compound) {
        compound.m_128350_(IDENTIFIER, this.difficultyLevel);
        compound.m_128356_("Time", this.prevTime);
        compound.m_128379_("Paused", this.paused);
        return compound;
    }
}

