/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.herbalbrews.core.compat.jei.category;

import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.satisfy.herbalbrews.core.recipe.CauldronRecipe;
import net.satisfy.herbalbrews.core.registry.ObjectRegistry;
import org.jetbrains.annotations.NotNull;

public class CauldronCategory
implements IRecipeCategory<CauldronRecipe> {
    public static final RecipeType<CauldronRecipe> CAULDRON_TYPE = RecipeType.create((String)"herbalbrews", (String)"cauldron_brewing", CauldronRecipe.class);
    private static final int BACKGROUND_WIDTH = 147;
    private static final int BACKGROUND_HEIGHT = 64;
    private static final int X_OFFSET = 26;
    private static final int Y_OFFSET = 13;
    private final IDrawable background;
    private final IDrawable icon;
    private final Component title;

    public CauldronCategory(IGuiHelper helper) {
        ResourceLocation texture = new ResourceLocation("herbalbrews", "textures/gui/cauldron.png");
        this.background = helper.createDrawable(texture, 26, 13, 147, 64);
        ItemStack cauldronStack = new ItemStack((ItemLike)ObjectRegistry.CAULDRON.get());
        this.icon = helper.createDrawableIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)cauldronStack);
        this.title = ((Block)ObjectRegistry.TEA_KETTLE.get()).m_49954_();
    }

    @NotNull
    public RecipeType<CauldronRecipe> getRecipeType() {
        return CAULDRON_TYPE;
    }

    @NotNull
    public Component getTitle() {
        return this.title;
    }

    @NotNull
    public IDrawable getBackground() {
        return this.background;
    }

    @NotNull
    public IDrawable getIcon() {
        return this.icon;
    }

    public void setRecipe(IRecipeLayoutBuilder builder, CauldronRecipe recipe, IFocusGroup focuses) {
        ItemStack potion1 = new ItemStack((ItemLike)Items.f_42589_);
        potion1.m_41784_().m_128359_("Potion", "minecraft:swiftness");
        ItemStack potion2 = new ItemStack((ItemLike)Items.f_42589_);
        potion2.m_41784_().m_128359_("Potion", "minecraft:healing");
        ItemStack potion3 = new ItemStack((ItemLike)Items.f_42589_);
        potion3.m_41784_().m_128359_("Potion", "minecraft:strength");
        builder.addSlot(RecipeIngredientRole.INPUT, 53, 9).addItemStack(potion1);
        builder.addSlot(RecipeIngredientRole.INPUT, 31, 3).addItemStack(potion2);
        builder.addSlot(RecipeIngredientRole.INPUT, 75, 3).addItemStack(potion3);
        ItemStack outputFlask = new ItemStack((ItemLike)ObjectRegistry.FLASK.get());
        outputFlask.m_41784_().m_128359_("Effect", "minecraft:regeneration");
        builder.addSlot(RecipeIngredientRole.OUTPUT, 53, 45).addItemStack(outputFlask);
        ItemStack herbalInfusion = new ItemStack((ItemLike)ObjectRegistry.HERBAL_INFUSION.get());
        builder.addSlot(RecipeIngredientRole.INPUT, 122, 29).addItemStack(herbalInfusion);
    }
}

