/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.herbalbrews.core.blocks.entity;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.satisfy.herbalbrews.core.items.DrinkBlockItem;
import net.satisfy.herbalbrews.core.registry.EntityTypeRegistry;
import org.jetbrains.annotations.NotNull;

public class JugBlockEntity
extends BlockEntity {
    private final List<ItemStack> drinks = new ArrayList<ItemStack>();

    public JugBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)EntityTypeRegistry.JUG_BLOCK_ENTITY.get(), pos, state);
    }

    public void addDrink(ItemStack drink) {
        if (this.drinks.size() < 3 && drink.m_41720_() instanceof DrinkBlockItem) {
            this.drinks.add(drink.m_41777_());
            this.m_6596_();
            if (this.f_58857_ != null) {
                this.f_58857_.m_7260_(this.f_58858_, this.m_58900_(), this.m_58900_(), 3);
            }
        }
    }

    public List<ItemStack> getDrinks() {
        return this.drinks;
    }

    public void clearDrinks() {
        this.drinks.clear();
        this.m_6596_();
        if (this.f_58857_ != null) {
            this.f_58857_.m_7260_(this.f_58858_, this.m_58900_(), this.m_58900_(), 3);
        }
    }

    protected void m_183515_(@NotNull CompoundTag tag) {
        super.m_183515_(tag);
        ListTag drinkList = new ListTag();
        for (ItemStack drink : this.drinks) {
            CompoundTag drinkTag = new CompoundTag();
            drink.m_41739_(drinkTag);
            drinkList.add((Object)drinkTag);
        }
        tag.m_128365_("Drinks", (Tag)drinkList);
    }

    public void m_142466_(@NotNull CompoundTag tag) {
        super.m_142466_(tag);
        this.drinks.clear();
        if (tag.m_128425_("Drinks", 9)) {
            ListTag drinkList = tag.m_128437_("Drinks", 10);
            for (int i = 0; i < drinkList.size(); ++i) {
                CompoundTag drinkTag = drinkList.m_128728_(i);
                ItemStack drink = ItemStack.m_41712_((CompoundTag)drinkTag);
                this.drinks.add(drink);
            }
        }
    }

    public void applyEffects(LivingEntity user, int durationTicks) {
        for (ItemStack drink : this.drinks) {
            ResourceLocation effectId;
            MobEffect effect;
            CompoundTag tag;
            if (!(drink.m_41720_() instanceof DrinkBlockItem) || (tag = drink.m_41783_()) == null || !tag.m_128441_("Effect") || !tag.m_128441_("EffectDuration") || (effect = (MobEffect)BuiltInRegistries.f_256974_.m_7745_(effectId = new ResourceLocation(tag.m_128461_("Effect")))) == null) continue;
            user.m_7292_(new MobEffectInstance(effect, durationTicks));
        }
    }
}

