/*
 * Decompiled with CFR 0.152.
 */
package rbasamoyai.createbigcannons.munitions.config;

import com.google.common.collect.ImmutableMap;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.level.block.Block;
import rbasamoyai.createbigcannons.utils.CBCRegistryUtils;
import rbasamoyai.createbigcannons.utils.CBCUtils;

public record BigCannonPropellantCompatibilities(Map<Block, Integer> validPropellantCounts) {
    public static BigCannonPropellantCompatibilities DEFAULT = new BigCannonPropellantCompatibilities((Map<Block, Integer>)ImmutableMap.of());

    public static BigCannonPropellantCompatibilities fromJson(JsonObject obj, @Nullable BigCannonPropellantCompatibilities previous, boolean replaceValues) {
        if (previous == null) {
            previous = DEFAULT;
        }
        ImmutableMap.Builder builder = ImmutableMap.builder();
        if (!replaceValues) {
            builder.putAll(previous.validPropellantCounts);
        }
        JsonArray validPropellants = GsonHelper.m_13832_((JsonObject)obj, (String)"propellant", (JsonArray)new JsonArray());
        for (JsonElement el : validPropellants) {
            JsonObject obj1;
            if (!el.isJsonObject() || !(obj1 = el.getAsJsonObject()).has("type") && !obj1.getAsJsonPrimitive("type").isString()) continue;
            ResourceLocation loc = CBCUtils.location(obj1.getAsJsonPrimitive("type").getAsString());
            Block block = CBCRegistryUtils.getOptionalBlock(loc).orElseThrow(() -> new JsonSyntaxException("Unknown block '" + String.valueOf(loc) + "'"));
            int maxCount = Math.max(-1, GsonHelper.m_13824_((JsonObject)obj1, (String)"maximum_amount", (int)-1));
            builder.put((Object)block, (Object)maxCount);
        }
        return new BigCannonPropellantCompatibilities((Map<Block, Integer>)builder.build());
    }

    public JsonElement serialize() {
        JsonObject obj = new JsonObject();
        JsonArray propellants = new JsonArray();
        for (Map.Entry<Block, Integer> e : this.validPropellantCounts.entrySet()) {
            JsonObject obj1 = new JsonObject();
            obj1.addProperty("type", CBCRegistryUtils.getBlockLocation(e.getKey()).toString());
            obj1.addProperty("maximum_amount", (Number)e.getValue());
        }
        obj.add("propellant", (JsonElement)propellants);
        return obj;
    }

    public void writeBuf(FriendlyByteBuf buf) {
        buf.m_130130_(this.validPropellantCounts.size());
        for (Map.Entry<Block, Integer> e : this.validPropellantCounts.entrySet()) {
            buf.m_130085_(CBCRegistryUtils.getBlockLocation(e.getKey())).m_130130_(e.getValue().intValue());
        }
    }

    public static BigCannonPropellantCompatibilities readBuf(FriendlyByteBuf buf) {
        int sz = buf.m_130242_();
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (int i = 0; i < sz; ++i) {
            Optional<Block> block = CBCRegistryUtils.getOptionalBlock(buf.m_130281_());
            if (block.isEmpty()) continue;
            int count = buf.m_130242_();
            builder.put((Object)block.get(), (Object)count);
        }
        return new BigCannonPropellantCompatibilities((Map<Block, Integer>)builder.build());
    }
}

