/*
 * Decompiled with CFR 0.152.
 */
package top.leonx.irisflw.backend;

import dev.engine_room.flywheel.backend.compile.ContextShader;
import dev.engine_room.flywheel.backend.compile.core.LinkResult;
import dev.engine_room.flywheel.backend.compile.core.ProgramLinker;
import dev.engine_room.flywheel.backend.gl.shader.GlProgram;
import dev.engine_room.flywheel.backend.gl.shader.GlShader;
import dev.engine_room.flywheel.backend.gl.shader.ShaderType;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import net.irisshaders.iris.Iris;
import net.irisshaders.iris.gl.blending.AlphaTest;
import net.irisshaders.iris.gl.blending.AlphaTestFunction;
import net.irisshaders.iris.gl.blending.BlendModeOverride;
import net.irisshaders.iris.gl.shader.StandardMacros;
import net.irisshaders.iris.gl.state.FogMode;
import net.irisshaders.iris.helpers.StringPair;
import net.irisshaders.iris.pipeline.IrisRenderingPipeline;
import net.irisshaders.iris.pipeline.WorldRenderingPipeline;
import net.irisshaders.iris.shaderpack.loading.ProgramId;
import net.irisshaders.iris.shaderpack.preprocessor.JcppProcessor;
import net.irisshaders.iris.shaderpack.programs.ProgramFallbackResolver;
import net.irisshaders.iris.shaderpack.programs.ProgramSet;
import net.irisshaders.iris.shaderpack.programs.ProgramSource;
import net.irisshaders.iris.shaderpack.properties.ShaderProperties;
import net.irisshaders.iris.vertices.IrisVertexFormats;
import net.minecraft.client.renderer.ShaderInstance;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.lwjgl.opengl.GL20;
import top.leonx.irisflw.IrisFlw;
import top.leonx.irisflw.accessors.IrisRenderingPipelineAccessor;
import top.leonx.irisflw.accessors.ProgramDirectivesAccessor;
import top.leonx.irisflw.accessors.ProgramSourceAccessor;
import top.leonx.irisflw.backend.IntermediateGlShader;
import top.leonx.irisflw.flywheel.IrisFlwCompatGlProgram;
import top.leonx.irisflw.flywheel.IrisFlwCompatGlProgramBase;
import top.leonx.irisflw.flywheel.RenderLayerEventStateManager;
import top.leonx.irisflw.transformer.GlslTransformerFragPatcher;
import top.leonx.irisflw.transformer.GlslTransformerVertPatcher;

public class IrisProgramLinker
extends ProgramLinker {
    private final Map<ProgramSet, ProgramFallbackResolver> resolvers = new HashMap<ProgramSet, ProgramFallbackResolver>();
    private final Iterable<StringPair> environmentDefines;
    private final GlslTransformerVertPatcher vertPatcher;
    public static final boolean PATCH_FRAG = false;
    private GlslTransformerFragPatcher fragPatcher;
    public ContextShader contextShader = ContextShader.DEFAULT;
    static int programCounter;

    public IrisProgramLinker() {
        this.environmentDefines = StandardMacros.createStandardEnvironmentDefines();
        this.vertPatcher = new GlslTransformerVertPatcher();
    }

    public GlProgram link(List<GlShader> shaders, Consumer<GlProgram> preLink) {
        LinkResult linkResult = this.linkInternal(shaders, preLink);
        if (linkResult == null || linkResult instanceof LinkResult.Failure) {
            return IrisFlwCompatGlProgramBase.Invalid.INSTANCE;
        }
        return linkResult.unwrap();
    }

    private LinkResult linkInternal(List<GlShader> shaders, Consumer<GlProgram> preLink) {
        int handle = GL20.glCreateProgram();
        WorldRenderingPipeline pipeline = Iris.getPipelineManager().getPipelineNullable();
        String vertexSource = null;
        String vertexShaderName = null;
        String fragSource = null;
        String fragShaderName = null;
        for (GlShader glShader : shaders) {
            if (!(glShader instanceof IntermediateGlShader)) continue;
            IntermediateGlShader intermediateGlShader = (IntermediateGlShader)glShader;
            if (intermediateGlShader.type == ShaderType.VERTEX) {
                vertexSource = intermediateGlShader.getSource();
                vertexShaderName = intermediateGlShader.getName();
                continue;
            }
            if (intermediateGlShader.type != ShaderType.FRAGMENT) continue;
            fragSource = intermediateGlShader.getSource();
            fragShaderName = intermediateGlShader.getName();
        }
        if (pipeline instanceof IrisRenderingPipeline) {
            IrisRenderingPipeline newPipeline = (IrisRenderingPipeline)pipeline;
            if (vertexSource != null && vertexShaderName != null && fragSource != null && fragShaderName != null) {
                return this.getIrisShaderLinkResult((IrisRenderingPipelineAccessor)newPipeline, vertexShaderName, vertexSource, fragShaderName, fragSource);
            }
        }
        GlProgram out = new GlProgram(handle);
        for (GlShader shader : shaders) {
            GL20.glAttachShader((int)handle, (int)shader.handle());
        }
        preLink.accept(out);
        GL20.glLinkProgram((int)handle);
        String string = GL20.glGetProgramInfoLog((int)handle);
        if (IrisProgramLinker.linkSuccessful(handle)) {
            return LinkResult.success((GlProgram)out, (String)string);
        }
        out.delete();
        return LinkResult.failure((String)string);
    }

    @Nullable
    private LinkResult getIrisShaderLinkResult(IrisRenderingPipelineAccessor newPipeline, String vertexName, String vertexSource, String fragName, String newFragSource) {
        boolean isEmbedded;
        boolean isShadow;
        ProgramSet programSet = newPipeline.getProgramSet();
        Optional<ProgramSource> sourceReferenceOpt = this.getProgramSourceReference(programSet, vertexName, isShadow = RenderLayerEventStateManager.isRenderingShadow(), isEmbedded = this.contextShader == ContextShader.EMBEDDED);
        if (sourceReferenceOpt.isEmpty()) {
            return null;
        }
        ProgramSource sourceRef = sourceReferenceOpt.get();
        String vertexRef = (String)sourceRef.getVertexSource().orElseThrow();
        String fragRef = (String)sourceRef.getFragmentSource().orElseThrow();
        String newVertexSource = this.vertPatcher.patch(vertexRef, vertexSource, isShadow, isEmbedded, IrisFlw.isUsingExtendedVertexFormat());
        newVertexSource = JcppProcessor.glslPreprocessSource((String)newVertexSource, this.environmentDefines);
        newFragSource = fragRef;
        String shaderName = vertexName + "_" + fragName;
        ProgramSource newProgramSource = this.programSourceOverrideVertexSource(shaderName, programSet, sourceRef, newVertexSource, newFragSource);
        ((ProgramDirectivesAccessor)newProgramSource.getDirectives()).setFlwAlphaTestOverride(new AlphaTest(AlphaTestFunction.GREATER, 0.5f));
        return this.createWorldProgramBySource(shaderName, isShadow, newPipeline, newProgramSource);
    }

    private static boolean linkSuccessful(int handle) {
        return GL20.glGetProgrami((int)handle, (int)35714) == 1;
    }

    protected LinkResult createWorldProgramBySource(String name, boolean isShadow, IrisRenderingPipelineAccessor pipeline, ProgramSource processedSource) {
        ShaderInstance override = null;
        try {
            override = isShadow ? pipeline.callCreateShadowShader(this.getFlwShaderName(name, true), processedSource, ProgramId.Block, AlphaTest.ALWAYS, IrisVertexFormats.TERRAIN, false, false, false) : pipeline.callCreateShader(this.getFlwShaderName(name, false), processedSource, ProgramId.Block, AlphaTest.ALWAYS, IrisVertexFormats.TERRAIN, FogMode.OFF, false, false, false, false);
        }
        catch (Exception exception) {
            IrisFlw.LOGGER.error("Fail to compile shader", (Throwable)exception);
            return LinkResult.failure((String)exception.toString());
        }
        if (override != null) {
            return LinkResult.success((GlProgram)new IrisFlwCompatGlProgram(override, ShaderType.VERTEX, name), (String)"");
        }
        return null;
    }

    private String getFlwShaderName(String shaderName, boolean isShadow) {
        String randomId = String.valueOf(programCounter);
        ++programCounter;
        if (isShadow) {
            return String.format("shadow_flw_%s_%s", shaderName, randomId);
        }
        return String.format("gbuffers_flw_%s_%s", shaderName, randomId);
    }

    @NotNull
    protected ProgramSource programSourceOverrideVertexSource(String shaderName, ProgramSet programSet, ProgramSource source, String vertexSource, String fragSource) {
        ShaderProperties properties = ((ProgramSourceAccessor)source).getShaderProperties();
        BlendModeOverride blendModeOverride = ((ProgramSourceAccessor)source).getBlendModeOverride();
        return new ProgramSource(source.getName() + "_" + shaderName, vertexSource, (String)source.getGeometrySource().orElse(null), (String)source.getTessControlSource().orElse(null), (String)source.getTessEvalSource().orElse(null), fragSource, programSet, properties, blendModeOverride);
    }

    protected Optional<ProgramSource> getProgramSourceReference(ProgramSet programSet, String flwShaderName, boolean isShadow, boolean isEmbedded) {
        ProgramSource refProgram;
        ProgramFallbackResolver resolver = this.resolvers.computeIfAbsent(programSet, ProgramFallbackResolver::new);
        if (isShadow) {
            ProgramSource shadow = resolver.resolve(ProgramId.Shadow).orElse(null);
            if (shadow == null) {
                return Optional.empty();
            }
            ShaderProperties properties = ((ProgramSourceAccessor)shadow).getShaderProperties();
            BlendModeOverride blendModeOverride = ((ProgramSourceAccessor)shadow).getBlendModeOverride();
            return Optional.of(new ProgramSource("shadow_flw", (String)shadow.getVertexSource().orElseThrow(), (String)shadow.getGeometrySource().orElse(null), null, null, (String)shadow.getFragmentSource().orElseThrow(), programSet, properties, blendModeOverride));
        }
        ProgramId refProgramId = ProgramId.Block;
        if (isEmbedded) {
            refProgramId = ProgramId.Terrain;
        }
        if ((refProgram = (ProgramSource)resolver.resolve(refProgramId).orElse(null)) == null) {
            return Optional.empty();
        }
        ShaderProperties properties = ((ProgramSourceAccessor)refProgram).getShaderProperties();
        BlendModeOverride blendModeOverride = ((ProgramSourceAccessor)refProgram).getBlendModeOverride();
        return Optional.of(new ProgramSource("gbuffer_flw", (String)refProgram.getVertexSource().orElseThrow(), (String)refProgram.getGeometrySource().orElse(null), null, null, (String)refProgram.getFragmentSource().orElseThrow(), programSet, properties, blendModeOverride));
    }
}

