/*
 * Decompiled with CFR 0.152.
 */
package top.leonx.irisflw.backend;

import dev.engine_room.flywheel.backend.InternalVertex;
import dev.engine_room.flywheel.backend.engine.IndexPool;
import dev.engine_room.flywheel.backend.engine.MeshPool;
import dev.engine_room.flywheel.backend.gl.array.GlVertexArray;
import dev.engine_room.flywheel.backend.gl.buffer.GlBuffer;
import java.lang.reflect.Field;
import top.leonx.irisflw.IrisFlw;
import top.leonx.irisflw.backend.IrisInternalVertex;

public class IrisMeshPool
extends MeshPool {
    private final GlBuffer vbo;
    private final IndexPool indexPool;

    public IrisMeshPool() {
        try {
            Field indexPoolField = MeshPool.class.getDeclaredField("indexPool");
            indexPoolField.setAccessible(true);
            this.indexPool = (IndexPool)indexPoolField.get((Object)this);
            Field vboField = MeshPool.class.getDeclaredField("vbo");
            vboField.setAccessible(true);
            this.vbo = (GlBuffer)vboField.get((Object)this);
            if (IrisFlw.isUsingExtendedVertexFormat()) {
                Field vertexViewField = MeshPool.class.getDeclaredField("vertexView");
                vertexViewField.setAccessible(true);
                vertexViewField.set((Object)this, IrisInternalVertex.createVertexView());
            }
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            throw new RuntimeException(e);
        }
    }

    public void bind(GlVertexArray vertexArray) {
        this.indexPool.bind(vertexArray);
        if (IrisFlw.isUsingExtendedVertexFormat()) {
            vertexArray.bindVertexBuffer(0, this.vbo.handle(), 0L, IrisInternalVertex.EXT_STRIDE);
            vertexArray.bindAttributes(0, 0, IrisInternalVertex.EXT_ATTRIBUTES);
        } else {
            vertexArray.bindVertexBuffer(0, this.vbo.handle(), 0L, InternalVertex.STRIDE);
            vertexArray.bindAttributes(0, 0, InternalVertex.ATTRIBUTES);
        }
    }
}

