/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.vinery.client.render.block;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.satisfy.vinery.core.Vinery;
import net.satisfy.vinery.core.block.LatticeBlock;
import net.satisfy.vinery.core.block.entity.LatticeBlockEntity;
import net.satisfy.vinery.core.registry.GrapeTypeRegistry;
import net.satisfy.vinery.core.registry.ObjectRegistry;
import net.satisfy.vinery.core.util.GeneralUtil;
import net.satisfy.vinery.core.util.GrapeType;

public class LatticeRenderer
implements BlockEntityRenderer<LatticeBlockEntity> {
    private static Map<Block, ResourceLocation> textureMap;
    private final ModelPart growing_red;
    private final ModelPart sprout;
    private final ModelPart growing_white;
    private final ModelPart mesh;
    private final ModelPart support_right;
    private final ModelPart corner_braces_right;
    private final ModelPart support_left;
    private final ModelPart corner_braces_left;
    private final ModelPart growing_red_floor;
    private final ModelPart sprout_floor;
    private final ModelPart growing_white_floor;
    private final ModelPart lattice_parts;
    private final ModelPart hanging_1_r1;
    private final ModelPart hanging_2_r1;
    public static final ModelLayerLocation LAYER_LOCATION;

    private static Map<Block, ResourceLocation> getTextureMap() {
        if (textureMap == null) {
            textureMap = new HashMap<Block, ResourceLocation>();
            textureMap.put((Block)ObjectRegistry.OAK_LATTICE.get(), Vinery.identifier("textures/block/lattice/oak_lattice.png"));
            textureMap.put((Block)ObjectRegistry.SPRUCE_LATTICE.get(), Vinery.identifier("textures/block/lattice/spruce_lattice.png"));
            textureMap.put((Block)ObjectRegistry.CHERRY_LATTICE.get(), Vinery.identifier("textures/block/lattice/cherry_lattice.png"));
            textureMap.put((Block)ObjectRegistry.BIRCH_LATTICE.get(), Vinery.identifier("textures/block/lattice/birch_lattice.png"));
            textureMap.put((Block)ObjectRegistry.DARK_OAK_LATTICE.get(), Vinery.identifier("textures/block/lattice/dark_oak_lattice.png"));
            textureMap.put((Block)ObjectRegistry.ACACIA_LATTICE.get(), Vinery.identifier("textures/block/lattice/acacia_lattice.png"));
            textureMap.put((Block)ObjectRegistry.BAMBOO_LATTICE.get(), Vinery.identifier("textures/block/lattice/bamboo_lattice.png"));
            textureMap.put((Block)ObjectRegistry.JUNGLE_LATTICE.get(), Vinery.identifier("textures/block/lattice/jungle_lattice.png"));
            textureMap.put((Block)ObjectRegistry.MANGROVE_LATTICE.get(), Vinery.identifier("textures/block/lattice/mangrove_lattice.png"));
            textureMap.put((Block)ObjectRegistry.DARK_CHERRY_LATTICE.get(), Vinery.identifier("textures/block/lattice/dark_cherry_lattice.png"));
        }
        return textureMap;
    }

    public LatticeRenderer(BlockEntityRendererProvider.Context context) {
        ModelPart root = context.m_173582_(LAYER_LOCATION);
        ModelPart lattice_wall = root.m_171324_("lattice_wall");
        ModelPart grape_cluster = lattice_wall.m_171324_("grape_cluster");
        this.growing_red = grape_cluster.m_171324_("growing_red");
        this.sprout = grape_cluster.m_171324_("sprout");
        this.growing_white = grape_cluster.m_171324_("growing_white");
        this.mesh = lattice_wall.m_171324_("mesh");
        this.support_right = lattice_wall.m_171324_("support_right");
        this.corner_braces_right = lattice_wall.m_171324_("corner_braces_right");
        this.support_left = lattice_wall.m_171324_("support_left");
        this.corner_braces_left = lattice_wall.m_171324_("corner_braces_left");
        ModelPart lattice_floor = root.m_171324_("lattice_floor");
        ModelPart grape_cluster_floor = lattice_floor.m_171324_("grape_cluster_floor");
        this.growing_red_floor = grape_cluster_floor.m_171324_("growing_red_floor");
        this.sprout_floor = grape_cluster_floor.m_171324_("sprout_floor");
        this.growing_white_floor = grape_cluster_floor.m_171324_("growing_white_floor");
        this.lattice_parts = lattice_floor.m_171324_("lattice_parts");
        this.hanging_1_r1 = grape_cluster_floor.m_171324_("hanging_1_r1");
        this.hanging_2_r1 = grape_cluster_floor.m_171324_("hanging_2_r1");
    }

    public static LayerDefinition getTexturedModelData() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.m_171576_();
        PartDefinition lattice_wall = partdefinition.m_171599_("lattice_wall", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)24.0f, (float)0.0f));
        PartDefinition grape_cluster = lattice_wall.m_171599_("grape_cluster", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)-10.0f));
        PartDefinition growing_red = grape_cluster.m_171599_("growing_red", CubeListBuilder.m_171558_().m_171514_(46, 17).m_171488_(-15.0f, -16.0f, -10.5f, 16.0f, 16.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)7.0f, (float)0.0f, (float)17.0f));
        PartDefinition sprout = grape_cluster.m_171599_("sprout", CubeListBuilder.m_171558_().m_171514_(46, 0).m_171488_(-15.0f, -16.0f, -10.5f, 16.0f, 16.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)7.0f, (float)0.0f, (float)17.0f));
        PartDefinition growing_white = grape_cluster.m_171599_("growing_white", CubeListBuilder.m_171558_().m_171514_(46, 34).m_171488_(-15.0f, -16.0f, -10.5f, 16.0f, 16.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)7.0f, (float)0.0f, (float)17.0f));
        PartDefinition mesh = lattice_wall.m_171599_("mesh", CubeListBuilder.m_171558_().m_171514_(48, 64).m_171488_(-30.0f, -12.0f, 2.0f, 16.0f, 16.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)22.0f, (float)-4.0f, (float)5.0f));
        PartDefinition support_right = lattice_wall.m_171599_("support_right", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(-8.0f, -9.0f, 7.0f, 2.0f, 16.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)14.0f, (float)-7.0f, (float)-1.0f));
        PartDefinition corner_braces_right = lattice_wall.m_171599_("corner_braces_right", CubeListBuilder.m_171558_().m_171514_(8, 0).m_171488_(6.0f, -16.0f, -2.0f, 2.0f, 2.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition corner_braces_right_bottom_r1 = corner_braces_right.m_171599_("corner_braces_right_bottom_r1", CubeListBuilder.m_171558_().m_171514_(8, 10).m_171488_(-7.99f, -4.0f, 6.0f, 1.98f, 9.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)14.0f, (float)-7.0f, (float)-1.0f, (float)0.7854f, (float)0.0f, (float)0.0f));
        PartDefinition corner_braces_right_top_r1 = corner_braces_right.m_171599_("corner_braces_right_top_r1", CubeListBuilder.m_171558_().m_171514_(3, 10).m_171488_(-7.99f, -6.0f, -5.5f, 1.98f, 1.0f, 11.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)14.0f, (float)-7.0f, (float)-1.0f, (float)-0.7854f, (float)0.0f, (float)0.0f));
        PartDefinition support_left = lattice_wall.m_171599_("support_left", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(-16.0f, -16.0f, 14.0f, 2.0f, 16.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)8.0f, (float)0.0f, (float)-8.0f));
        PartDefinition corner_braces_left = lattice_wall.m_171599_("corner_braces_left", CubeListBuilder.m_171558_().m_171514_(8, 0).m_171488_(-8.0f, -16.0f, -2.0f, 2.0f, 2.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition corner_braces_left_top_r1 = corner_braces_left.m_171599_("corner_braces_left_top_r1", CubeListBuilder.m_171558_().m_171514_(8, 10).m_171488_(-7.99f, -4.0f, 6.0f, 1.98f, 9.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)-7.0f, (float)-1.0f, (float)0.7854f, (float)0.0f, (float)0.0f));
        PartDefinition corner_braces_left_bottom_r1 = corner_braces_left.m_171599_("corner_braces_left_bottom_r1", CubeListBuilder.m_171558_().m_171514_(3, 10).m_171488_(-7.99f, -6.0f, -5.5f, 1.98f, 1.0f, 11.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)-7.0f, (float)-1.0f, (float)-0.7854f, (float)0.0f, (float)0.0f));
        PartDefinition lattice_floor = partdefinition.m_171599_("lattice_floor", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)24.0f, (float)0.0f));
        PartDefinition grape_cluster_floor = lattice_floor.m_171599_("grape_cluster_floor", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)-4.5f, (float)4.0f));
        PartDefinition hanging_2_r1 = grape_cluster_floor.m_171599_("hanging_2_r1", CubeListBuilder.m_171558_().m_171514_(32, 14).m_171481_(-7.0f, -11.5f, -1.0f, 8.0f, 12.0f, 0.0f), PartPose.m_171423_((float)2.8284f, (float)14.5f, (float)-3.4142f, (float)0.0f, (float)0.7854f, (float)0.0f));
        PartDefinition hanging_1_r1 = grape_cluster_floor.m_171599_("hanging_1_r1", CubeListBuilder.m_171558_().m_171514_(32, 0).m_171481_(-7.0f, -9.5f, -1.0f, 8.0f, 10.0f, 0.0f), PartPose.m_171423_((float)1.4142f, (float)12.5f, (float)0.8284f, (float)0.0f, (float)-0.7854f, (float)0.0f));
        PartDefinition growing_red_floor = grape_cluster_floor.m_171599_("growing_red_floor", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)-3.5f, (float)1.0f));
        PartDefinition growing_red_floor_r1 = growing_red_floor.m_171599_("growing_red_floor_r1", CubeListBuilder.m_171558_().m_171514_(2, 52).m_171481_(-18.0f, -30.5f, -3.0f, 16.0f, 1.0f, 12.0f), PartPose.m_171423_((float)3.0f, (float)32.5f, (float)8.5f, (float)0.0f, (float)-1.5708f, (float)0.0f));
        PartDefinition sprout_floor = grape_cluster_floor.m_171599_("sprout_floor", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)-3.5f, (float)1.0f));
        PartDefinition sprouting_grapes_floor_r1 = sprout_floor.m_171599_("sprouting_grapes_floor_r1", CubeListBuilder.m_171558_().m_171514_(2, 39).m_171481_(-18.0f, -30.5f, -3.0f, 16.0f, 1.0f, 12.0f), PartPose.m_171423_((float)3.0f, (float)32.5f, (float)8.5f, (float)0.0f, (float)-1.5708f, (float)0.0f));
        PartDefinition growing_white_floor = grape_cluster_floor.m_171599_("growing_white_floor", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)-3.5f, (float)1.0f));
        PartDefinition growing_white_floor_r1 = growing_white_floor.m_171599_("growing_white_floor_r1", CubeListBuilder.m_171558_().m_171514_(2, 65).m_171481_(-18.0f, -30.5f, -3.0f, 16.0f, 1.0f, 12.0f), PartPose.m_171423_((float)3.0f, (float)32.5f, (float)8.5f, (float)0.0f, (float)-1.5708f, (float)0.0f));
        PartDefinition lattice_parts = lattice_floor.m_171599_("lattice_parts", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition cross_brace_r1 = lattice_parts.m_171599_("cross_brace_r1", CubeListBuilder.m_171558_().m_171514_(-12, 24).m_171488_(-18.0f, -29.0f, -3.0f, 16.0f, 0.0f, 12.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)3.0f, (float)28.0f, (float)10.0f, (float)0.0f, (float)-1.5708f, (float)0.0f));
        PartDefinition support_floor_left_r1 = lattice_parts.m_171599_("support_floor_left_r1", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(-16.0f, -16.0f, 14.0f, 2.0f, 16.0f, 2.0f, new CubeDeformation(0.0f)).m_171514_(0, 0).m_171480_().m_171488_(-30.0f, -16.0f, 14.0f, 2.0f, 16.0f, 2.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171423_((float)22.0f, (float)-16.0f, (float)-8.0f, (float)-1.5708f, (float)0.0f, (float)0.0f));
        return LayerDefinition.m_171565_((MeshDefinition)meshdefinition, (int)80, (int)80);
    }

    public void render(LatticeBlockEntity blockEntity, float partialTicks, PoseStack poseStack, MultiBufferSource buffer, int packedLight, int packedOverlay) {
        poseStack.m_85836_();
        BlockState state = blockEntity.m_58900_();
        Direction direction = (Direction)state.m_61143_((Property)LatticeBlock.FACING);
        boolean support = (Boolean)state.m_61143_((Property)LatticeBlock.SUPPORT);
        boolean bottom = (Boolean)state.m_61143_((Property)LatticeBlock.BOTTOM);
        GeneralUtil.LineConnectingType type = (GeneralUtil.LineConnectingType)((Object)state.m_61143_(LatticeBlock.TYPE));
        int age = (Integer)state.m_61143_((Property)LatticeBlock.AGE);
        GrapeType grapeType = (GrapeType)state.m_61143_((Property)LatticeBlock.GRAPE);
        poseStack.m_85837_(0.5, 0.0, 0.5);
        poseStack.m_252781_(Axis.f_252436_.m_252977_(-direction.m_122435_()));
        poseStack.m_85841_(1.0f, -1.0f, -1.0f);
        Block block = state.m_60734_();
        ResourceLocation texture = LatticeRenderer.getTextureMap().getOrDefault(block, Vinery.identifier("textures/entity/lattice/default_lattice.png"));
        VertexConsumer consumer = buffer.m_6299_(RenderType.m_110458_((ResourceLocation)texture));
        if (bottom) {
            poseStack.m_252781_(Axis.f_252403_.m_252977_(180.0f));
            poseStack.m_85841_(1.0f, -1.0f, -1.0f);
            this.lattice_parts.m_104301_(poseStack, consumer, packedLight, packedOverlay);
            if (!grapeType.equals(GrapeTypeRegistry.NONE)) {
                if (age < 4) {
                    this.sprout_floor.m_104301_(poseStack, consumer, packedLight, packedOverlay);
                } else if (grapeType.isRed()) {
                    this.growing_red_floor.m_104301_(poseStack, consumer, packedLight, packedOverlay);
                } else {
                    this.growing_white_floor.m_104301_(poseStack, consumer, packedLight, packedOverlay);
                }
            }
        } else {
            this.mesh.m_104301_(poseStack, consumer, packedLight, packedOverlay);
            if (type != GeneralUtil.LineConnectingType.MIDDLE && type != GeneralUtil.LineConnectingType.LEFT) {
                this.support_right.m_104301_(poseStack, consumer, packedLight, packedOverlay);
                if (support) {
                    this.corner_braces_right.m_104301_(poseStack, consumer, packedLight, packedOverlay);
                }
            }
            if (type != GeneralUtil.LineConnectingType.MIDDLE && type != GeneralUtil.LineConnectingType.RIGHT) {
                this.support_left.m_104301_(poseStack, consumer, packedLight, packedOverlay);
                if (support) {
                    this.corner_braces_left.m_104301_(poseStack, consumer, packedLight, packedOverlay);
                }
            }
        }
        if (!grapeType.equals(GrapeTypeRegistry.NONE)) {
            boolean isRed = grapeType.isRed();
            if (bottom) {
                if (age < 4) {
                    this.sprout_floor.m_104301_(poseStack, consumer, packedLight, packedOverlay);
                } else if (isRed) {
                    this.growing_red_floor.m_104301_(poseStack, consumer, packedLight, packedOverlay);
                } else {
                    this.growing_white_floor.m_104301_(poseStack, consumer, packedLight, packedOverlay);
                }
            } else if (age < 4) {
                this.sprout.m_104301_(poseStack, consumer, packedLight, packedOverlay);
            } else if (isRed) {
                this.growing_red.m_104301_(poseStack, consumer, packedLight, packedOverlay);
            } else {
                this.growing_white.m_104301_(poseStack, consumer, packedLight, packedOverlay);
            }
        }
        if (bottom && blockEntity.shouldShowHanging()) {
            poseStack.m_85836_();
            poseStack.m_85837_(0.0, 0.0, 0.0);
            poseStack.m_252781_(Axis.f_252436_.m_252977_(-direction.m_122435_()));
            poseStack.m_85841_(1.0f, -1.0f, -1.0f);
            poseStack.m_252781_(Axis.f_252403_.m_252977_(180.0f));
            RandomSource random = RandomSource.m_216335_((long)blockEntity.m_58899_().m_121878_());
            float offsetX = Mth.m_14179_((float)random.m_188501_(), (float)-0.02f, (float)0.0f);
            float offsetZ = Mth.m_14179_((float)random.m_188501_(), (float)-0.02f, (float)0.0f);
            poseStack.m_252880_(offsetX, -0.2f, offsetZ);
            this.hanging_1_r1.m_104301_(poseStack, consumer, packedLight, packedOverlay);
            this.hanging_2_r1.m_104301_(poseStack, consumer, packedLight, packedOverlay);
            poseStack.m_85849_();
        }
        poseStack.m_85849_();
    }

    static {
        LAYER_LOCATION = new ModelLayerLocation(Vinery.identifier("lattice"), "main");
    }
}

