/*
 * Decompiled with CFR 0.152.
 */
package com.blakebr0.mysticalagriculture.item;

import com.blakebr0.cucumber.item.BaseItem;
import com.blakebr0.cucumber.lib.Tooltips;
import com.blakebr0.cucumber.util.Formatting;
import com.blakebr0.mysticalagriculture.lib.ModTooltips;
import com.blakebr0.mysticalagriculture.util.IUpgradeableMachine;
import com.blakebr0.mysticalagriculture.util.MachineUpgradeTier;
import java.util.List;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class MachineUpgradeItem
extends BaseItem {
    private final MachineUpgradeTier tier;

    public MachineUpgradeItem(MachineUpgradeTier tier) {
        this.tier = tier;
    }

    public InteractionResult m_6225_(UseOnContext context) {
        IUpgradeableMachine machine;
        BlockPos pos;
        Level level = context.m_43725_();
        BlockEntity tile = level.m_7702_(pos = context.m_8083_());
        if (tile instanceof IUpgradeableMachine && (machine = (IUpgradeableMachine)tile).canApplyUpgrade(this.tier)) {
            ItemStack stack = context.m_43722_();
            ItemStack remaining = machine.applyUpgrade(this);
            stack.m_41774_(1);
            if (!remaining.m_41619_()) {
                ItemEntity item = new ItemEntity(level, (double)pos.m_123341_(), (double)(pos.m_123342_() + 1), (double)pos.m_123343_(), remaining.m_41777_());
                level.m_7967_((Entity)item);
            }
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.FAIL;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_7373_(ItemStack stack, Level level, List<Component> tooltip, TooltipFlag flag) {
        if (Screen.m_96638_()) {
            MutableComponent speed = Formatting.number((Object)(1.0 / this.tier.getOperationTimeMultiplier())).m_130940_(this.tier.getTextColor());
            MutableComponent fuelRate = Formatting.number((Object)this.tier.getFuelUsageMultiplier()).m_130940_(this.tier.getTextColor());
            MutableComponent fuelCapacity = Formatting.number((Object)this.tier.getFuelCapacityMultiplier()).m_130940_(this.tier.getTextColor());
            MutableComponent area = Formatting.number((Object)this.tier.getAddedRange()).m_130940_(this.tier.getTextColor());
            tooltip.add((Component)ModTooltips.UPGRADE_SPEED.args(new Object[]{speed}).build());
            tooltip.add((Component)ModTooltips.UPGRADE_FUEL_RATE.args(new Object[]{fuelRate}).build());
            tooltip.add((Component)ModTooltips.UPGRADE_FUEL_CAPACITY.args(new Object[]{fuelCapacity}).build());
            tooltip.add((Component)ModTooltips.UPGRADE_AREA.args(new Object[]{area}).build());
        } else {
            tooltip.add((Component)Tooltips.HOLD_SHIFT_FOR_INFO.build());
        }
    }

    public MachineUpgradeTier getTier() {
        return this.tier;
    }
}

