/*
 * Decompiled with CFR 0.152.
 */
package cofh.core.client;

import cofh.core.client.BasicBufferSource;
import cofh.core.client.PostEffect;
import cofh.core.util.helpers.RenderHelper;
import com.mojang.blaze3d.pipeline.RenderTarget;
import com.mojang.blaze3d.platform.Window;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderStateShard;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;

public abstract class PostBuffer
extends PostEffect
implements MultiBufferSource {
    protected final BasicBufferSource buffer = new BasicBufferSource(256);
    protected final String targetName;
    protected final String outputName;
    protected final RenderStateShard.OutputStateShard fallback;
    protected RenderStateShard.OutputStateShard output;
    protected RenderTarget target;
    protected boolean active;

    public PostBuffer(ResourceLocation shader, String targetName, RenderStateShard.OutputStateShard fallback) {
        super(shader);
        this.targetName = targetName;
        this.outputName = shader.toString();
        this.fallback = fallback;
        this.output = fallback;
    }

    public PostBuffer(ResourceLocation shader) {
        this(shader, "final", RenderType.f_110123_);
    }

    public VertexConsumer m_6299_(RenderType type) {
        if (this.isEnabled()) {
            this.active = true;
            return this.buffer.m_6299_(type);
        }
        return RenderHelper.bufferSource().m_6299_(type);
    }

    public VertexConsumer getBuffer(ResourceLocation texture) {
        return this.m_6299_(this.getRenderType(texture));
    }

    public abstract RenderType getRenderType(ResourceLocation var1);

    public RenderStateShard.OutputStateShard getOutputShard() {
        return this.isEnabled() ? this.output : this.fallback;
    }

    @Override
    public void begin(float partialTick) {
        if (this.active) {
            this.target.m_83954_(Minecraft.f_91002_);
            this.active = false;
        }
    }

    @Override
    public void end(float partialTick) {
        if (this.active) {
            this.buffer.endBatch();
            super.end(partialTick);
        }
    }

    @Override
    public void apply(Window window) {
        if (this.active) {
            this.target.m_83957_(window.m_85441_(), window.m_85442_(), false);
        }
    }

    @Override
    public void m_6213_(ResourceManager manager) {
        this.target = null;
        this.output = RenderType.f_110123_;
        super.m_6213_(manager);
    }

    @Override
    protected void onChainLoad() {
        this.target = this.chain.m_110036_(this.targetName);
        this.output = new RenderStateShard.OutputStateShard(this.outputName, () -> this.target.m_83947_(false), () -> Minecraft.m_91087_().m_91385_().m_83947_(false));
    }
}

