/*
 * Decompiled with CFR 0.152.
 */
package com.christofmeg.rechiseledae2.common.data;

import appeng.core.definitions.AEBlocks;
import com.christofmeg.rechiseledae2.common.block.BaseBlock;
import com.christofmeg.rechiseledae2.common.init.BlockRegistry;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.NotNull;

public class RechiseledRecipeProvider
implements DataProvider {
    private final String MOD_ID;
    private final DataGenerator generator;

    public RechiseledRecipeProvider(DataGenerator generator) {
        this.MOD_ID = "rechiseledae2";
        this.generator = generator;
    }

    @NotNull
    public String m_6055_() {
        return "Rechiseled Recipes: " + this.MOD_ID;
    }

    @NotNull
    public CompletableFuture<?> m_213708_(@NotNull CachedOutput cache) {
        ArrayList<Item> certus_quartz = new ArrayList<Item>();
        certus_quartz.add(AEBlocks.QUARTZ_BLOCK.m_5456_());
        certus_quartz.add(AEBlocks.QUARTZ_BRICKS.m_5456_());
        certus_quartz.add(AEBlocks.QUARTZ_PILLAR.m_5456_());
        certus_quartz.add(AEBlocks.CHISELED_QUARTZ_BLOCK.m_5456_());
        certus_quartz.add(AEBlocks.CUT_QUARTZ_BLOCK.m_5456_());
        certus_quartz.add(AEBlocks.SMOOTH_QUARTZ_BLOCK.m_5456_());
        certus_quartz.add(((Block)BlockRegistry.CERTUS_QUARTZ_BLOCK_BORDERED.get()).m_5456_());
        certus_quartz.add(((Block)BlockRegistry.CERTUS_QUARTZ_BLOCK_BRICK_PAVING.get()).m_5456_());
        certus_quartz.add(((Block)BlockRegistry.CERTUS_QUARTZ_BLOCK_CHISELED_PILLAR.get()).m_5456_());
        certus_quartz.add(((Block)BlockRegistry.CERTUS_QUARTZ_BLOCK_CHISELED_SQUARES.get()).m_5456_());
        certus_quartz.add(((Block)BlockRegistry.CERTUS_QUARTZ_BLOCK_CONNECTING.get()).m_5456_());
        certus_quartz.add(((Block)BlockRegistry.CERTUS_QUARTZ_BLOCK_CROSSES.get()).m_5456_());
        certus_quartz.add(((Block)BlockRegistry.CERTUS_QUARTZ_BLOCK_DIAGONAL_TILES.get()).m_5456_());
        certus_quartz.add(((Block)BlockRegistry.CERTUS_QUARTZ_BLOCK_PATTERN.get()).m_5456_());
        certus_quartz.add(((Block)BlockRegistry.CERTUS_QUARTZ_BLOCK_ROTATED_BRICKS.get()).m_5456_());
        certus_quartz.add(((Block)BlockRegistry.CERTUS_QUARTZ_BLOCK_ROWS.get()).m_5456_());
        certus_quartz.add(((Block)BlockRegistry.CERTUS_QUARTZ_BLOCK_SCALES.get()).m_5456_());
        certus_quartz.add(((Block)BlockRegistry.CERTUS_QUARTZ_BLOCK_SMALL_TILES.get()).m_5456_());
        certus_quartz.add(((Block)BlockRegistry.CERTUS_QUARTZ_BLOCK_SQUARES.get()).m_5456_());
        certus_quartz.add(((Block)BlockRegistry.CERTUS_QUARTZ_BLOCK_STRIPES.get()).m_5456_());
        certus_quartz.add(((Block)BlockRegistry.CERTUS_QUARTZ_BLOCK_TILES.get()).m_5456_());
        CompletableFuture<?> certusQuartzTask = this.chiselingRecipe(certus_quartz, cache, "certus_quartz");
        ArrayList<Item> sky_stone = new ArrayList<Item>();
        sky_stone.add(AEBlocks.SKY_STONE_BRICK.m_5456_());
        sky_stone.add(AEBlocks.SKY_STONE_SMALL_BRICK.m_5456_());
        sky_stone.add(AEBlocks.SMOOTH_SKY_STONE_BLOCK.m_5456_());
        sky_stone.add(((Block)BlockRegistry.SKY_STONE_BIG_TILES.get()).m_5456_());
        sky_stone.add(((Block)BlockRegistry.SKY_STONE_BORDERED.get()).m_5456_());
        sky_stone.add(((Block)BlockRegistry.SKY_STONE_BRICK_PATTERN.get()).m_5456_());
        sky_stone.add(((Block)BlockRegistry.SKY_STONE_BRICK_PAVING.get()).m_5456_());
        sky_stone.add(((Block)BlockRegistry.SKY_STONE_CHISELED_BRICKS.get()).m_5456_());
        sky_stone.add(((Block)BlockRegistry.SKY_STONE_COBBLED.get()).m_5456_());
        sky_stone.add(((Block)BlockRegistry.SKY_STONE_CRUSHED.get()).m_5456_());
        sky_stone.add(((Block)BlockRegistry.SKY_STONE_DIAGONAL_BRICKS.get()).m_5456_());
        sky_stone.add(((Block)BlockRegistry.SKY_STONE_PATH.get()).m_5456_());
        sky_stone.add(((Block)BlockRegistry.SKY_STONE_ROTATED_BRICKS.get()).m_5456_());
        sky_stone.add(((Block)BlockRegistry.SKY_STONE_SLATED.get()).m_5456_());
        sky_stone.add(((Block)BlockRegistry.SKY_STONE_SMALL_BRICKS.get()).m_5456_());
        sky_stone.add(((Block)BlockRegistry.SKY_STONE_SMALL_TILES.get()).m_5456_());
        sky_stone.add(((Block)BlockRegistry.SKY_STONE_SMOOTH.get()).m_5456_());
        sky_stone.add(((Block)BlockRegistry.SKY_STONE_SMOOTH_BRICK_PAVING.get()).m_5456_());
        sky_stone.add(((Block)BlockRegistry.SKY_STONE_SMOOTH_LARGE_TILES.get()).m_5456_());
        sky_stone.add(((Block)BlockRegistry.SKY_STONE_SMOOTH_ROTATED_BRICKS.get()).m_5456_());
        sky_stone.add(((Block)BlockRegistry.SKY_STONE_SMOOTH_TILES.get()).m_5456_());
        sky_stone.add(((Block)BlockRegistry.SKY_STONE_SQUARES.get()).m_5456_());
        sky_stone.add(((Block)BlockRegistry.SKY_STONE_TILES.get()).m_5456_());
        sky_stone.add(((Block)BlockRegistry.SKY_STONE_WAVES.get()).m_5456_());
        CompletableFuture<?> skyStoneTask = this.chiselingRecipe(sky_stone, cache, "sky_stone");
        return CompletableFuture.allOf(certusQuartzTask, skyStoneTask);
    }

    @NotNull
    private CompletableFuture<?> chiselingRecipe(List<Item> itemList, CachedOutput cache, String jsonName) {
        ArrayList<CompletableFuture<Void>> masterTask = new ArrayList<CompletableFuture<Void>>();
        Path path = this.generator.getPackOutput().m_245114_();
        ArrayList<CompletableFuture> tasks = new ArrayList<CompletableFuture>();
        JsonObject json = new JsonObject();
        json.addProperty("type", "rechiseled:chiseling");
        json.addProperty("overwrite", Boolean.valueOf(false));
        JsonArray entries = new JsonArray();
        for (Item item : itemList) {
            BaseBlock baseBlock;
            Item blockItem;
            if (item == null) continue;
            JsonObject object = new JsonObject();
            String string = item.m_5524_().replace("item.", "").replace("block.", "").replace(".", ":");
            object.addProperty("item", string);
            Block block = (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation(string));
            if (block instanceof BaseBlock && !(blockItem = (baseBlock = (BaseBlock)block).m_5456_()).toString().equals("certus_quartz_block_chiseled_squares") && !blockItem.toString().equals("sky_stone_cobbled") && !blockItem.toString().equals("sky_stone_slated")) {
                object.addProperty("connecting_item", string + "_connecting");
            }
            entries.add((JsonElement)object);
        }
        json.add("entries", (JsonElement)entries);
        Path recipePath = path.resolve("data/" + this.MOD_ID + "/chiseling_recipes/" + jsonName + ".json");
        tasks.add(DataProvider.m_253162_((CachedOutput)cache, (JsonElement)json, (Path)recipePath));
        masterTask.add(CompletableFuture.allOf((CompletableFuture[])tasks.toArray(CompletableFuture[]::new)));
        return CompletableFuture.allOf((CompletableFuture[])masterTask.toArray(CompletableFuture[]::new));
    }
}

