/*
 * Decompiled with CFR 0.152.
 */
package com.christofmeg.rechiseledae2.client.data;

import com.christofmeg.rechiseledae2.client.data.ModBlockStateProvider;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.client.model.generators.BlockStateProvider;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.RegistryObject;
import org.jetbrains.annotations.NotNull;

public class FusionBlockStateProvider
extends BlockStateProvider {
    private final PackOutput output;

    public FusionBlockStateProvider(PackOutput output, ExistingFileHelper exFileHelper) {
        super(output, "rechiseledae2", exFileHelper);
        this.output = output;
    }

    protected void registerStatesAndModels() {
    }

    @NotNull
    public CompletableFuture<?> m_213708_(@NotNull CachedOutput cache) {
        ArrayList tasks = new ArrayList();
        for (Map<RegistryObject<Block>, String> map : ModBlockStateProvider.masterList) {
            CompletableFuture<?> task = this.block(map, cache);
            tasks.add(task);
        }
        return CompletableFuture.allOf(CompletableFuture.allOf((CompletableFuture[])tasks.toArray(CompletableFuture[]::new)));
    }

    @NotNull
    private CompletableFuture<?> block(Map<RegistryObject<Block>, String> map, CachedOutput cache) {
        ArrayList<CompletableFuture<Void>> tasks = new ArrayList<CompletableFuture<Void>>();
        for (Map.Entry<RegistryObject<Block>, String> entry : map.entrySet()) {
            RegistryObject<Block> block = entry.getKey();
            ResourceLocation location = ForgeRegistries.BLOCKS.getKey((Object)((Block)block.get()));
            if (location == null) continue;
            Path jsonPath = this.output.m_245114_();
            CompletableFuture<Void> blockStateConnecting = FusionBlockStateProvider.getBlockStateConnecting(location, block, jsonPath, cache);
            CompletableFuture<Void> blockModelConnecting = FusionBlockStateProvider.getBlockModelConnecting(location, block, jsonPath, cache);
            CompletableFuture<Void> blockConnectingMcmeta = FusionBlockStateProvider.getBlockConnectingMcmeta(block, jsonPath, cache);
            CompletableFuture<Void> itemModelConnecting = FusionBlockStateProvider.getItemModelConnecting(location, block, jsonPath, cache);
            tasks.addAll(List.of(blockStateConnecting, blockModelConnecting, Objects.requireNonNull(blockConnectingMcmeta), itemModelConnecting));
        }
        return CompletableFuture.allOf(CompletableFuture.allOf((CompletableFuture[])tasks.toArray(CompletableFuture[]::new)));
    }

    @NotNull
    private static CompletableFuture<Void> getBlockStateConnecting(ResourceLocation location, RegistryObject<Block> block, Path jsonPath, CachedOutput cache) {
        JsonObject json = new JsonObject();
        JsonObject variants = new JsonObject();
        JsonObject empty = new JsonObject();
        empty.addProperty("model", "rechiseledae2:block/" + location.m_135815_() + "_connecting");
        variants.add("", (JsonElement)empty);
        json.add("variants", (JsonElement)variants);
        Path recipePath = jsonPath.resolve("assets/rechiseledae2/blockstates/" + block.getId().m_135815_() + "_connecting.json");
        return DataProvider.m_253162_((CachedOutput)cache, (JsonElement)json, (Path)recipePath).thenAccept(result -> {});
    }

    @NotNull
    private static CompletableFuture<Void> getBlockModelConnecting(ResourceLocation location, RegistryObject<Block> block, Path jsonPath, CachedOutput cache) {
        JsonObject blockModelConnecting = new JsonObject();
        blockModelConnecting.addProperty("type", "fusion:connecting");
        blockModelConnecting.addProperty("parent", "minecraft:block/cube_all");
        JsonArray connections = new JsonArray();
        JsonObject connectionsType = new JsonObject();
        connectionsType.addProperty("type", "fusion:is_same_block");
        connections.add((JsonElement)connectionsType);
        blockModelConnecting.add("connections", (JsonElement)connections);
        blockModelConnecting.addProperty("loader", "fusion:model");
        JsonObject textures = new JsonObject();
        textures.addProperty("all", "rechiseledae2:block/" + location.m_135815_());
        blockModelConnecting.add("textures", (JsonElement)textures);
        Path recipePath = jsonPath.resolve("assets/rechiseledae2/models/block/" + block.getId().m_135815_() + "_connecting.json");
        return DataProvider.m_253162_((CachedOutput)cache, (JsonElement)blockModelConnecting, (Path)recipePath).thenAccept(result -> {});
    }

    @NotNull
    private static CompletableFuture<Void> getBlockConnectingMcmeta(RegistryObject<Block> block, Path jsonPath, CachedOutput cache) {
        JsonObject mcmetaFile = new JsonObject();
        JsonObject connectionsType = new JsonObject();
        connectionsType.addProperty("type", "connecting");
        mcmetaFile.add("fusion", (JsonElement)connectionsType);
        Path recipePath = jsonPath.resolve("assets/rechiseledae2/textures/block/" + block.getId().m_135815_() + ".png.mcmeta");
        return DataProvider.m_253162_((CachedOutput)cache, (JsonElement)mcmetaFile, (Path)recipePath).thenAccept(result -> {});
    }

    @NotNull
    private static CompletableFuture<Void> getItemModelConnecting(ResourceLocation location, RegistryObject<Block> block, Path jsonPath, CachedOutput cache) {
        JsonObject json = new JsonObject();
        json.addProperty("parent", "rechiseledae2:block/" + location.m_135815_() + "_connecting");
        Path recipePath = jsonPath.resolve("assets/rechiseledae2/models/item/" + block.getId().m_135815_() + "_connecting.json");
        return DataProvider.m_253162_((CachedOutput)cache, (JsonElement)json, (Path)recipePath).thenAccept(result -> {});
    }
}

