/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.mixin;

import javax.annotation.Nullable;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import ovh.corail.tombstone.capability.FriendlyAnimalProvider;
import ovh.corail.tombstone.capability.IFriendlyAnimal;
import ovh.corail.tombstone.entity.SpectralWolf;
import ovh.corail.tombstone.helper.EntityHelper;
import ovh.corail.tombstone.registry.ModEntities;

@Mixin(value={LivingEntity.class})
public class LivingEntityMixin {
    @Inject(method={"canAttack"}, at={@At(value="RETURN")}, cancellable=true)
    private void methodCanAttack(LivingEntity target, CallbackInfoReturnable<Boolean> callbackInfoReturnable) {
        LivingEntity entity = (LivingEntity)this;
        if (((Boolean)callbackInfoReturnable.getReturnValue()).booleanValue() && target != null && EntityHelper.areOwnerOrServants(entity, target)) {
            callbackInfoReturnable.setReturnValue((Object)false);
        }
    }

    @Inject(method={"hurt"}, at={@At(value="RETURN")})
    private void methodHurt(DamageSource source, float amount, CallbackInfoReturnable<Boolean> callbackInfoReturnable) {
        Entity entity;
        if (callbackInfoReturnable.getReturnValueZ() && (entity = source.m_7639_()) instanceof LivingEntity) {
            LivingEntity causingEntity = (LivingEntity)entity;
            Player owner = null;
            if (EntityHelper.isServant((Entity)causingEntity)) {
                owner = EntityHelper.getServantOwner((Entity)causingEntity).orElse(null);
            } else if (causingEntity.m_6095_() == ModEntities.spectral_wolf) {
                owner = ((SpectralWolf)causingEntity).getOwner().orElse(null);
            } else if (causingEntity.getCapability(FriendlyAnimalProvider.FRIENDLY_ANIMAL_CAPABILITY).map(IFriendlyAnimal::isActive).orElse(false).booleanValue()) {
                owner = EntityHelper.getFriendlyOwner((Entity)causingEntity).orElse(null);
            }
            if (owner != null) {
                ((LivingEntity)this).m_6598_(owner);
            }
        }
    }

    @Inject(method={"setLastHurtByPlayer"}, at={@At(value="HEAD")}, cancellable=true)
    private void methodSetLastHurtByPlayer(@Nullable Player player, CallbackInfo callbackInfo) {
        LivingEntity thisLivingEntity = (LivingEntity)this;
        thisLivingEntity.f_20888_ = player;
        thisLivingEntity.f_20889_ = player != null ? 100 : 0;
        callbackInfo.cancel();
    }
}

