/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.loot;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import com.mojang.datafixers.util.Pair;
import java.util.Optional;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.functions.LootItemConditionalFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionType;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import ovh.corail.tombstone.helper.LootHelper;
import ovh.corail.tombstone.helper.RandomWeightedItem;
import ovh.corail.tombstone.registry.ModLootFunctions;

public class RandomInTagFunction
extends LootItemConditionalFunction {
    public static final ResourceLocation RL = new ResourceLocation("tombstone", "random_in_tag");
    public static final Serializer SERIALIZER = new Serializer();
    private final ResourceLocation tagRL;

    protected RandomInTagFunction(LootItemCondition[] conditionsIn, ResourceLocation tagRL) {
        super(conditionsIn);
        this.tagRL = tagRL;
    }

    public LootItemFunctionType m_7162_() {
        return ModLootFunctions.RANDOM_IN_TAG;
    }

    protected ItemStack m_7372_(ItemStack stack, LootContext context) {
        TagKey tagKey = BuiltInRegistries.f_257033_.m_203612_().map(Pair::getFirst).filter(t -> this.tagRL.equals((Object)t.f_203868_())).findFirst().orElse(null);
        if (tagKey != null) {
            RandomWeightedItem generator = LootHelper.getItemGenerator((TagKey<Item>)tagKey);
            return Optional.ofNullable(generator.getRandomItem()).map(ItemStack::new).orElse(ItemStack.f_41583_);
        }
        return ItemStack.f_41583_;
    }

    public static class Serializer
    extends LootItemConditionalFunction.Serializer<RandomInTagFunction> {
        public RandomInTagFunction deserialize(JsonObject json, JsonDeserializationContext deserializationContext, LootItemCondition[] conditionsIn) {
            return new RandomInTagFunction(conditionsIn, Optional.ofNullable(GsonHelper.m_13851_((JsonObject)json, (String)"rl", null)).map(ResourceLocation::new).orElse(ItemTags.f_271220_.f_203868_()));
        }

        public void serialize(JsonObject json, RandomInTagFunction fct, JsonSerializationContext serializationContext) {
            super.m_6170_(json, (LootItemConditionalFunction)fct, serializationContext);
            json.addProperty("rl", fct.tagRL.toString());
        }
    }

    public static class Builder
    extends LootItemConditionalFunction.Builder<Builder> {
        private final ResourceLocation tagRL;

        public Builder(TagKey<Item> tagKey) {
            this.tagRL = tagKey.f_203868_();
        }

        protected Builder getThis() {
            return this;
        }

        public LootItemFunction m_7453_() {
            return new RandomInTagFunction(this.m_80699_(), this.tagRL);
        }
    }
}

