/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.item;

import java.util.List;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import ovh.corail.tombstone.api.capability.ISoulConsumer;
import ovh.corail.tombstone.config.SharedConfigTombstone;
import ovh.corail.tombstone.helper.EffectHelper;
import ovh.corail.tombstone.helper.Helper;
import ovh.corail.tombstone.helper.LangKey;
import ovh.corail.tombstone.item.ItemBook;
import ovh.corail.tombstone.registry.ModTriggers;

public class ItemBookOfMagicImpregnation
extends ItemBook {
    public ItemBookOfMagicImpregnation() {
        super("book_of_magic_impregnation", () -> SharedConfigTombstone.allowed_magic_items.allowBookOfMagicImpregnation.get());
    }

    @Override
    public ISoulConsumer.ConsumeResult setEnchant(Level level, BlockPos gravePos, ServerPlayer player, ItemStack stack, int soulStrength) {
        int consumed;
        ItemStack mainhand;
        if (stack.m_41720_() != this || (mainhand = player.m_21205_()).m_41619_()) {
            return ISoulConsumer.ConsumeResult.fail((Component)LangKey.MESSAGE_MAGIC_IMPREGNATION_FAILED.getText(new Object[0]));
        }
        if (mainhand.m_150930_(Items.f_42412_)) {
            consumed = soulStrength;
            player.m_8061_(EquipmentSlot.MAINHAND, soulStrength == 1 ? EffectHelper.createRandomArrows(mainhand.m_41613_()) : EffectHelper.createCursedArrows(mainhand.m_41613_()));
            ModTriggers.CREATE_IMBUED_ARROW.trigger(player);
        } else {
            Map<Enchantment, Integer> enchantments = this.getDeserializedEnchantments(mainhand);
            if (enchantments.isEmpty()) {
                int enchantability = mainhand.getEnchantmentValue();
                if (!mainhand.m_41792_() || enchantability == 0) {
                    return ISoulConsumer.ConsumeResult.fail((Component)LangKey.MESSAGE_MAGIC_IMPREGNATION_FAILED.getText(new Object[0]));
                }
                consumed = soulStrength;
                int enchantmentCount = soulStrength > 1 ? 6 : 3;
                enchantments = Helper.getRandomEnchantments(enchantability + Helper.RANDOM.nextInt(soulStrength * 30), mainhand, enchantmentCount);
                if (mainhand.m_150930_(Items.f_42517_)) {
                    mainhand = new ItemStack((ItemLike)Items.f_42690_);
                    player.m_8061_(EquipmentSlot.MAINHAND, mainhand);
                }
            } else {
                List<Map.Entry> upgradables = enchantments.entrySet().stream().filter(e -> Helper.getMaxLevel((Enchantment)e.getKey()) > (Integer)e.getValue()).toList();
                if (upgradables.isEmpty()) {
                    return ISoulConsumer.ConsumeResult.fail((Component)LangKey.MESSAGE_MAGIC_IMPREGNATION_MAX.getText(new Object[0]));
                }
                if (soulStrength == 1 || upgradables.size() == 1) {
                    Map.Entry entry2 = upgradables.get(Helper.RANDOM.nextInt(upgradables.size()));
                    consumed = 1;
                    enchantments.put((Enchantment)entry2.getKey(), Math.min((Integer)entry2.getValue() + 3, Helper.getMaxLevel((Enchantment)entry2.getKey())));
                } else {
                    consumed = 2;
                    enchantments.entrySet().stream().filter(e -> Helper.getMaxLevel((Enchantment)e.getKey()) > (Integer)e.getValue()).forEach(entry -> entry.setValue(Math.min((Integer)entry.getValue() + 3, Helper.getMaxLevel((Enchantment)entry.getKey()))));
                }
            }
            EnchantmentHelper.m_44865_(enchantments, (ItemStack)mainhand);
        }
        stack.m_41774_(1);
        ModTriggers.USE_MAGIC_IMPREGNATION.trigger(player);
        return ISoulConsumer.ConsumeResult.success((Component)LangKey.MESSAGE_MAGIC_IMPREGNATION_SUCCESS.getText(new Object[0]), consumed);
    }
}

