/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.block;

import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;
import ovh.corail.tombstone.block.BlockGraveMarble;
import ovh.corail.tombstone.block.BlockHorizontalWaterLogged;
import ovh.corail.tombstone.block.GraveModel;
import ovh.corail.tombstone.helper.CallbackHandler;
import ovh.corail.tombstone.helper.DeathHandler;
import ovh.corail.tombstone.registry.ModBlocks;

public abstract class BlockGraveBase
extends BlockHorizontalWaterLogged {
    public static final IntegerProperty MODEL_TEXTURE = IntegerProperty.m_61631_((String)"model_texture", (int)0, (int)(BlockGraveMarble.MarbleType.values().length - 1));
    protected final GraveModel graveModel;

    public BlockGraveBase(BlockBehaviour.Properties builder, GraveModel graveModel) {
        super(builder.m_278166_(PushReaction.IGNORE).m_60991_((state, level, pos) -> true).m_60953_(state -> 5));
        this.graveModel = graveModel;
        this.m_49959_((BlockState)this.m_49966_().m_61124_((Property)MODEL_TEXTURE, (Comparable)Integer.valueOf(0)));
    }

    public String m_7705_() {
        return "tombstone.grave." + this.graveModel.m_7912_();
    }

    @Override
    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{MODEL_TEXTURE});
    }

    public boolean canEntityDestroy(BlockState state, BlockGetter blockGetter, BlockPos pos, Entity entity) {
        return false;
    }

    public void onBlockExploded(BlockState state, Level level, BlockPos pos, Explosion explosion) {
    }

    public boolean m_6903_(Explosion explosionIn) {
        return false;
    }

    public boolean canDropFromExplosion(BlockState state, BlockGetter blockGetter, BlockPos pos, Explosion explosion) {
        return false;
    }

    public boolean onDestroyedByPlayer(BlockState state, Level level, BlockPos pos, Player player, boolean willHarvest, FluidState fluid) {
        if (player.m_7500_()) {
            level.m_5898_(player, 2001, pos, BlockGraveBase.m_49956_((BlockState)state));
            if (!level.m_5776_()) {
                DeathHandler.INSTANCE.removeAndEmptyPlayerGrave(level, pos);
            }
            return true;
        }
        return false;
    }

    public void m_6810_(BlockState state, Level level, BlockPos pos, BlockState newState, boolean isMoving) {
        if (!level.m_5776_() && (ModBlocks.isPlayerGrave(state.m_60734_()) && !ModBlocks.isPlayerGrave(newState.m_60734_()) || ModBlocks.isDecorativeGrave(state.m_60734_()) && !ModBlocks.isDecorativeGrave(newState.m_60734_()))) {
            if (DeathHandler.INSTANCE.canRemovePlayerGrave(level, pos)) {
                this.onDrop(level, pos, state);
            } else {
                Optional.ofNullable(level.m_7702_(pos)).ifPresent(grave -> {
                    CompoundTag oldNbt = grave.m_187480_();
                    CallbackHandler.addFastCallback(() -> {
                        level.m_46597_(pos, state);
                        Optional.ofNullable(level.m_7702_(pos)).ifPresent(newGrave -> {
                            newGrave.m_142466_(oldNbt);
                            newGrave.m_6596_();
                            level.m_7260_(pos, newState, state, 3);
                        });
                    });
                });
            }
        }
        super.m_6810_(state, level, pos, newState, isMoving);
    }

    protected abstract void onDrop(Level var1, BlockPos var2, BlockState var3);

    public VoxelShape m_5940_(BlockState state, BlockGetter blockGetter, BlockPos pos, CollisionContext context) {
        return this.graveModel.getShape((Direction)state.m_61143_((Property)f_54117_));
    }

    public GraveModel getGraveType() {
        return this.graveModel;
    }

    @Nullable
    protected static <E extends BlockEntity, A extends BlockEntity> BlockEntityTicker<A> createTickerHelper(BlockEntityType<A> toCompare, BlockEntityType<E> entityType, BlockEntityTicker<? super E> ticker) {
        return entityType == toCompare ? ticker : null;
    }
}

