/*
 * Decompiled with CFR 0.152.
 */
package com.serpenssolida.createtransmission.content.chain;

import com.mojang.blaze3d.vertex.PoseStack;
import com.serpenssolida.createtransmission.CTModels;
import com.serpenssolida.createtransmission.CTSpriteShifts;
import com.serpenssolida.createtransmission.content.chain.AbstractTransmissionChainBlock;
import com.serpenssolida.createtransmission.content.chain.TransmissionChainBlock;
import com.serpenssolida.createtransmission.content.chain.TransmissionChainBlockEntity;
import com.serpenssolida.createtransmission.content.chain.TransmissionChainHelpers;
import com.simibubi.create.content.kinetics.KineticDebugger;
import com.simibubi.create.content.kinetics.base.KineticBlockEntity;
import com.simibubi.create.content.kinetics.base.KineticBlockEntityVisual;
import com.simibubi.create.content.kinetics.base.RotatingInstance;
import com.simibubi.create.content.processing.burner.ScrollInstance;
import com.simibubi.create.foundation.render.AllInstanceTypes;
import dev.engine_room.flywheel.api.instance.Instance;
import dev.engine_room.flywheel.api.instance.Instancer;
import dev.engine_room.flywheel.api.model.Model;
import dev.engine_room.flywheel.api.visualization.VisualizationContext;
import dev.engine_room.flywheel.lib.instance.AbstractInstance;
import dev.engine_room.flywheel.lib.instance.FlatLit;
import dev.engine_room.flywheel.lib.model.Models;
import dev.engine_room.flywheel.lib.model.baked.PartialModel;
import dev.engine_room.flywheel.lib.transform.PoseTransformStack;
import dev.engine_room.flywheel.lib.transform.TransformStack;
import java.util.EnumMap;
import java.util.Map;
import java.util.function.Consumer;
import net.createmod.catnip.render.SpriteShiftEntry;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public class TransmissionChainVisual
extends KineticBlockEntityVisual<TransmissionChainBlockEntity> {
    protected final EnumMap<Direction, RotatingInstance> shaftInstances = new EnumMap(Direction.class);
    protected ScrollInstance chainInstance;

    public TransmissionChainVisual(VisualizationContext context, TransmissionChainBlockEntity blockEntity, float partialTick) {
        super(context, (KineticBlockEntity)blockEntity, partialTick);
        TransmissionChainHelpers.ChainDirection facing = TransmissionChainHelpers.ChainDirection.of((Direction)this.blockState.m_61143_(AbstractTransmissionChainBlock.FACING));
        TransmissionChainHelpers.ChainConnection connection = AbstractTransmissionChainBlock.getConnection(this.blockState);
        this.shaftInstances.put(facing.direction, this.setupShaftData(facing.direction));
        Instancer chainKey = this.instancerProvider().instancer(AllInstanceTypes.SCROLLING, Models.partial((PartialModel)this.getChainModel(connection.type())));
        this.chainInstance = this.setupChainData((ScrollInstance)chainKey.createInstance(), CTSpriteShifts.CHAIN);
        if (connection.type() == TransmissionChainHelpers.ConnectionType.BELT) {
            Direction direction = facing.getDirectionFromSide(connection.side());
            RotatingInstance key = this.setupShaftData(direction);
            this.shaftInstances.put(direction, key);
        }
        this.update(0.0f);
    }

    public void update(float partialTick) {
        Direction facing = (Direction)this.blockState.m_61143_(AbstractTransmissionChainBlock.FACING);
        for (Map.Entry<Direction, RotatingInstance> key : this.shaftInstances.entrySet()) {
            Direction direction = key.getKey();
            Direction.Axis axis = direction.m_122434_();
            key.getValue().setRotationAxis(axis).setRotationOffset(TransmissionChainVisual.rotationOffset((BlockState)((TransmissionChainBlockEntity)this.blockEntity).m_58900_(), (Direction.Axis)direction.m_122434_(), (Vec3i)((TransmissionChainBlockEntity)this.blockEntity).m_58899_())).setRotationalSpeed(((TransmissionChainBlockEntity)this.blockEntity).getSpeed() * ((TransmissionChainBlockEntity)this.blockEntity).getRotationSpeedModifier(direction) * 6.0f);
            if (KineticDebugger.isActive()) {
                key.getValue().setColor((KineticBlockEntity)this.blockEntity);
            }
            key.getValue().setChanged();
        }
        this.chainInstance.setSpriteShift(CTSpriteShifts.CHAIN).speed(0.0f, this.getChainRotationalSpeed(facing) * ((TransmissionChainBlockEntity)this.blockEntity).getRotationSpeedModifier(facing) * 0.001984127f).colorRgb(RotatingInstance.colorFromBE((KineticBlockEntity)((KineticBlockEntity)this.blockEntity))).setChanged();
    }

    public void updateLight(float partialTick) {
        this.shaftInstances.forEach((direction, rotatingData) -> this.relight(this.pos, new FlatLit[]{rotatingData}));
        if (this.chainInstance != null) {
            this.relight(this.pos, new FlatLit[]{this.chainInstance});
        }
    }

    public void collectCrumblingInstances(Consumer<Instance> consumer) {
        consumer.accept((Instance)this.chainInstance);
        this.shaftInstances.forEach((direction, rotatingInstance) -> consumer.accept((Instance)rotatingInstance));
    }

    protected void _delete() {
        this.chainInstance.delete();
        this.shaftInstances.values().forEach(AbstractInstance::delete);
        this.shaftInstances.clear();
    }

    private PartialModel getChainModel(TransmissionChainHelpers.ConnectionType connectionType) {
        if (connectionType == TransmissionChainHelpers.ConnectionType.NONE) {
            return CTModels.CHAIN;
        }
        return connectionType == TransmissionChainHelpers.ConnectionType.CHAIN ? CTModels.CHAIN_CONNECTED : CTModels.CHAIN_BELT;
    }

    private RotatingInstance setupShaftData(Direction direction) {
        int blockLight = this.level.m_45517_(LightLayer.BLOCK, this.pos);
        int skyLight = this.level.m_45517_(LightLayer.SKY, this.pos);
        Instancer shaft = this.instancerProvider().instancer(AllInstanceTypes.ROTATING, this.getShaftModel(direction));
        Vector3f location = new Vector3f((float)this.getVisualPosition().m_123341_(), (float)this.getVisualPosition().m_123342_(), (float)this.getVisualPosition().m_123343_());
        Vector3f offset = direction.m_253071_().mul(0.03f);
        RotatingInstance instance = (RotatingInstance)shaft.createInstance();
        instance.setRotationAxis(direction.m_122434_()).setPosition(location.add((Vector3fc)offset)).light(blockLight, skyLight);
        return instance;
    }

    private Model getShaftModel(Direction direction) {
        return Models.partial((PartialModel)CTModels.CHAIN_SHAFT, (Object)direction, (axis, modelTransform) -> {
            PoseTransformStack msr = TransformStack.of((PoseStack)modelTransform);
            msr.center();
            msr.rotateToFace(direction.m_122424_());
            msr.uncenter();
        });
    }

    private ScrollInstance setupChainData(ScrollInstance instance, SpriteShiftEntry spriteShift) {
        Direction facing = (Direction)this.blockState.m_61143_((Property)TransmissionChainBlock.FACING);
        Quaternionf rotation = new Quaternionf();
        Direction up = Direction.UP;
        Vector3f vecFacing = facing.m_253071_().normalize();
        Vector3f vecUp = up.m_253071_().normalize();
        rotation = facing == Direction.UP ? new Quaternionf().fromAxisAngleDeg(1.0f, 0.0f, 0.0f, 90.0f) : (facing == Direction.DOWN ? new Quaternionf().fromAxisAngleDeg(1.0f, 0.0f, 0.0f, -90.0f) : rotation.lookAlong((Vector3fc)vecFacing, (Vector3fc)vecUp));
        if (facing == Direction.WEST || facing == Direction.EAST) {
            rotation = rotation.invert();
        }
        if (((TransmissionChainBlockEntity)this.blockEntity).isConnected()) {
            TransmissionChainHelpers.ChainSide side = AbstractTransmissionChainBlock.getConnection(this.blockState).side();
            Quaternionf connectionRotation = new Quaternionf().fromAxisAngleRad((Vector3fc)facing.m_122424_().m_253071_(), (float)side.rotationAngle);
            rotation = connectionRotation.mul((Quaternionfc)rotation);
        }
        instance.setSpriteShift(spriteShift, 1.0f, 0.5f).position((Vec3i)this.getVisualPosition()).rotation((Quaternionfc)rotation).speed(0.0f, this.getChainRotationalSpeed(facing) * ((TransmissionChainBlockEntity)this.blockEntity).getRotationSpeedModifier(facing)).offset(0.0f, 0.0f).colorRgb(RotatingInstance.colorFromBE((KineticBlockEntity)((KineticBlockEntity)this.blockEntity))).setChanged();
        return instance;
    }

    private float getChainRotationalSpeed(Direction direction) {
        return (float)direction.m_122421_().m_122540_() * -((TransmissionChainBlockEntity)this.blockEntity).getSpeed() * 0.415f;
    }
}

