/*
 * Decompiled with CFR 0.152.
 */
package com.serpenssolida.createtransmission.content.chain;

import com.google.common.collect.ImmutableBiMap;
import com.serpenssolida.createtransmission.content.chain.AbstractTransmissionChainBlock;
import com.serpenssolida.createtransmission.content.chain.TransmissionChainBlock;
import com.serpenssolida.createtransmission.content.chain.TransmissionChainBlockEntity;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.createmod.catnip.lang.Lang;
import net.minecraft.core.Direction;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.properties.Property;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public class TransmissionChainHelpers {
    public static Quaternionf getRotation(TransmissionChainBlockEntity be) {
        Direction facing = (Direction)be.m_58900_().m_61143_((Property)TransmissionChainBlock.FACING);
        ChainConnection connection = AbstractTransmissionChainBlock.getConnection(be.m_58900_());
        Quaternionf rotation = new Quaternionf();
        Direction up = Direction.UP;
        Vector3f vecFacing = facing.m_253071_().normalize();
        Vector3f vecUp = up.m_253071_().normalize();
        rotation = facing == Direction.UP ? new Quaternionf().fromAxisAngleDeg(1.0f, 0.0f, 0.0f, 90.0f) : (facing == Direction.DOWN ? new Quaternionf().fromAxisAngleDeg(1.0f, 0.0f, 0.0f, -90.0f) : rotation.lookAlong((Vector3fc)vecFacing, (Vector3fc)vecUp));
        if (facing == Direction.WEST || facing == Direction.EAST) {
            rotation = rotation.invert();
        }
        if (be.isConnected()) {
            ChainSide side = AbstractTransmissionChainBlock.getConnection(be.m_58900_()).side();
            Quaternionf connectionRotation = new Quaternionf().fromAxisAngleRad((Vector3fc)facing.m_122424_().m_253071_(), (float)side.rotationAngle);
            rotation = connectionRotation.mul((Quaternionfc)rotation);
        }
        return rotation;
    }

    public record ChainConnection(ChainSide side, ConnectionType type) {
    }

    public static enum ChainSide implements StringRepresentable
    {
        TOP(1.5707963267948966),
        RIGHT(0.0),
        BOTTOM(4.71238898038469),
        LEFT(Math.PI);

        final double rotationAngle;

        private ChainSide(double rotationAngle) {
            this.rotationAngle = rotationAngle;
        }

        public String m_7912_() {
            return Lang.asId((String)this.name());
        }

        public static ChainSide opposite(ChainSide side) {
            return switch (side.ordinal()) {
                default -> throw new IncompatibleClassChangeError();
                case 0 -> BOTTOM;
                case 1 -> LEFT;
                case 2 -> TOP;
                case 3 -> RIGHT;
            };
        }

        public static ChainSide rotate(ChainSide side, Rotation rotation) {
            if (rotation == Rotation.NONE) {
                return side;
            }
            if (rotation == Rotation.COUNTERCLOCKWISE_90) {
                return ChainSide.rotate(ChainSide.opposite(side), Rotation.CLOCKWISE_90);
            }
            if (rotation == Rotation.CLOCKWISE_180) {
                return ChainSide.opposite(side);
            }
            return switch (side.ordinal()) {
                default -> throw new IncompatibleClassChangeError();
                case 0 -> RIGHT;
                case 1 -> BOTTOM;
                case 2 -> LEFT;
                case 3 -> TOP;
            };
        }

        public static ChainSide[] valuesFrom(ChainSide startingSide, boolean excludeStarting) {
            if (startingSide == LEFT && !excludeStarting) {
                return ChainSide.values();
            }
            ArrayList<ChainSide> sides = new ArrayList<ChainSide>(Arrays.asList(ChainSide.values()).subList(startingSide.ordinal() + 1, ChainSide.values().length));
            List<ChainSide> beforeStarting = Arrays.asList(ChainSide.values()).subList(0, startingSide.ordinal() + (excludeStarting ? 0 : 1));
            sides.addAll(beforeStarting);
            return sides.toArray(new ChainSide[0]);
        }
    }

    public static enum ChainDirection implements StringRepresentable
    {
        DOWN(Direction.DOWN, (ImmutableBiMap<ChainSide, Direction>)ImmutableBiMap.of((Object)((Object)ChainSide.TOP), (Object)Direction.NORTH, (Object)((Object)ChainSide.RIGHT), (Object)Direction.EAST, (Object)((Object)ChainSide.BOTTOM), (Object)Direction.SOUTH, (Object)((Object)ChainSide.LEFT), (Object)Direction.WEST)),
        UP(Direction.UP, (ImmutableBiMap<ChainSide, Direction>)ImmutableBiMap.of((Object)((Object)ChainSide.TOP), (Object)Direction.SOUTH, (Object)((Object)ChainSide.RIGHT), (Object)Direction.EAST, (Object)((Object)ChainSide.BOTTOM), (Object)Direction.NORTH, (Object)((Object)ChainSide.LEFT), (Object)Direction.WEST)),
        NORTH(Direction.NORTH, (ImmutableBiMap<ChainSide, Direction>)ImmutableBiMap.of((Object)((Object)ChainSide.TOP), (Object)Direction.UP, (Object)((Object)ChainSide.RIGHT), (Object)Direction.EAST, (Object)((Object)ChainSide.BOTTOM), (Object)Direction.DOWN, (Object)((Object)ChainSide.LEFT), (Object)Direction.WEST)),
        SOUTH(Direction.SOUTH, (ImmutableBiMap<ChainSide, Direction>)ImmutableBiMap.of((Object)((Object)ChainSide.TOP), (Object)Direction.UP, (Object)((Object)ChainSide.RIGHT), (Object)Direction.WEST, (Object)((Object)ChainSide.BOTTOM), (Object)Direction.DOWN, (Object)((Object)ChainSide.LEFT), (Object)Direction.EAST)),
        WEST(Direction.WEST, (ImmutableBiMap<ChainSide, Direction>)ImmutableBiMap.of((Object)((Object)ChainSide.TOP), (Object)Direction.UP, (Object)((Object)ChainSide.RIGHT), (Object)Direction.NORTH, (Object)((Object)ChainSide.BOTTOM), (Object)Direction.DOWN, (Object)((Object)ChainSide.LEFT), (Object)Direction.SOUTH)),
        EAST(Direction.EAST, (ImmutableBiMap<ChainSide, Direction>)ImmutableBiMap.of((Object)((Object)ChainSide.TOP), (Object)Direction.UP, (Object)((Object)ChainSide.RIGHT), (Object)Direction.SOUTH, (Object)((Object)ChainSide.BOTTOM), (Object)Direction.DOWN, (Object)((Object)ChainSide.LEFT), (Object)Direction.NORTH));

        public final Direction direction;
        private final ImmutableBiMap<ChainSide, Direction> directionMap;

        private ChainDirection(Direction direction, ImmutableBiMap<ChainSide, Direction> directionMap) {
            this.direction = direction;
            this.directionMap = directionMap;
        }

        public static ChainDirection of(Direction direction) {
            return switch (direction) {
                default -> throw new IncompatibleClassChangeError();
                case Direction.DOWN -> DOWN;
                case Direction.UP -> UP;
                case Direction.NORTH -> NORTH;
                case Direction.SOUTH -> SOUTH;
                case Direction.WEST -> WEST;
                case Direction.EAST -> EAST;
            };
        }

        public Direction.Axis getAxis() {
            return this.direction.m_122434_();
        }

        public Direction getDirectionFromSide(ChainSide side) {
            return (Direction)this.directionMap.get((Object)side);
        }

        public ChainSide getSideFromDirection(Direction direction) {
            return (ChainSide)((Object)this.directionMap.inverse().get((Object)direction));
        }

        public String m_7912_() {
            return Lang.asId((String)this.name());
        }
    }

    public static enum ConnectionType implements StringRepresentable
    {
        NONE,
        CHAIN,
        BELT;


        public String m_7912_() {
            return Lang.asId((String)this.name());
        }
    }
}

